<?php
/**
 * Скрипт поиска музыки.
 * Ищет с ресурса Вконтате. 
 *
 * Автор: ofroke 
 * ICQ: 531103
 * 
 * Скрипт написан на PHP с использованием MySQL. 
 * Высокая скорость работы скрипта, мизерная нагрузка.
 * Полная поддержка по скрипту.
 *
 * Все права защищены © 2010 - 2011
 */
 
class File_Cache {

	private $dir = '';
	
	public function __construct($dir) {
		$this->dir = $dir;
		
		if(!is_dir($this->dir))
			die('Отсутствует папка для кэша');
			
		elseif(!is_writable($this->dir))
			die('Нет прав на запись кэша');
			
		
	}
	
	public function get($key, $expiration = 86400) {
	
		$cache = $this->_name($key);
		
		if(!file_exists($cache))
			return false;
		
		if(filemtime($cache) < (time() - $expiration)) {
			$this->delete($cache);
			return false;
		}
		
		if(!$cache = file_get_contents($cache))
			return false;
		
		return $cache;
				
	}
	
	public function set($key, $data, $return = true) {
	
		$cache = $this->_name($key, true);
		
		if(trim($data)) {
		
			file_put_contents($cache, $data);
			chmod($cache, 0644);
			if($return) return $data;
			else echo $data;
	
			
		} else
			return false;
		
	}	
	
	public function delete($key) {
	
		$cache = $this->_name($key);
		
		if(file_exists($cache)) {
			unlink($cache);
			return true;
		}
		
		return false;
		
	}
	
	private function _name($key, $create = false) {
		$name = md5($key);
		$dir = substr($name, 0, 1);
		
		if($create) 
			if(!is_dir($this->dir . '/' . $dir)) 
				mkdir($this->dir . '/' . $dir, 0755, true);
		
		
		return sprintf("%s/%s/%s", $this->dir, $dir, $name);
	}
	
}

?>