<?php

class Session {
    
    /** @var (object) Объект для работы с БД */
    private $Db;
    
    /** @var (int) Время жизни сессии в секундах */
    private $lifeTime = 84600;
    
    /** @var (int) Счетчик переходов */
    private $movings;
        
    public function __construct($Db)
    {
        
        $this->Db = $Db;
        
        @ini_set('session.use_trans_sid', FALSE);
        @ini_set('session.use_cookies', TRUE);
        @ini_set('session.use_only_cookies', TRUE);
        @ini_set('session.gc_maxlifetime', $this->lifeTime);
        @ini_set('session.gc_probability', '1');
        @ini_set('session.gc_divisor', '100');
        
        session_set_save_handler(
            array($this, 'sessOpen'),
            array($this, 'sessClose'),
            array($this, 'sessRead'),
            array($this, 'sessWrite'),
            array($this, 'sessDestroy'),
            array($this, 'sessGc')
        );
        
        session_set_cookie_params($this->lifeTime, '/');
        session_name('SID');
        session_start();
        
    }
    
    public function sessOpen()
    {
        
        return TRUE;
        
    }
    
    public function sessClose()
    {
        
        return TRUE;
        
    }
    
    /**
     * Получить данные
     * @param (string) $sid Идентификатор сессии
     */
    
    public function sessRead($sid)
    {

        $query = $this->Db->query("SELECT * FROM `sys_session` WHERE `id` = '" . $this->Db->escapeString($sid) . "'");

        if (($result = $this->Db->fetchAssoc($query)) !== NULL)
        {
            
            $this->movings = $result['movings'];
            return $result['data'];
            
        }
        else
        {
            
            $this->Db->query("INSERT INTO `sys_session` SET `id` = '" . $sid . "'");
            return '';
            
        }
        
    }
    
    /**
     * Записать данные
     * @param (string) $sid Идентификатор сессии
     * @param (string) $data данные для записи
     * @return (boolean)
     */
    
    public function sessWrite($sid, $data = '')
    {
        
        //TODO: Доработать счетчик переходов
        $this->Db->query(
            "UPDATE `sys_session` SET `data` = '" . $this->Db->escapeString($data) . 
            "', `time` = '" . time() . "', `movings` = '" . ($this->movings + 1) . "' WHERE `id` = '" .$this->Db->escapeString($sid) . "'"
        );
        return TRUE;
        
    }
    
    /**
     * Закрыть сессию
     * @return (boolean)
     */
    
    public function sessDestroy($sid)
    {
        
        $this->Db->query("DELETE FROM `sys_session` WHERE `id` = '" . $this->Db->escapeString($sid) . "'");
        return TRUE;
        
    }
    
    /** 
     * Сборка мусора
     * @return (boolean)
     */
     
    public function sessGc()
    {
        
        $this->Db->query("DELETE FROM `sys_session` WHERE `time` < '" . (time() - $this->lifeTime) . "'");
        return TRUE;
        
    }
    
}