<?php

class Conf extends Storage {
    
    /**
     * @param (string) $filename файл конфигурации
     */
    
    public function __construct($filename)
    {
        
        if (!file_exists($filename))
        {
            
            throw new Exception('Error: Configuration file is not found');
            
        }
        
        $filetype = explode('.', $filename);
        
        switch ($filetype[1])
        {
            
            case 'ini':
                $this->storage = parse_ini_file($filename, TRUE);
                break;
            default:
                $this->storage = unserialize(file_get_contents($filename));
            
        }
            
    }
    
}