<?php

/**
 * Получение IP адреса, USER-AGENT'а
 */

class Network {
    
    /** @var (int) IP адрес */
    public $ip;
    
    /** @var (string) User-Agent */
    public $userAgent;

    public function __construct()
    {

        $this->ip = $this->_getIp();
        $this->userAgent = $this->_getUserAgent();
      
    }
    
    /**
     * Получить IP адрес
     * @return (int)
     */
    
    private function _getIp()
    {
        
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) 
        {
            
            $ip = $_SERVER['HTTP_CLIENT_IP'];
            
        }
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            
        }
        else
        {
            
            $ip = $_SERVER['REMOTE_ADDR'];
            
        }
        
        if (!isset($ip))
        {
            
            throw new Exception('Invalid IP');
            
        }
        
        return ip2long($ip);
        
    }
    
    /**
     * Получить User-Agent
     * @return (string)
     */
    
    private function _getUserAgent()
    {
        
        return isset($_SERVER['HTTP_USER_AGENT']) && !empty($_SERVER['HTTP_USER_AGENT']) ? 
            substr($_SERVER['HTTP_USER_AGENT'], 0, 150) : 
            'Undefined';
        
    }
    
}