<?php 

class Router
{
    
    /** @var (string) Имя модуля*/
    public $moduleName;
    
    /** @var (string) Путь к модулю*/
    public $modulePath;
    
    /** @var (string) Вызываемая функция контроллера модуля*/
    public $Action;
    
    /** @var (array) Параметры запроса к модулю */
    public $queryOptions = array();
    
    /** @var (string) страница ошибки */
    public $errorModule;
    
    /** @var (string) путь к модулю страницы ошибки */
    public $errorPath;
    
    /** @var (string) Директорий модулей */
    protected $modulesDir;
    
    /** @var (string) Модуль, загружаемый по умолчанию  */
    protected $defaultModule;
    
    /** @var (string) расширения главного файла модуля */
    protected $ext;
    
    /**
     * @param (array) параметры конфигурации
     * [modulesDir] директорий модулей
     * [defaultModule] модуль загружаемый по умолчанию
     * [errorModule] модуль загружаемый при возникновении ошибки
     * [ext] расширение модулей
     */
     
    public function __construct($Conf)
    {
        
        $this->modulesDir = $Conf['modulesDir'] . DIRECTORY_SEPARATOR;
        $this->ext = $Conf['ext'];
        $this->defaultModule = $Conf['defaultModule'];
        $this->errorModule = $Conf['errorModule'];
        $this->errorPath = ROOTDIR . $this->modulesDir . $this->errorModule . DIRECTORY_SEPARATOR . 'controller' . DIRECTORY_SEPARATOR . $this->errorModule . $this->ext;
        $this->_parseQuery();
        
    }
    
    /**
     * Разбор строки запроса для получения параметров, наименований модуля и действия (action)
     * Пример строки запроса: /module/action/param1/valueOfParam1/param2/valueOfParam2/flag
     */
    protected function _parseQuery()
    {
        
        $uri = $_SERVER['REQUEST_URI'];
        $segments = explode('/', ltrim($uri, '/'));
        
        // Получить имя модуля
        $this->moduleName = !empty($segments[0]) ? $segments[0] : $this->defaultModule;
        
        // Устанавливаем абсолютный путь к модулю
        $this->modulePath = ROOTDIR . $this->modulesDir . $this->moduleName . DIRECTORY_SEPARATOR . 'controller' . DIRECTORY_SEPARATOR . $this->moduleName . $this->ext;
        
        // Метод модуля
        $this->Action = isset($segments[1]) ? $segments[1] : 'index';
        
        // Параметры запроса (аналог _GET)
        $temp = array_slice($segments, 2);
        $total = count($temp);
        
        for ($i = 0, $v = 1; $i < $total; $i+=2, $v+=2)
        {
            
            $this->queryOptions[$temp[$i]] = isset($temp[$v]) ? $temp[$v] : TRUE;    
            
        }
        
        unset($temp, $segments, $uri, $total);   
        
        
    }
    
}