<?php

class Template extends Storage {
    
    public $tplPath = '';
    public $contents = '';
    public $tplDefault = '';
    protected $tplExt = '.php';
    
    public function __construct($default, $ext)
    {
        
        $this->tplExt = $ext;
        $this->tplDefault = $default;
        
    }
    
    public function build()
    {
        
        $this->tplDefault = $this->loadTpl($this->tplDefault . $this->tplExt, TRUE);
        
    }
    
    public function loadTpl($filename = '', $path = FALSE)
    {
        
        if ($path === FALSE)
        {
            
            $filename = $this->tplPath . $filename . $this->tplExt;
            
        }
        
        if (!file_exists($filename))
        {
            
            throw new Exception('Template ' . $filename . ' is not exists');
            
        }
        
        ob_start();
        include_once $filename;
        $contents = ob_get_contents();
        ob_end_clean();
        
        return $contents;
        
    }
    
}