<?php

Error_Reporting(E_ALL | E_STRICT);

if (version_compare(phpversion(), '5.3.0', '<') === TRUE) 
{
    
    exit('PHP version < 5.3');
    
}

@ini_set('arg_separator.output', '&amp;');
@ini_set('php_flag display_errors', TRUE);

date_default_timezone_set('UTC');
mb_internal_encoding('UTF-8');

// Главный директорий
define('ROOTDIR', realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR);
// Директорий файлов ядра системы
define('MAINDIR', ROOTDIR . 'main' . DIRECTORY_SEPARATOR);
// Директорий кэша
define('CACHEDIR', MAINDIR . 'files' . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR);
// Директорий конфигурационных файлов
define('CONFDIR', MAINDIR . 'files' . DIRECTORY_SEPARATOR . 'conf' . DIRECTORY_SEPARATOR);
// Директориий файлов
define('FILESDIR', ROOTDIR . 'files' . DIRECTORY_SEPARATOR);
// Адрес сайта (без слеша)
define('HOMEURL', 'http://' . trim($_SERVER['SERVER_NAME'], "/"));

// Автозагрузка классов
spl_autoload_register(
    function ($class)
    {

        $class = strtolower($class);

        if (file_exists(MAINDIR . 'classes' . DIRECTORY_SEPARATOR . $class . '.php'))
        {
            
            require MAINDIR . 'classes' . DIRECTORY_SEPARATOR . $class . '.php';
            return TRUE;
        }
        else
        {
            
            return FALSE;
            
        }
        
    }
);

// Обработчик неперехваченных исключений
set_exception_handler(
    function ($exception) {
        
        echo $exception->getMessage();
        
    }
);

// Загрузка конфигурации
$Conf = new Conf(CONFDIR . 'system.ini');
// Соединяемся с БД
$Db = new Db($Conf->db['host'], $Conf->db['user'], $Conf->db['password'], $Conf->db['db'], $Conf->db['charset']);
// Получаем IP и юзер агент
$Network = new Network;
// Стартуем сессию
new Session($Db);
// Роутинг
$Router = new Router($Conf->route);
// Шаблонизатор
$Tpl = new Template(FILESDIR . 'defaultpl', '.php');
// Загрузка модуля
$Front = new Front($Router->moduleName, $Router->modulePath, $Router->Action, $Router->errorPath, $Router->errorModule);
$Front->Conf = $Conf;
// Параметры запроса
$Front->QueryOptions = $Router->queryOptions;
$Front->Db = $Db;
// IP адрес
$Front->UserIp = $Network->ip;
// Юзер агент
$Front->UserAgent = $Network->userAgent;
$Front->Tpl = $Tpl;
// Выполняем..
$Front->execute();
// Display
$Tpl->build();
$Response = new Response;
$Response->setOutput($Tpl->tplDefault);
$Response->output();

// Закрываем сессию и соединение с БД
register_shutdown_function(

    function () use ($Db)
    {
        
        session_write_close(); 
        $Db->close();
        
    }

);