<?php
/*
 * @Шаблонизатор:  Native
 * @Версия:        1.0.1
 * @Автор:         Максим Папежук (17 лет)
 * @Автор ВК:      http://vk.com/id159732810
 * @Помогите автору рублями: R171726141843
 */

class Native {
    //Переменные шаблона
    var $vars = array();

    /*
     * Настройки
     */

    //Перекомпилировать шаблон?
    var $recompile_tpl = false;

    //Перекомпилировать каждые * сек
    var $recompile_time = 120;

    //Перекомпилировать если отличаются размеры
    var $recompile_if_new = true;

    //Папка с шаблонами
    var $tpl_dir = 'tpl/';

    //Папка с компилированными шаблонами
    var $compile_dir = 'compile/';


    /*
     * (Де)Конструирование шаблонизатора
     */
    function __construct() {return;}
    function __destruct () {return;}

    /*
     * Отображение шаблона
     */
    function display ($tpl_name, $recompile = false) {
        //Перекомпилировать шаблон
        $recompile = $recompile ? $recompile : $this->recompile_tpl;
        //Компилим
        self::compile($tpl_name, $recompile);
        //Отображаем шаблон
        require $this->compile_dir . $tpl_name . '.php';

        return true;
    }

    /*
     * Компиляция шаблона
     */
    function compile ($tpl_name, $recompile) {
        //Если компил есть - получаем информацию о нем
        if (file_exists($this->compile_dir . $tpl_name . '.ini'))
            $data = parse_ini_file($this->compile_dir . $tpl_name . '.ini');

        //Шаблон
        $tpl = file_get_contents($this->tpl_dir . $tpl_name);

        //Перекомпилируем шаблон
        if ($data['recompile_tpl'] && $data['exp_time'] < time() && file_exists($this->tpl_dir . $tpl_name) ||
            !file_exists($this->compile_dir . $tpl_name . '.php') ||
            self::parse_tpl( $tpl) != file_get_contents($this->compile_dir . $tpl_name . '.php')) {

            //Парсим шаблон
            $tpl = self::parse_tpl($tpl);

            //Инфа о компиленном файле
            $time = time();
            $exp_time = $time+$this->recompile_time;
            $recompile = $recompile ? "1" : "0";
            $ini = "\r\n//Genereted time: {$time}\r\n//Generated by: Native Templater\r\n\r\nexp_time = \"{$exp_time}\"\r\nrecompile_tpl = \"{$recompile}\"\r\n";

            //Сохраняем компиленный шаблон
            file_put_contents($this->compile_dir . $tpl_name . '.php', $tpl);

            //Сохраняем инфу о нем
            file_put_contents($this->compile_dir . $tpl_name . '.ini', $ini);
        }

        return true;
    }

    /*
     * Парсим содержимое
     */
    function parse_tpl ($tpl) {
        /*
         * Парсинг переменных
         */
        preg_match_all('/\{([$|=$]+)([A-z0-9_]+)(\[.+\])*}/', $tpl, $vars);
        for ($N = 0; $N < count($vars[0]); $N++) {
            //Массив/переменная
            $array = $vars[3][$N];

            //Вывод/Чтение переменной
            $read = $vars[1][$N] == '$' ? '$this->vars["' . $vars[2][$N] . '"]' . $array : '<?=$this->vars["' . $vars[2][$N] . '"]' . $array . '?>';

            //Искомая комбинация
            $search = $vars[0][$N];

            //Перезаписываем переменные
            $tpl = str_replace($search, $read, $tpl);
        }

        /*
        * Парсинг натив кода
        */
        preg_match_all("/\{(.+?)\}/s", $tpl, $native);
        for ($N = 0; $N < count($native[0]); $N++) {
            $tpl = str_replace($native[0][$N], "<? " . $native[1][$N] . " ?>", $tpl);
        }

        //Результат
        return $tpl;
    }

    /*
     * Добавление переменной
     */
    function assign ($var_name, $value) {
        $this->vars[$var_name] = $value;
        return true;
    }

    /*
     * Чтение содержимого переменной
     */
    function get_variable($var_name) {
        return $this->vars[$var_name];
    }

    /*
     * Возвращение массива с переменными шаблонизатора
     */
    function get_variables() {
        return $this->vars;
    }
}
?>