<?php

/**
 * This file contains base system configuration
 */

$root = realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
$main = $root . 'main' . DIRECTORY_SEPARATOR;

return array(
    /* Root directory */
    'RootDir' => $root,
    /* Directory of kernel */
    'MainDir' => $main,
    /* Directory of libraries */
    'LibDir' => $main . 'lib' . DIRECTORY_SEPARATOR,
    /* Directory of Cache-files */
    'CacheDir' =>  $main . 'files' . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR,
    /* Directory of configuration files */
    'ConfDir' =>  $main . 'files' . DIRECTORY_SEPARATOR . 'conf' . DIRECTORY_SEPARATOR,
    /* Directory of log-files */
    'LogDir' => $main . 'files' . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR,
    /* Directory of files */
    'FilesDir' => $root . 'files' . DIRECTORY_SEPARATOR,
    /* Address of site (without slash) */
    'HomeUrl' => 'http://' . trim($_SERVER['SERVER_NAME'], "/"),
    /* Display exceptions: TRUE - on display; FALSE - to log file */
    'OutputExceptions' => TRUE
);