<?php

/**
 * Request
 *
 * Set Ip address, User-Agent. Handle URI
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */

class Request {

    /** @var (int)
     * IP address
     * @access public
     */
    public $Ip;

    /**
     * @var (string)
     * User Agent
     * @access public
     */
    public $UserAgent;

    /**
     * @var (string)
     * Name of module
     * @access public
     */
    public $Module = '';

    /** @var (string)
     * Name of action
     * @access public
     */
    public $Action = '';

    /**
     * @var (array)
     * Parameters of query (for replace _GET)
     * @access public
     */
    public $QueryOptions = array();

    public function __construct()
    {

        $this->Ip = $this->setIp();
        $this->UserAgent = $this->setUserAgent();
        $query = $this->uriHandler();

        if (!empty($query['module']))
        {

            $this->Module = $query['module'];

        }

        if (!empty($query['action']))
        {

            $this->Action = $query['action'];

        }

        if (!empty($query['params']))
        {

            $this->QueryOptions = $query['params'];

        }

    }

    /**
     * Set Ip address
     * @throws Base_Exception
     * @return (int)
     */

    protected function setIp()
    {

        if (!isset($_SERVER['REMOTE_ADDR']))
        {

            throw new Base_Exception('Invalid IP');

        }

        return ip2long($_SERVER['REMOTE_ADDR']);

    }

    /**
     * Set User-Agent
     * @access protected
     * @return (string)
     */

    protected function setUserAgent()
    {

        return !empty($_SERVER['HTTP_USER_AGENT'])
               ? substr($_SERVER['HTTP_USER_AGENT'], 0, 150)
               : 'Undefined';

    }

    /**
     * Handle URI
     * Example of URI http://host/module/action/param/value/flag
     * Description of result
     * ['module'] (string) name of module
     * ['action'] (string) action
     * ['params'] (array)  query parameters
     * @access protected
     * @return (array) result of handle
     * @return (void)
     */

    protected function uriHandler()
    {

        $uri = explode('?', $_SERVER['REQUEST_URI']);
        $segments = explode('/', ltrim($uri[0], '/'));
        $return = array('module' => '', 'action' => '', 'params' => array());

        if (is_array($segments))
        {

            /* Module */
            if (!empty($segments[0]))
            {

                $return['module'] = $segments[0];

            }

            /* Action */
            if (isset($segments[1]))
            {

                $return['action'] = $segments[1];

            }

            /* Query parameters (for replace _GET) */
            $temp = array_slice($segments, 2);
            $total = count($temp);

            for ($i = 0, $v = 1; $i < $total; $i+=2, $v+=2)
            {

                if (!empty($temp[$i]))
                {

                    $return['params'][$temp[$i]] = isset($temp[$v]) ? $temp[$v] : TRUE;

                }

            }

            unset($temp, $total);

        }

        unset($segments, $uri);

        return $return;

    }

}