<?php

/**
 * Base controller
 *
 * It's base controller for your modules' controllers.
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */

abstract class Base_Controller extends Storage {

    /**
     * Method, which called by default.
     * @access public
     * @abstract
     * @return (void)
     */
    public abstract function index();

    /**
     * Constructor
     * @access public
     * @param  (array) $storage storage for objects
     * @return (void)
     */
    public function __construct(array $storage)
    {

        $this->storage = $storage;
        unset($storage);

        /* Setup path to current child controller */
        $this->CurrentPath = $this->Conf->route->directory . DIRECTORY_SEPARATOR .
                             strtolower(str_replace('_Controller', '', get_class($this))) . DIRECTORY_SEPARATOR;
        /* Setup path to controller's templates */
        $this->Tpl->Path = $this->CurrentPath . 'views' . DIRECTORY_SEPARATOR;

        /* Set variables default for main template */
        $this->Tpl->setData('pageTitle', '');
        $this->Tpl->setData('content', '');

    }

    /**
     * Loader
     * loading model or helper
     * @access protected
     * @final
     * @param  (string) $name Name of object.
     * @param  (string) $type Type of object. The possible values for this parameter: helper, model
     * @throws Base_Exception
     * @return (mixed)
     */
    protected final function load($name, $type)
    {

        switch($type)
        {

            case 'model':
                return $this->loadModel($name);
                break;
            case 'helper':
                return $this->loadHelper($name);
                break;
            default:
                throw new Base_Exception(__CLASS__ . '::load wrong type given: ' . $type, __CLASS__);

        }

    }

    /**
     * Loading model
     * @access private
     * @param  (string) $name name of model
     * @throws Base_Exception
     * @return (object)
     */
    private function loadModel($name)
    {

        $model = $this->CurrentPath . 'model' . DIRECTORY_SEPARATOR . strtolower($name) . $this->Conf->route->ext;
        $name .= '_Model';

        if (!file_exists($model))
        {

            throw new Base_Exception('Unable to load model: ' . $model, __CLASS__);

        }

        include_once $model;

        if (!class_exists($name))
        {

            throw new Base_Exception('Unable to load model: class ' . $name . ' is not exists', __CLASS__);

        }

        return new $name($this->Db);

    }

    /**
     * Loading helper
     * @access private
     * @param  (string) $name Name of helper.
     * @throws Base_Exception
     * @return (null)
     */
    private function loadHelper($name)
    {

        $helper = $this->CurrentPath . 'helpers' . DIRECTORY_SEPARATOR . $name . $this->Conf->route->ext;

        if (!file_exists($helper))
        {

            throw new Base_Exception('Unable to load helper: ' . $helper, __CLASS__);

        }

        include_once $helper;
        return;

    }

}