<?php

/**
 * General class of system.
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */
class Front extends Storage {

    /**
     * Constructor
     * @access public
     * @param  (array) $configuration Base system configuration
     * @return (void)
     */
    public function __construct($configuration)
    {

        /* Loading configuration */
        $this->Conf = new Conf($configuration['ConfDir'] . 'system.ini');
        $this->Conf->System = $configuration;
        unset($configuration);
        /* Get IP address, User-Agent, Action. Get Query parameters (from URI).  Cleaning _GET array.*/
        $request = new Request;
        $this->UserIp = $request->Ip;
        $this->UserAgent = $request->UserAgent;
        $this->Action = $request->Action;
        $_GET = array();
        $this->QueryOptions = $request->QueryOptions;

        /* Connect with mysql server */
        $this->Db = new Db($this->Conf->db);

        /* To start session */
        new Session($this->Db);

        /* Set absolute path to default templates */
        $this->Conf->template->directory = $this->Conf->System->RootDir . $this->Conf->template->directory;
        /* Handler of templates */
        $this->Tpl = new Template($this->Conf->template);
        /* Response object */
        $this->Response = new Response;

        /* Set absolute path to modules */
        $this->Conf->route->directory = $this->Conf->System->RootDir . $this->Conf->route->directory;
        /* Router */
        $this->Router = new Router($this->Conf->route, $request->Module, $request->Action, $this->storage);

        /* Show result */
        $this->Response->output($this->Tpl->render());

        /* Close session and connection with mysql server */
        register_shutdown_function(array($this, 'shutdown'));

    }

    /**
     * Close session and connection with mysql server
     * This function must have public access for using in register_shutdown_function()
     * @access public
     * @return (void)
     */
    public function shutdown()
    {

        session_write_close();
        $this->Db->close();

    }

}