<?php

/**
 * Session
 *
 * Working with sessions using mysql database.
 *
 * @package System
 * @author Screamer <nwotnbm@gmail.com>
 * @version 0.1
 */

class Session {

    /**
     * @var (object)
     * The object for working with database
     * @access private
     */
    private $Db;

    /**
     * @var (int)
     * Session lifetime (in seconds)
     * @access private
     */
    private $lifeTime = 84600;

    /**
     * @var (int)
     * Hits counter
     * @access private
     */
    private $movings;

    /**
     * Constructor
     * Setup session parameters. Setup handlers
     * @access public
     * @param  (object) The object for working with database
     * @return (void)
     */

    public function __construct($Db)
    {

        if (!is_object($Db))
        {

            throw new Base_Exception('Session::__construct. Parameter is non object', __CLASS__);

        }

        $this->Db = $Db;

        @ini_set('session.use_trans_sid', FALSE);
        @ini_set('session.use_cookies', TRUE);
        @ini_set('session.use_only_cookies', TRUE);
        @ini_set('session.gc_maxlifetime', $this->lifeTime);
        @ini_set('session.gc_probability', '1');
        @ini_set('session.gc_divisor', '100');

        session_set_save_handler(
            array($this, 'sessOpen'),
            array($this, 'sessClose'),
            array($this, 'sessRead'),
            array($this, 'sessWrite'),
            array($this, 'sessDestroy'),
            array($this, 'sessGc')
        );

        session_set_cookie_params($this->lifeTime, '/');
        session_name('SID');
        session_start();

    }

    /**
     * Cap
     * Open session
     * @access public
     * @return (boolean)
     */

    public function sessOpen()
    {

        return TRUE;

    }

    /**
     * Cap
     * Close session
     * @access public
     * @return (boolean)
     */

    public function sessClose()
    {

        return TRUE;

    }

    /**
     * Get data
     * @access public
     * @param  (string) $sid session id
     * @return (string)
     */

    public function sessRead($sid)
    {

        $query = $this->Db->query("SELECT * FROM `sys_session` WHERE `id` = '" . $this->Db->escapeString($sid) . "'");
        $result = $this->Db->fetchAssoc($query);

        if ($result !== NULL)
        {

            $this->movings = $result['movings'];
            return $result['data'];

        }
        else
        {

            $this->Db->query("INSERT INTO `sys_session` SET `id` = '" . $sid . "'");
            return '';

        }

    }

    /**
     * Write data
     * @access public
     * @param  (string) $sid  session id
     * @param  (string) $data data
     * @return (boolean)
     */

    public function sessWrite($sid, $data = '')
    {

        //TODO: Доработать счетчик переходов
        $this->Db->query(
            "UPDATE `sys_session` SET `data` = '" . $this->Db->escapeString($data) .
            "', `time` = '" . time() . "', `movings` = '" . ($this->movings + 1) . "' WHERE `id` = '" .$this->Db->escapeString($sid) . "'"
        );
        return TRUE;

    }

    /**
     * Destroy session
     * @access public
     * @param  (string)  $sid sesion id
     * @return (boolean)
     */

    public function sessDestroy($sid)
    {

        $this->Db->query("DELETE FROM `sys_session` WHERE `id` = '" . $this->Db->escapeString($sid) . "'");
        return TRUE;

    }

    /**
     * Garbage collector
     * @access public
     * @return (boolean)
     */

    public function sessGc()
    {

        $this->Db->query("DELETE FROM `sys_session` WHERE `time` < '" . (time() - $this->lifeTime) . "'");
        return TRUE;

    }

}