<?php

class ErrorPage_Controller extends Base_Controller {

    public function index()
    {

        $data = array();

        switch($this->Action)
        {

            case 403:
                $data['errorCode'] = 403;
                $data['errorMessage'] = 'Forbidden';
                break;
            case 500:
                $data['errorCode'] = 500;
                $data['errorMessage'] = 'Internal Server Error';
                break;
            case 404: // No Break!
            default:
                $data['errorCode'] = 404;
                $data['errorMessage'] = 'Not found';

        }

        $this->Tpl->setTemplate('content', 'error', $data);

    }

}