<?php

/**
 * @author no-tactic
 * @copyright 2012
 */
 
require_once 'stringparser_bbcode.class.php';

function verification ($nick, $txt, $captcha, $adm) { // проверка введенных данных, нужно добавить капчу
    $error = 0;
    $txtError = '';
    if($adm == 0) {
        if (strtoupper($_SESSION['captcha']) != strtoupper($captcha)) {
            $error = 1; // маячок об ошибке
            $txtError .= 'Код с картинки не верен! '; // текст ошибки
        }
        unset($_SESSION['captcha']);
         
        if(mb_strtolower($nick) == 'admin' or empty($nick)){ //проверка на допустимость ника
            $error = 1; // маячок об ошибке
            $txtError .= 'Недопустимый никнейм! '; // текст ошибки
        }
    }
    if(empty($txt)){ // проверка текста
        $error = 1; // маячок об ошибке
        $txtError .= 'Поле ввода текста не может быть пустым! ';  // текст ошибки
    }  
    if($error == 0) { // если нет маячка об ошибке добавляем сообщение в массив
        $data[0] = 0; // маячок добавление сообщения прошло успешно
        if($adm == 0)
            $data[] = trim(htmlspecialchars($nick)); // обработка ника
        else 
            $data[] = '<font color="red">'.$nick.'</font>';
        $data[] = trim(htmlspecialchars($txt)); // обработка текста
    } else { // иначе добавляем в массив маячок об ошибке и текст ошибки
        $data[0] = 1; // маячок
        $data[] = $txtError; // текст ошибки 
    }
    return $data;
}


function postAdd($m) // функция записи данных в бд
{
    return mysql_query("INSERT INTO posts SET 
        name = '" . $m[1] . "',
        txt = '" . $m[2] . "',
        data = '" . date("j M Y -  H.i") . "'"
    );
}

function addAnswer($id, $txt) {
        return mysql_query("UPDATE posts SET answer = '" . $txt . "'  WHERE id = " . $id);
}

function delPost($id){
    return mysql_query("DELETE FROM posts WHERE id = " . $id); 
}

function printPosts($id, $count, $a){ //функция вывода данных из бд
    $query = "SELECT * FROM posts ORDER BY id DESC LIMIT $id, $count"; // создаем запрос
    $result = mysql_query($query); // выполняем
    $i = 0;
    while($rows = mysql_fetch_array($result)) {
        echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
        echo '<b class="nick">' . $rows['name'] . '</b>';
        $adm = $a == true ? ' | <a href="?act=del&id='.$rows['id'].'">del</a> | <a href="?act=ans&id='.$rows['id'].'">ans</a> ' : '';
        echo '<small class="date">' . $rows['data'] . $adm .'</small>'; // выводим
        echo '<p class="message">' . bbcode(smiles($rows['txt'])) . '</p></div>';
        echo empty($rows['answer']) ? '' : '<p class="answer">Ответ: ' . $rows['answer'] . '</p>';
        
        $i++;
    }
    
}

function str($page, $c) { // постраничная навигация 
    $query = "SELECT count(*) FROM posts"; // создаем запрос на получение колва строк
    $res = mysql_query($query); 
    $row = mysql_fetch_row($res);
    $total = intval(($row[0] - 1) / $c) + 1; //количество страниц
    for($i = 1; $i <= $total; $i++) {
        if ($i - 1 == $page) 
            echo $i . " "; // оставляем страницу на которой находимся текстовой
        else
            echo '<a href="?page=' . $i . '">' . $i . "</a> "; // выводим ссылки на страницы
    }
    
}

/////////////////// огромная часть для bb кодов ///////////////
 
//Функция для обработки ссылок
function do_bbcode_url ($action, $attributes, $content, $params, $node_object) {
    if (!isset ($attributes['default'])) {
        $url = $content;
        $text = htmlspecialchars ($content);
    } else {
        $url = $attributes['default'];
        $text = $content;
    }
    //Часть функции, которая занимается
    //только валидацией данных тэга
    if ($action == 'validate') {
        if (substr ($url, 0, 5) == 'data:' || substr ($url, 0, 5) == 'file:'
          || substr ($url, 0, 11) == 'javascript:' || substr ($url, 0, 4) == 'jar:') {
            return false;
        }
        return true;
    }
    //Непосредственное преобразование тэга в
    //html вариант с возвращением результата
    return '<a href="'.htmlspecialchars ($url).'">'.$text.'</a>';
}
// Функция для вставки изображений
function do_bbcode_img ($action, $attributes, $content, $params, $node_object) {
    //Часть функции, которая занимается
    //только валидацией данных тэга
    if ($action == 'validate') {
        if (substr ($content, 0, 5) == 'data:' || substr ($content, 0, 5) == 'file:'
          || substr ($content, 0, 11) == 'javascript:' || substr ($content, 0, 4) == 'jar:') {
            return false;
        }
        return true;
    }
    //Непосредственное преобразование тэга в
    //html вариант с возвращением результата
    return '<img src="'. $content .'" alt=""/>';
}


function bbcode($text) {
    $bbcode = new StringParser_BBCode();
    
    //[b]выделенный текст[/b]
    $bbcode->addCode ('b', 'simple_replace', null, array ('start_tag' => '<b>', 'end_tag' => '</b>'),
                      'inline', array ('listitem', 'block', 'inline', 'link'), array ());

    //[i]наклонный текст[/i]
    $bbcode->addCode ('i', 'simple_replace', null, array ('start_tag' => '<i>', 'end_tag' => '</i>'),
                      'inline', array ('listitem', 'block', 'inline', 'link'), array ());
                      
    //[u]подчеркнутый текст[/u]
    $bbcode->addCode ('u', 'simple_replace', null, array ('start_tag' => '<u>', 'end_tag' => '</u>'),
                      'inline', array ('listitem', 'block', 'inline', 'link'), array ());
                      
    //[s]зачеркнутый текст[/s]
    $bbcode->addCode ('s', 'simple_replace', null, array ('start_tag' => '<s>', 'end_tag' => '</s>'),
                      'inline', array ('listitem', 'block', 'inline', 'link'), array ());
     
    //[quote]цитата[/quote]
    $bbcode->addCode ('quote', 'simple_replace', null, array ('start_tag' => '<quote>', 'end_tag' => '</quote>'),
                      'inline', array ('listitem', 'block', 'inline', 'link'), array ());                 
    
    //[url]http://www.needsite.domain[/url] 
    //[url=http://www.needsite.domain]Текст ссылки[/url]
    $bbcode->addCode ('url', 'usecontent?', 'do_bbcode_url', array ('usecontent_param' => 'default'),
                      'link', array ('listitem', 'block', 'inline'), array ('link'));

    //[img]http://www.needsite.domain/img.jpg[/img]
    $bbcode->addCode ('img', 'usecontent', 'do_bbcode_img', array (),
                      'image', array ('listitem', 'block', 'inline', 'link'), array ());
    $bbcode->setOccurrenceType ('img', 'image');
    $bbcode->setMaxOccurrences ('image', 3);
    $bbcode->setRootParagraphHandling (true);
    return $bbcode->parse($text);
}

function smiles($text) {
    $query = "SELECT * FROM smiles"; // создаем запрос
    $result = mysql_query($query); // выполняем
    while($rows = mysql_fetch_array($result)) {
        $text = str_replace($rows['name'], "<img src='smiles/" . $rows['link'] . "' title='". $rows['name'] ."' />", $text);
    }
    return $text;
}

?>