(function($){
  jQuery.fn.invaders = function(){

    var tElement, e;            // tElement - элемент $(this), e - экран
    var options, set, objects;

/*-------------------------------------------------------------------*/
// Основной обработчик

    var handler = function(){
        tElement = $(this);
        setParams();
        createScreen();
    }

/*-------------------------------------------------------------------*/
// Коректировка и обнуление параметров

    var setParams = function(){
        options = {
            bhSpeed:    0.005,      // Скорость перемещения жуков по горизонтали (% от экрана за сек.)
            bvSpeed:    0.0005,     // Скорость перемещения жуков по вертикали   (% от экрана за сек.)
            bsIncrease: 1.5,        // Увеличение скорости перемещения жуков     (% от пред. скорости раунда)
            shipSpeed:  0.2,        // Скорость перемещения корабля              (% от экрана за сек.)
            shellSpeed: 1.2,        // Скорость снаряда                          (% от экрана за сек.)
            bsTime:     3,          // Периодичность выстрелов жуков             (сек.)
            bsSpeed:    0.5,        // Скорость снаряда жуков
            lifes:      3,          // Количество жизней
            fps:        40,         // Количество кадров на секунду
        };

        // Переменные параметры
        set = {
            key:     false,            // Нажатая кнопка
            fire:    false,            // Зажат ли огонь (флаг)
            timer:   false,            // Основной таймер
            bTimer:  false,            // Таймер для движения строя жуков
            bsTimer: false,            // Таймер выстрелов жуков
            bpTimer: false,            // Таймер бонусной тарелки
            play:    false,            // Определяет запущена ли игра
            cStack:  '',               // Стек для кода Conamy
            bDir:    1,                // Горизонтальное направление жуков
            frames:  0,                // Прокручено фреймов в текущем раунде
            level:   0                 // Раунд
        };
    }

/*-------------------------------------------------------------------*/
// Создание экрана

    var createScreen = function(){
        // Объекты игры
        objects = {
            ship:      false,        // Корабль
            bunkers:   new Array(),  // Массив бункеров
            formation: false,        // Строй жуков
            bonus:     false,        // Бонусная летающая тарелка
            score:     false,        // Счет
            lifes:     false,        // Жизни
            level:     false,        // Индикатор раунда
            info:      false,        // Информация о вызове помощи
            wPause:    false,        // Окно паузы
            wGameOver: false,        // Окно оповещения о проигрыше
            wMain:     false,        // Окно начала игры
            wInfo:     false         // Окно помощи
        }

        // Окно
        e = $('<div></div>').attr('id', 'screen').appendTo(tElement);

        newTop  = ($(window).height() / 2) - (e.outerHeight() / 2); if(newTop < 0) newTop   = 0;
        newLeft = ($(window).width() / 2) - (e.outerWidth() / 2);   if(newLeft < 0) newLeft = 0;

        e.css({
            left: newLeft + 'px',
            top:  newTop + 'px'
        });

        // Корабль
        objects.ship = $('<div></div>').attr('id', 'ship').appendTo(e).css('left', (e.innerWidth() / 2 - 16) + 'px');

        // Счет
        objects.score = $('<div></div>').addClass('score').html('0').appendTo(e);

        // Жизни
        objects.lifes = $('<div></div>').addClass('lifes').html(options.lifes).appendTo(e);

        // Индикатор раунда
        objects.level = $('<div></div>').addClass('level').html('0').appendTo(e);

        // Информация о вызове помощи
        objects.info = $('<div></div>').addClass('i-info').html('[H] - Controls').appendTo(e);

        // Окно паузы
        objects.wPause = $('<div></div>').addClass('window pause').appendTo(e).hide();
        $('<div></div>').addClass('w-panel').html(
            '<div class="caption">Pause</div>' +
            '<table width="100%">' +
            '<tr><td align="right" style="padding-right: 9px;"><img src="theme/images/bug1.png" alt="Bug"/></td><td align="left"> = 10</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug2.png" alt="Bug"/></td><td align="left"> = 15</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug3.png" alt="Bug"/></td><td align="left"> = 25</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug4.png" alt="Bug"/></td><td align="left"> = 35</td></tr>' +
            '</table>' +
            'Press [P] to start'
        ).appendTo(objects.wPause);

        // Окно конца игры
        objects.wGameOver = $('<div></div>').addClass('window game-over').appendTo(e).hide();
        $('<div></div>').addClass('w-panel').html(
            'Game over!<br/>' +
            'Press [Enter] to start new game'
        ).appendTo(objects.wGameOver);

        // Окно паузы
        objects.wMain = $('<div></div>').addClass('window main').appendTo(e).hide();
        $('<div></div>').addClass('w-panel').html(
            '<div class="caption">Space Invaders</div>' +
            '<table width="100%">' +
            '<tr><td align="right" style="padding-right: 9px;"><img src="theme/images/bug1.png" alt="Bug"/></td><td align="left"> = 10</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug2.png" alt="Bug"/></td><td align="left"> = 15</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug3.png" alt="Bug"/></td><td align="left"> = 25</td></tr>' +
            '<tr><td align="right"><img src="theme/images/bug4.png" alt="Bug"/></td><td align="left"> = 35</td></tr>' +
            '</table>' +
            'Press [Enter] to start'
        ).appendTo(objects.wMain);

        // Окно помощи
        objects.wInfo = $('<div></div>').addClass('window info').appendTo(e).hide();
        $('<div></div>').addClass('w-panel').html(
            '<div class="caption">Controls</div>' +
            '<table>' +
            '<tr><td>[P] or [Pause]</td><td>- Pause/Play</td></tr>' +
            '<tr><td>[<] and [>]</td><td>- Move the ship</td></tr>' +
            '<tr><td>[Space]</td><td>- Shoot</td></tr>' +
            '<tr><td>[H]</td><td>- Help</td></tr>' +
            '</table>'
        ).appendTo(objects.wInfo);

        $(window).bind({
            keydown: function(e){ if(e.keyCode == 72) objects.wInfo.show(); },
            keyup:   function(e){ if(e.keyCode == 72) objects.wInfo.hide(); }
        });

        // Корекция позиции окон
        $('div.window div.w-panel').each(function(){
            $(this).css({
                left: (e.innerWidth() / 2 - $(this).innerWidth() / 2) + 'px',
                top: (e.height() / 2 - $(this).innerHeight() / 2 - 100) + 'px'
            });
        });

        // Звуки
        $('<audio></audio>').attr('id', 's-lazer').html('<source src="sounds/lazer.ogg"><source src="sounds/lazer.mp3">').appendTo(e);
        $('<audio></audio>').attr('id', 's-bang').html('<source src="sounds/bang.ogg"><source src="sounds/bang.mp3">').appendTo(e);

        newGame();
    };

/*-------------------------------------------------------------------*/
// Создание бункеров

    var buildBunkers = function(){
        for(i in objects.bunkers){ objects.bunkers[i].remove(); }

        for(i = 0; i < 4; i++)
        {
            objects.bunkers[i] = $('<div></div>').addClass('bunker').attr('bid', i).appendTo(e);
            objects.bunkers[i].css('left', (50 + (200 * i)) + 'px').data('hp', 255);
        }
    }

/*-------------------------------------------------------------------*/
// Инициализация Conamy кода

    var initConamy = function(){
        e.toggleClass('conamy');
    }

/*-------------------------------------------------------------------*/
// Создание новой игры

    var newGame = function(){
        objects.wMain.show();
        objects.score.html('0');
        setLifes(options.lifes);
        buildBunkers();

        $(document).bind('keyup', function(e){
            if(e.keyCode == 13)
            {
                newLevel();
                start();
            }
        });
    }

/*-------------------------------------------------------------------*/
// Старт

    var start = function(){
        set.play = true;

        // Создаем обновление экрана с заданым fps
        changeFrame();
        moveBugs();
        bugShoot(true);
        bonusPlate(true);
        objects.wPause.hide();
        objects.wMain.hide();
        objects.wGameOver.hide();

        // Привязываем обработчики на кнопки
        $(document).unbind();

        $(document).bind({
            keydown: function(e) { set.key = (e.keyCode == 37 || e.keyCode == 39 ? e.keyCode : set.key); },
            keyup:   function(e) { set.key = (e.keyCode == 37 || e.keyCode == 39 ? false     : set.key); }
        });

        $(document).bind({
            keydown: function(event){
                if(event.keyCode == 32) set.fire = true;
                else if(event.keyCode == 80 || event.keyCode == 19) pause();
            },
            keyup: function(event){
                if(event.keyCode == 32) set.fire = false;
                set.cStack = event.keyCode + '' + set.cStack;
                set.cStack = set.cStack.substring(0, 20);
                if(set.cStack == '65663937393740403838') initConamy();
            }
        });
    }

/*-------------------------------------------------------------------*/
// Пауза

    var pause = function(){
        set.play = false;
        clearTimeout(set.timer); clearTimeout(set.bTimer); clearTimeout(set.bsTimer);

        objects.wPause.fadeIn(200);
        $(document).unbind();
        $(document).bind('keydown', function(e){
            if(e.keyCode == 80 || e.keyCode == 19)
                start();
        });
    }

/*-------------------------------------------------------------------*/
// Game over

    var gameOver = function(){
        set.play = false;
        clearTimeout(set.timer); clearTimeout(set.bTimer); clearTimeout(set.bsTimer);

        objects.wGameOver.fadeIn(200);
        objects.formation.remove();
        $('div.shell').remove();

        $(document).unbind().bind('keyup', function(e){
            if(e.keyCode == 13)
            {
                setParams();
                newGame();
            }
        });
    }

/*-------------------------------------------------------------------*/
// Генерация нового раунда

    var newLevel = function(row){
        if(!row) row = 1;

        // Коректируем параметры и создаем строй
        if(row == 1)
        {
            $('div.formation').remove()
            objects.formation = $('<div></div>').addClass('formation').appendTo(e);
            ++set.level;
            setLevel();
            set.key  = false;
            set.bDir = 1;
            set.frames = 0;
            if(set.level > 1)
            {
                options.bhSpeed *= options.bsIncrease;
                options.bvSpeed *= options.bsIncrease;
                options.bsSpeed  = (options.bsSpeed * options.bsIncrease < 1.5 ? options.bsSpeed * options.bsIncrease : options.bsSpeed);
                options.bsTime   = (options.bsTime * 0.66 > 0.1 ? options.bsTime * 0.66 : options.bsTime);
                addScore((set.level - 1) * 100);
                setLifes(options.lifes + 1);
            }
        }

        // Определяем тип жука
             if (row == 5) bugType = 4;
        else if (row == 4) bugType = 3;
        else if (row == 3) bugType = 2;
        else               bugType = 1;

        // Создаем ряд
        for(i = 1; i <= 10; i++){
            nBug = $('<div></div>').addClass('bug bug' + bugType);
            if(row == 1) nBug.appendTo(objects.formation);
            else         nBug.insertBefore(objects.formation.find('div.bug:first'));
        }

        // Создаем следующий ряд через 300(мс)
        if(row < 5)
            setTimeout(function(){ newLevel(++row); }, 300);
    }

/*-------------------------------------------------------------------*/
// Смена кадра

    var changeFrame = function(){
        if(!set.play) return true;

        // Стреляем если зажат пробел
        if(set.fire && !e.find('div.shell[dir=1]').length)
            createShell(1);

        // Двигаем корабль если зажата кнопка
        if((set.key == 37 && (objects.ship.offset().left - 4) > e.offset().left) || (set.key == 39 && (objects.ship.offset().left + objects.ship.innerWidth()) < (e.offset().left + e.width() + 3)))
        {
            newPos = (parseInt(objects.ship.css('left')) + (set.key == 37 ? -1 : 1.15) * e.innerWidth() * options.shipSpeed / options.fps);
            objects.ship.css('left', newPos + 'px');
        }

        // Двигаем снаряды
        e.find('div.shell').each(function(){ moveShell($(this)); });

        // Двигаем бонусную тарелку
        moveBonus();

        ++set.frames;
        set.timer = setTimeout(function(){ changeFrame() }, (1000 / options.fps));
    }

/*-------------------------------------------------------------------*/
// Движение жуков

    var moveBugs = function(){
        if(!set.play) return true;

        // Меняем позицию
        bNewLeft = (parseInt(objects.formation.css('left')) + (set.bDir * e.innerWidth() * options.bhSpeed / 4));
        bNewTop = 30 + e.innerHeight() * options.bvSpeed * set.frames / options.fps * 4;

        objects.formation.css({
            left: bNewLeft + 'px',
            top:  bNewTop + 'px'
        });

        // Меняем направление при достижении края экрана
        if((bNewLeft + objects.formation.width()) > (e.width() + 30) || (bNewLeft < -10))
        {
            set.bDir *= -1;
            moveBugs();
            return true;
        }

        // Заканчиваем игру если жуки дошли до края
        if((objects.formation.offset().top + objects.formation.height()) >= (e.offset().top + e.height()))
            gameOver();

        set.bTimer = setTimeout(function(){ moveBugs() }, 250);
    }

/*-------------------------------------------------------------------*/
// Выстрел жуков

    var bugShoot = function(noShoot){
        set.bsTimer = setTimeout(function(){ bugShoot(false); }, (Math.random() * (options.bsTime - 2) + 2) * 1000);
        if(noShoot) return true;

        shooter = Math.floor(Math.random() * objects.formation.find('div.bug').length);
        createShell(-1, objects.formation.find('div.bug:eq(' + shooter + ')'));
    }

/*-------------------------------------------------------------------*/
// Создание снаряда

    var createShell = function(dir, obj){
        dir = (dir == -1 ? -1 : 1);
        if(!obj) obj = objects.ship;
        shell = $('<div></div>').addClass('shell' + (dir == -1 ? ' s-bug' : '')).attr('dir', dir).appendTo(e)

        shell.css({
            left: ((obj.offset().left - e.offset().left) + obj.width() / 2 - 7) + 'px',
            top:  ((obj.offset().top - e.offset().top) - (dir * shell.height() / 2)) + 'px'
        });

        // Опеделяем ближайший по горизонтали столбец жуков
        if(dir == 1)
        {
            document.getElementById('s-lazer').play();
            var min = 800; var minI = 0;
            for(i = 0; i < 10; i++)
            {
                _this = objects.formation.find('div:eq(' + i + ')');
                pat = (set.bDir == 1 ? (_this.offset().left + _this.width() - shell.offset().left) : (_this.offset().left - shell.offset().left));
                if(Math.abs(pat) < min)
                {
                    min = Math.abs(_this.offset().left - shell.offset().left);
                    minI = i;
                }
            }

            shell.data('cell', (set.bDir == 1 ? --minI : minI));
        }
    };

/*-------------------------------------------------------------------*/
// Движение снаряда

    var moveShell = function(shell){
        // Передвигаем снаряд
        newTop = (parseInt(shell.css('top')) - (e.innerHeight() * (shell.attr('dir') == 1 ? options.shellSpeed : options.bsSpeed) / options.fps * shell.attr('dir')));
        shell.css('top', newTop + 'px');

        // Удаляем снаряд, если он достиг края экрана
        if(parseInt(shell.css('top')) < 0 || parseInt(shell.css('top')) > (e.innerHeight() - 20))
            shell.remove();

        // Определяем попадание по бонусной тарелке
        if(objects.bonus && shell.attr('dir') == 1)
        {
            if(isImposed(objects.bonus, shell))
            {
                shell.remove();
                addScore(parseInt(objects.bonus.attr('points')));
                objects.bonus.remove();
                objects.bonus = false;
            }
        }

        // Определяем попадание в бункер
        e.find('div.bunker:not(.destructed)').each(function(){
            if(isImposed($(this), shell))
            {
                shootBunker($(this));
                shell.remove();
                return false;
            }
        });

        if(shell.attr('dir') == 1)
        {
            e.find('div.shell.s-bug').each(function(){
                if(isImposed($(this), shell))
                {
                    $(this).remove();
                    shell.remove();
                    return false;
                }
            });
        }

        // Определяем попадание по жуку
        if(shell.attr('dir') == 1 && shell.offset().top < (objects.formation.offset().top + objects.formation.height()))
        {
            for(i = 0; i < 5; i++)
            {
                for(j = shell.data('cell'); j <= (shell.data('cell') + 1); j++)
                {
                    _this = objects.formation.find('div:eq(' + (i * 10 + j) + ')');
                    if(!_this.hasClass('bug')) continue;

                    var to = _this.offset();
                    var so = shell.offset();
                    if(isImposed(_this, shell))
                    {
                        killBug(i * 10 + j);
                        shell.remove();
                    }
                }
            }

        }
        // Определяем попадание по кораблю
        else if(shell.attr('dir') == -1 && (parseInt(shell.css('top') + shell.height())) > (e.height() - 50))
        {
            if(isImposed(objects.ship, shell))
            {
                killShip();
                shell.remove();
            }
        }
    }

/*-------------------------------------------------------------------*/
// Создание бонусной тарелки

    var bonusPlate = function(noPlate)
    {
        set.bpTimer = setTimeout(function(){ bonusPlate(false) }, (Math.random() * 50 + 30) * 1000);
        if(noPlate || objects.bonus != false) return true;

        objects.bonus = $('<div></div>').addClass('bonus').attr('points', Math.floor(Math.random() * 10 + 4) * 10).appendTo(e);
    }

/*-------------------------------------------------------------------*/
// Движение бонусной тарелки

    var moveBonus = function(){
        if(!objects.bonus) return false;

        objects.bonus.css('left', (parseInt(objects.bonus.css('left')) + e.width() * 0.15 / options.fps) + 'px');
        if(parseInt(objects.bonus.css('left')) + objects.bonus.width() > e.width())
        {
            objects.bonus.remove();
            objects.bonus = false;
        }
    }

/*-------------------------------------------------------------------*/
// Попадение по бункеру

    var shootBunker = function(bunker){
        if(bunker.hasClass('destructed')) return true;

        hp = bunker.data('hp') - 10;
        bunker.data('hp', hp).css('background', 'rgb(' + (350 - hp) + ', ' + hp + ', 0)');

        if(hp < 0){
            document.getElementById('s-bang').play();
            bunker.addClass('destructed');
        }
    }

/*-------------------------------------------------------------------*/
// Убийство жука

    var killBug = function(i){
        var dead = objects.formation.find('div:eq(' + i + ')');
        // Начисляем очки
             if(dead.hasClass('bug4')) pScore = 35;
        else if(dead.hasClass('bug3')) pScore = 25;
        else if(dead.hasClass('bug2')) pScore = 15;
        else                           pScore = 10;
        addScore(pScore);

        dead.removeClass('bug').addClass('free');

        // Если это был последний жук - начинаем новый раунд
        if(!objects.formation.find('div.bug').length)
            newLevel();

        // Отсекаем нижний ряд если он пуст (для уменьшения расчетов)
        var current = (objects.formation.find('div').length - 1);
        var delRow = true;
        for(i = 1; i <= 10; i++)
        {
            bug = objects.formation.find('div:eq(' + current + ')');
            if(bug.hasClass('bug'))
            {
                delRow = false;
                break;
            }
            --current;
        }

        if(delRow)
        {
            current = (objects.formation.find('div').length - 1);
            for(i = 1; i <= 10; i++)
            {
                bug = objects.formation.find('div:eq(' + current + ')');
                bug.remove();
                --current;
            }
        }
    }

/*-------------------------------------------------------------------*/
// Убийство корабля

    var killShip = function(){
        document.getElementById('s-bang').play();

        // Завершаем игру если больше нет жизней
        if(options.lifes <= 0) { gameOver(); return true; }

        --options.lifes;
        setLifes(options.lifes);

        objects.ship.css('left', '50px');
    }

/*-------------------------------------------------------------------*/
// Начисление очков

    var addScore = function(pScore){
        objects.score.html(objects.score.html() * 1 + pScore);
    }

/*-------------------------------------------------------------------*/
// Смена количества жизней

    var setLifes = function(num){
        objects.lifes.html(num);
        options.lifes = num;
    }

/*-------------------------------------------------------------------*/
// Смена индикатора раунда

    var setLevel = function(){
        objects.level.html('Level: <b>' + set.level + '</b>');
    }

/*-------------------------------------------------------------------*/
// Определение пересечения двух объектов

    var isImposed = function(obj1, obj2){
        to = obj1.offset();
        so = obj2.offset();
        if((so.left + obj2.width()) > to.left && (to.left + obj1.width() + obj2.width()) > so.left && to.top < so.top && (to.top + obj1.height()) > so.top)
            return true;
        return false;
    }

/*-------------------------------------------------------------------*/

    return this.each(handler);
  }
})(jQuery);