<?php

/**
 * Conference for JohnCMS
 * Add/Edit conference
 * @author Screamer
 * @copyright 2013
 */

/**
 * Add/Edit conference
 * @param (int) $id ID of conference
 * @return (string)
 */
function action_form($sys, $id = 0) {
	if ($id != 0) {
		// Get data of conference for edit
		$data = $sys->jl->model('conference')->get($id);
		if (!is_array($data)) {
			jl_redirect();
		}
	}
	$user_data = $sys->jl->get_data('user_data');
	$settings = $sys->jl->model('settings')->get();
	if ($user_data['rights'] != 9 && !isset($data)) {
		// Check allowed deal of conferences for simple users
		$total = $sys->jl->model('conference')->count($user_data['id']);
		if ($total >= $settings['cpu']) {
			return jl_message($sys->lng->unable_to_create_conf, 1);
		}
	}
	$error = array();
	if (!isset($data)) {
		$data = array('name' => '', 'type' => 0, 'autoclean' => 1);
	}
	if (!empty($_POST)) {
		// Name
		$data['name'] = isset($_POST['name']) ? trim($_POST['name']) : '';
		if (mb_strlen($data['name']) < 2 || strlen($data['name']) > 255) {
			$error['name'] = sprintf($sys->lng->wrong_string_len, 2, 127);
		}
		// Type [0-2]
		$data['type'] = isset($_POST['type']) ? intval($_POST['type']) : -1;
		if ($data['type'] < 0 || $data['type'] > 2) {
			$error['type'] = $sys->lng->wrong_type_of_conference;
		}
		// Autoclean time
		$data['autoclean'] = isset($_POST['autoclean']) ? intval($_POST['autoclean']) : $data['autoclean'];
		if ($data['autoclean'] < 0 || $data['autoclean'] > $settings['autoclean']) {
			$error['autoclean'] = sprintf($sys->lng->wrong_autoclean_value, 1, $settings['autoclean']);
		}
		if (empty($error)) {
			$cid = $sys->jl->model('conference')->save($data['name'], $data['type'], $user_data['id'], $user_data['name'], $id);
			jl_redirect('conference/' . ($data['type'] == 2 && $id == 0 ? 'private' : 'view') . '/' . $cid);
		}
	}
	$sys->tpl->set_title(($id != 0 ? $sys->lng->edit_conference : $sys->lng->create_conference));
	return $sys->tpl->load('form', array(
		'title'         => $sys->tpl->get_title(),
		'error'         => $error,
		'conference'    => $data,
		'max_autoclean' => $settings['autoclean'],
		'lang'          => $sys->lng,
	));
}