<?php

/**
 * JLayer
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

/** Directory Separator */
define('DIR_SEP', DIRECTORY_SEPARATOR);
/** JLayer System Directory */
define('JL_DIR', rtrim(dirname(__FILE__), '/\\') . DIR_SEP);
/** Directory of module */
define('MODULE_DIR', rtrim(realpath(JL_DIR . '../'), '\\/') . DIR_SEP);
/** Directory of engine system files */
define('ENGINE_DIR', rtrim(realpath(MODULE_DIR . '../incfiles'), '/\\') . DIR_SEP);
/** Path to output for uncaught exceptions */
define('JL_LOG_EXP', false);
/** JLayer Logs Directory */
define('JL_LOGS', JL_DIR . 'logs' . DIR_SEP);
/** HTTP Host */
define('HTTP_HOST', 'http://' . trim($_SERVER['SERVER_NAME'], '/\\') . '/');

require JL_DIR . 'functions.php';

// Set uncaught exceptions handler
set_exception_handler('jl_exception_handler');

// Get Configuration
$jl_config = isset($jl_config) && is_array($jl_config) ? $jl_config : array();
if (!array_key_exists('db_table_prefix', $jl_config)) {
	throw new Exception('Invalid dbprefix');
}
if (!array_key_exists('default_action', $jl_config)) {
	throw new Exception('Invalid default action');
}

// Load JLayer Classes
$classes = array('Db', 'JLayer', 'Model', 'MySQL', 'Pagination', 'Template');
foreach ($classes as $class) {
	$class = JL_DIR . 'classes' . DIR_SEP . $class . '.php';
	if(is_file($class)) {
		require $class;
	} else {
		throw new Exception("Unable to load file \"" . $class . "\"");
	}
}
unset($uri, $action, $args, $file, $redirect, $classes, $class);
// Init...
define('_IN_JOHNCMS', true);
require ENGINE_DIR .'core.php';
if (!core::$user_id) {
	header('Location: ' . HTTP_HOST . '?err');
	exit;
}
ob_end_clean();
core::$user_set['kmess'] = $kmess;

$obj = new StdClass;

$obj->jl = new JLayer(
	core::$ip,
	core::$ip_via_proxy,
	core::$user_agent,
	core::$is_mobile,
	core::$system_set,
	core::$user_set,
	core::$user_data,
	core::$user_ban,
	$jl_config['db_table_prefix'],
	MODULE_DIR . 'model' . DIR_SEP
);

// Languages handler
$jl_lang = MODULE_DIR . 'lang' . DIR_SEP . core::$lng_iso . '.json';
if (is_file($jl_lang)) {
	$obj->lng = json_decode(file_get_contents($jl_lang));
} else {
	throw new Exception('Unable to load language. File ' . $jl_lang . ' is not exists');
}
unset($jl_lang);

// Templates handler
$obj->tpl = JL_Template::get_instance();
$obj->tpl->set_path(MODULE_DIR . 'view' . DIR_SEP);
$obj->tpl->set_ext('php');
$obj->tpl->set_output('', 0);

// Route
$uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
$uri = array_map('trim', $uri);
$action = isset($uri[1]) && !empty($uri[1]) ? $uri[1] : $jl_config['default_action'];
$args = sizeof($uri) > 2 ? array_slice($uri, 2) : array();
$file = MODULE_DIR . 'actions' . DIR_SEP . $action . '.php';
$redirect = true;
if (is_file($file)) {
	require $file;
	if (function_exists('action_' . $action)) {
		array_unshift($args, $obj);
		$result = call_user_func_array('action_' . $action, $args);
		$redirect = false;
	}
}
// Redirect to error page
if ($redirect === true) {
	header('Location: ' . HTTP_HOST . '?err');
	exit;
}

if (!empty($result)) {
	ob_start();
	$textl = $obj->tpl->get_title();
	if (empty($textl)) {
		$textl = isset($jl_config['page_title']) ? $jl_config['page_title'] : $obj->jl->get_data('system_settings', 'copyright');
	}
	require ENGINE_DIR . 'head.php';
	$engine_head = ob_get_contents();
	ob_end_clean();
	$obj->tpl->set_output($engine_head, 0);
	$obj->tpl->set_output($result);
	ob_start();
	require ENGINE_DIR . 'end.php';
	$engine_footer = ob_get_contents();
	ob_end_clean();
	$obj->tpl->set_output($engine_footer);
	$obj->tpl->output();
}