<?php

/**
 * JLayer
 * MySQL Wrapper
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

class JL_MySQL extends JL_Db {

	/**
	 * Returns the numerical value of the error message from previous MySQL operation
	 * @return (int)
	 */
	public function errno() {
		return mysql_errno();
	}

	/**
	 * Returns the text of the error message from previous MySQL operation
	 * @return (string)
	 */
	public function error() {
		return mysql_error();
	}

	/**
	 * Escapes special characters in a string for use in an SQL statement
	 * @param (string) $string The string that is to be escaped.
	 * @return (string)
	 */
	public function escape_string($string) {
		if (!is_string($string)) {
			throw new Exception("Invalid type of argument. String expect.");
		}
		return mysql_real_escape_string($string);
	}

	/**
	 * Fetch a result row as an associative array
	 * @param (resource) $result The result resource that is being evaluated. This result comes from a call to mysql_query().
	 * @return (array)
	 */
	public function fetch_assoc($result) {
		if (!is_resource($result)) {
			throw new Exception("Invalid type of argument. Resource expect.");
		}
		return mysql_fetch_assoc($result);
	}

	/**
	 * Get the ID generated in the last query
	 * @return (int)
	 */
	public function insert_id() {
		return mysql_insert_id();
	}

	/**
	 * Send a MySQL query
	 * @param (string) $statement An SQL query. The query string should not end with a semicolon. Data inside the query should be properly escaped.
	 * @return (resource)
	 */
	public function query($statement) {
		if (!is_string($statement)) {
			throw new Exception("Invalid type of argument. String expect.");
		}
		$result = mysql_query($statement);
		$error = $this->error();
		if ($error) {
			$this->jl_errors[] = array(
				$this->errno(),
				$this->error(),
				$statement
			);
		}
		return $result;
	}

	/**
	 * Get result data
	 * @param (string) $statement An SQL query.
	 * @return (int)
	 */
	public function result($statement) {
		if (!is_string($statement)) {
			throw new Exception("Invalid type of argument. String expect.");
		}
		return intval(mysql_result($this->query($statement), 0));
	}

}