<?php
namespace jl {
	/**
	 * JLayer
	 *
	 * DB wrappers parent
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */

	abstract class Db {

		/**
		 * @var array Occured SQL errors
		 */
		protected $jl_errors = array();

		/**
		 * Save SQL errors to log
		 *
		 * @return void
		 */
		public function __destruct() {
			if (!empty($this->jl_errors)) {
				$log = JL_LOGS . date('d-m-Y') . '.log';
				if (is_file($log)) {
					$data = file_get_contents($log);
				} else {
					$data = '';
				}
				$errors = '';
				foreach ($this->jl_errors as $item) {
					$errors .= PHP_EOL .'Time: ' . date('H:i:s', time()) . PHP_EOL
						. 'Error Code: ' . $item[0] . PHP_EOL
						. 'Error Messsage: ' . $item[1] . PHP_EOL
						. 'Statement: ' . $item[2] . PHP_EOL
						. str_repeat('-', 11);
				}
				file_put_contents($log, ($errors . $data));
			}
		}

		/**
		 * Get number of affected rows in previous MySQL operation
		 *
		 * @return int
		 */
		public abstract function affected_rows();

		/**
		 * Returns the name of the character set
		 *
		 * @return string
		 */
		public abstract function client_encoding();

		/**
		 * Close MySQL connection
		 *
		 * @return boolean
		 */
		public abstract function close();

		/**
		 * Open a connection to a MySQL Server
		 *
		 * @param string $host         The MySQL server.
		 * @param string $user         The username.
		 * @param string $password     The password.
		 *
		 * @return mixed
		 */
		public abstract function connect($host, $user, $password);

		/**
		 * Returns the numerical value of the error message from previous MySQL operation
		 *
		 * @return int
		 */
		public abstract function errno();

		/**
		 * Returns the text of the error message from previous MySQL operation
		 *
		 * @return string
		 */
		public abstract function error();

		/**
		 * Escapes special characters in a string for use in an SQL statement
		 *
		 * @param string $string The string that is to be escaped.
		 *
		 * @return string
		 */
		public abstract function escape_string($string);

		/**
		 * Fetch a result row as an associative array
		 *
		 * @param mixed $result The result resource that is being evaluated. This result comes from a call to mysql_query().
		 *
		 * @return array
		 */
		public abstract function fetch_assoc($result);

		/**
		 * Fetch a result row as an object
		 *
		 * @param mixed    $result The result resource that is being evaluated.
		 *
		 * @return mixed
		 */
		public abstract function fetch_object($result);

		/**
		 * Get a result row as an enumerated array
		 *
		 * @param mixed $result The result resource that is being evaluated.
		 *
		 * @return array
		 */
		public abstract function fetch_row($result);

		/**
		 * Free result memory
		 *
		 * @param mixed $result The result resource that is being evaluated.
		 *
		 * @return boolean
		 */
		public abstract function free($result);

		/**
		 * Get the ID generated in the last query
		 *
		 * @return int
		 */
		public abstract function insert_id();

		/**
		 * Get number of fields in result
		 *
		 * @param mixed $result The result resource that is being evaluated.
		 *
		 * @return mixed
		 */
		public abstract function num_fields($result);

		/**
		 * Get number of rows in result
		 *
		 * @param mixed $result The result resource that is being evaluated.
		 *
		 * @return int
		 */
		public abstract function num_rows($result);

		/**
		 * Send a MySQL query
		 *
		 * @param string $statement An SQL query. The query string should not end with a semicolon. Data inside the query should be properly escaped.
		 *
		 * @return mixed
		 */
		public abstract function query($statement);

		/**
		 * Get result data
		 *
		 * @param string $statement An SQL query.
		 *
		 * @return int
		 */
		public abstract function result($statement);

		/**
		 * Select a MySQL database
		 *
		 * @param string $name The name of the database that is to be selected.
		 *
		 * @return boolean
		 */
		public abstract function select_db($name);

		/**
		 * Sets the client character set
		 *
		 * @param string $charset A valid character set name.
		 *
		 * @return boolean
		 */
		public abstract function set_charset($charset);


	}
}