<?php
namespace jl\wrappers\johncms {

	use jl\exception\InvalidArgumentException;
	/**
	 * JLayer
	 *
	 * Functions wrapper
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	class Functions extends \jl\Functions {

		/**
		 * Anti flood
		 * Check time interval between messages
		 * Returns time in seconds. If return false, posting is allowed.
		 *
		 * @return boolean|int
		 */
		public function anti_flood() {
			return \functions::antiflood();
		}

		/**
		 * Panel with bb-codes
		 *
		 * @param string $form  Name of form
		 * @param string $field Name of field
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function bb_panel($form, $field) {
			if (!is_string($form)) {
				throw new InvalidArgumentException('form', 'string');
			}
			if (!is_string($field)) {
				throw new InvalidArgumentException('field', 'string');
			}

			return \bbcode::auto_bb($form, $field);
		}

		/**
		 * Check captcha
		 *
		 * @param string $code Code for check
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return boolean
		 */
		public function check_captcha($code) {
			if (!is_string($code)) {
				throw new InvalidArgumentException('code', 'string');
			}

			if (!isset($_SESSION['code'])) {
				return false;
			} else {
				return ($_SESSION['code'] == $code);
			}
		}

		/**
		 * Filter string
		 *
		 * @param string $string String for handle
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function check_in($string) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}

			return \functions::checkin($string);
		}

		/**
		 * Handle string before output
		 *
		 * @param string $string  String for handle
		 * @param int    $nl      Handling new lines: 0 - no handle; 1 - translate to <br />; 2 - translate to spaces;
		 * @param int    $bb_tags Handling bb-codes: 0 - no handle; 1 - handle; 2 - cut;
		 * @param int    $smileys Handling smileys: 0 - no handle; 1 - handle;
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function check_out($string, $nl = 0, $bb_tags = 0, $smileys = 0) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}
			if (!is_int($nl)) {
				throw new InvalidArgumentException('nl', 'int');
			}
			if (!is_int($bb_tags)) {
				throw new InvalidArgumentException('bb_tags', 'int');
			}
			if (!is_int($smileys)) {
				throw new InvalidArgumentException('smileys', 'int');
			}

			$string = \functions::checkout($string, $nl, $bb_tags);
			if ($smileys == 1) {
				$string = $this->do_smileys($string);
			}

			if ($bb_tags == 1) {
				$string = preg_replace('#\[color=(.+?)\]#si', '$2', $string);
				$string = preg_replace('!\[bg=(#[0-9a-f]{3}|#[0-9a-f]{6}|[a-z\-]+)]!is', '$2', $string);
				$replace = array(
					'[small]' => '',
					'[/small]' => '',
					'[big]' => '',
					'[/big]' => '',
					'[green]' => '',
					'[/green]' => '',
					'[red]' => '',
					'[/red]' => '',
					'[blue]' => '',
					'[/blue]' => '',
					'[b]' => '',
					'[/b]' => '',
					'[i]' => '',
					'[/i]' => '',
					'[u]' => '',
					'[/u]' => '',
					'[s]' => '',
					'[/s]' => '',
					'[quote]' => '',
					'[/quote]' => '',
					'[c]' => '',
					'[/c]' => '',
					'[*]' => '',
					'[/*]' => '',
					'[/bg]' => '',
					'[/color]' => '',
				);
				$string = strtr($string, $replace);
			}

			return $string;
		}

		/**
		 * Prepare confirm message to display
		 * Returns html form with two buttons: OK and Cancel;
		 *
		 * @param string $title   Title of form
		 * @param string $message Message
		 * @param string $ok      OK button value
		 * @param string $cancel  Cancel button value
		 * @param string $action  Form action: url to handler script
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function confirm_message($title, $message, $ok, $cancel, $action = '') {
			if (!is_string($title)) {
				throw new InvalidArgumentException('title', 'string');
			}
			if (!is_string($message)) {
				throw new InvalidArgumentException('message', 'string');
			}
			if (!is_string($ok)) {
				throw new InvalidArgumentException('ok', 'string');
			}
			if (!is_string($cancel)) {
				throw new InvalidArgumentException('cancel', 'string');
			}
			if (!is_string($action)) {
				throw new InvalidArgumentException('action', 'string');
			}

			return $this->tpl->load('confirm_message', array(
				'title'   => $title,
				'message' => $message,
				'ok'      => $ok,
				'cancel'  => $cancel,
				'action'  => $action
			));
		}

		/**
		 * Handle time. Returns timestamp in days or hours.
		 *
		 * @param int $timestamp Timestamp
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function count_time($timestamp) {
			if (!is_int($timestamp)) {
				throw new InvalidArgumentException('timestamp', 'integer');
			}

			return \functions::timecount($timestamp);
		}

		/**
		 * Translate timestamp to date (d.m.Y / H:i:s)
		 * Date with time-shifts, which defined in system and user settings!
		 *
		 * @param  int $timestamp Timestamp
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function display_date($timestamp) {
			if (!is_int($timestamp)) {
				throw new InvalidArgumentException('timestamp', 'integer');
			}

			return \functions::display_date($timestamp);
		}

		/**
		 * Display some message
		 *
		 * @param array|string $message Message
		 * @param int          $level   Level: 0 - notice; 1 - error or warning
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string|void
		 */
		public function display_message($message, $level = 0) {
			if (!is_string($message) && !is_array($message)) {
				throw new InvalidArgumentException('message', 'string, array');
			}
			if (!is_int($level)) {
				throw new InvalidArgumentException('level', 'integer');
			}

			return $this->tpl->load('display_message', array(
					'message' => is_array($message) ? implode('<br />', $message) : $message,
					'level' => $level === 0 ? 'gmenu' : 'rmenu',
			   )
			);
		}

		/**
		 * Prepare user data for display
		 *
		 * @param int|array $user       Data of user
		 * @param boolean   $last_visit Enable last visit
		 * @param boolean   $status     Disable status
		 * @param boolean   $ips        Disable ip addresses and user-agent
		 * @param boolean   $ip_history Enable link to IP Addresses history
		 * @param string    $header     Display near nickname
		 * @param string    $body       Display under nickname
		 * @param string    $sub        Display at sub place
		 * @param string    $footer     Display at footer
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function display_user(
			$user,
			$last_visit = false,
			$status = true,
			$ips = true,
			$ip_history = true,
			$header = '',
			$body = '',
			$sub = '',
			$footer = ''
		) {
			if (!is_int($user) && !is_array($user)) {
				throw new InvalidArgumentException('user', 'int, array');
			}
			if (!is_bool($last_visit)) {
				throw new InvalidArgumentException('last_visit', 'boolean');
			}
			if (!is_bool($status)) {
				throw new InvalidArgumentException('status', 'boolean');
			}
			if (!is_bool($ips)) {
				throw new InvalidArgumentException('ips', 'boolean');
			}
			if (!is_bool($ip_history)) {
				throw new InvalidArgumentException('ip_history', 'boolean');
			}
			if (!is_string($header)) {
				throw new InvalidArgumentException('header', 'string');
			}
			if (!is_string($body)) {
				throw new InvalidArgumentException('body', 'string');
			}
			if (!is_string($sub)) {
				throw new InvalidArgumentException('sub', 'string');
			}
			if (!is_string($footer)) {
				throw new InvalidArgumentException('footer', 'string');
			}
			$args = array(
				'last_visit' => $last_visit,
				'stshide'    => $status,
				'iphide'     => $ips,
				'iphist'     => $ip_history,
			);
			if (!empty($header)) {
				$args['header'] = $header;
			}
			if (!empty($body)) {
				$args['body'] = $body;
			}
			if (!empty($sub)) {
				$args['sub'] = $sub;
			}
			if (!empty($footer)) {
				$args['footer'] = $footer;
			}
			return \functions::display_user($user, $args);
		}

		/**
		 * Translate cyrillic chars to latin equivalents.
		 *
		 * @param string $string String for handle
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function do_translit($string) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}

			return \functions::rus_lat($string);
		}

		/**
		 * Parse smiles in string
		 *
		 * @param string  $string String for handle
		 * @param boolean $adm    Use admins smileys?
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function do_smileys($string, $adm = false) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}

			$adm = (bool) $adm;
			return \functions::smileys($string, $adm);
		}

		/**
		 * Untranslit string
		 *
		 * @param string $string String for handle
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function do_untranslit($string) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}

			return \functions::trans($string);
		}

		/**
		 * Force Download (From CodeIgniter Download Helpers)
		 * @author        ExpressionEngine Dev Team
		 * @link          http://codeigniter.com/user_guide/helpers/download_helper.html
		 *
		 * Generates headers that force a download to happen
		 *
		 * @param   string $filename Filename
		 * @param   mixed  $data     the data to be downloaded
		 * @param   string $mime     Mime-Type of file
		 *
		 * @return  mixed
		 */
		function force_download($filename = '', $data = '', $mime = 'application/octet-stream')
		{
			if ($filename == '' || $data == '')
			{
				return false;
			}

			// Try to determine if the filename includes a file extension.
			// We need it in order to set the MIME type
			if (false === strpos($filename, '.'))
			{
				return false;
			}

			// Generate the server headers
			if (strpos($_SERVER['HTTP_USER_AGENT'], "MSIE") !== FALSE)
			{
				header('Content-Type: "'.$mime.'"');
				header('Content-Disposition: attachment; filename="'.$filename.'"');
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header("Content-Transfer-Encoding: binary");
				header('Pragma: public');
				header("Content-Length: ".strlen($data));
			}
			else
			{
				header('Content-Type: "'.$mime.'"');
				header('Content-Disposition: attachment; filename="'.$filename.'"');
				header("Content-Transfer-Encoding: binary");
				header('Expires: 0');
				header('Pragma: no-cache');
				header("Content-Length: ".strlen($data));
			}

			exit($data);
		}

		/**
		 * Get captcha image and return html code for display.
		 * Also sets code on image to _SESSION['code']
		 *
		 * @param string $field_name Name of input field
		 * @param string $error      Error message if exists
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function get_captcha($field_name, $error = '') {
			if (!is_string($field_name)) {
				throw new InvalidArgumentException('field_name', 'string');
			}
			if (!is_string($error)) {
				throw new InvalidArgumentException('error', 'string');
			}
			return $this->tpl->load('get_captcha', array(
													'img'        => HTTP_HOST . 'captcha.php?' . rand(1000, 9999),
													'field_name' => trim($field_name),
													'error'      => trim($error),
											   )
			);
		}

		/**
		 * Get data of some user
		 *
		 * @param mixed  $id ID or name of user
		 * @param string $by Search by ID or name
		 *
		 * @return array
		 */
		public function get_user($id, $by = 'id') {
			$by = $by == 'id' ? 'id' : 'name';
			$id = $by == 'id' ? intval($id) : $this->db->escape_string($id);
			$result = $this->db->query("SELECT * FROM `users` WHERE `" . $by .  "` = '" . $id . "'");
			$data = $this->db->fetch_assoc($result);
			return is_array($data) ? $data : array();
		}

		/**
		 * IP address validation
		 *
		 * @param string $ip IP address
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return boolean
		 */
		public function valid_ip($ip) {
			if (!is_string($ip)) {
				throw new InvalidArgumentException('ip', 'string');
			}

			return \core::ip_valid($ip);
		}

		/**
		 * Set time of last post
		 *
		 * @param $user_id
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return bool|void
		 */
		public function set_last_post_time($user_id) {
			if (!is_int($user_id)) {
				throw new InvalidArgumentException('user_id', 'int');
			}

			$this->db->query("UPDATE `users` SET `lastpost` = '" . time() . "' WHERE `id` = '" . $user_id . "'");
			return $this->db->affected_rows() > 0;
		}

	}
}