<?php
namespace jl\exception {

	/**
	 * JLayer
	 *
	 * Class InvalidArgumentException
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	class InvalidArgumentException extends \LogicException {

		/**
		 * Constructor
		 *
		 * @param string     $argument Name of argument
		 * @param int        $types    Allowed types of argument
		 * @param int        $code     Error Code
		 * @param \Exception $previous Previous exception
		 *
		 * @return \jl\exception\InvalidArgumentException
		 */
		public function __construct($argument, $types, $code = 0, \Exception $previous = null) {
			$message = 'Invalid type of argument "' . $argument . '". "' . $types . '" expect.';
			parent::__construct($message, $code, $previous);
		}
	}
}