/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.jar.JarFile;
import javax.swing.Timer;

public class AppFrame
extends Frame {
    private static final long serialVersionUID = 1L;
    public static JarFile jar;
    public static String basePath;
    public static InetAddress localAddr;
    private String[] textLines = new String[6];
    private Image imLogo;
    private Image imHelp;
    private Font fontTitle;
    private Font fontText;
    private Timer timer;
    private int height = 510;
    private int width = 540;
    private OSCWorld world;
    private String appName = "RemoteDroid Server R2";
    private Toolkit toolkit;
    private MediaTracker tracker;

    static {
        basePath = "";
    }

    public AppFrame() {
        GlobalData.oFrame = this;
        this.setSize(this.width, this.height);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.tracker = new MediaTracker(this);
        String sHost = "";
        try {
            localAddr = InetAddress.getLocalHost();
            if (localAddr.isLoopbackAddress()) {
                localAddr = LinuxInetAddress.getLocalHost();
            }
            sHost = localAddr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            sHost = "Error finding local IP.";
        }
        this.textLines[0] = "The RemoteDroid server application is now running.";
        this.textLines[1] = "";
        this.textLines[2] = "Your IP address is: " + sHost;
        this.textLines[3] = "";
        this.textLines[4] = "Enter this IP address on the start screen of the";
        this.textLines[5] = "RemoteDroid application on your phone to begin.";
        try {
            URL fileURL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String sBase = fileURL.toString();
            if ("jar".equals(sBase.substring(sBase.length() - 3, sBase.length()))) {
                jar = new JarFile(new File(fileURL.toURI()));
            } else {
                basePath = String.valueOf(System.getProperty("user.dir")) + "\\res\\";
            }
        }
        catch (Exception ex) {
            this.textLines[1] = "exception: " + ex.toString();
        }
    }

    public Image getImage(String sImage) {
        Image imReturn = null;
        try {
            if (jar == null) {
                imReturn = this.toolkit.createImage(this.getClass().getClassLoader().getResource(sImage));
            } else {
                int b;
                BufferedInputStream bis = new BufferedInputStream(jar.getInputStream(jar.getEntry(sImage)));
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
                while ((b = bis.read()) != -1) {
                    buffer.write(b);
                }
                byte[] imageBuffer = buffer.toByteArray();
                imReturn = this.toolkit.createImage(imageBuffer);
                bis.close();
                buffer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imReturn;
    }

    public void init() {
        try {
            this.imLogo = this.getImage("icon.gif");
            this.tracker.addImage(this.imLogo, 0);
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.imHelp = this.getImage("helpphoto.jpg");
            this.tracker.addImage(this.imHelp, 1);
            this.tracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fontTitle = new Font("Verdana", 1, 16);
        this.fontText = new Font("Verdana", 0, 11);
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        this.timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.world = new OSCWorld();
                AppFrame.this.world.onEnter();
                AppFrame.this.repaint();
                AppFrame.this.timer.stop();
            }
        });
        this.timer.start();
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.getForeground());
        g.drawImage(this.imLogo, 10, 30, this);
        g.setFont(this.fontTitle);
        g.drawString(this.appName, 70, 55);
        g.setFont(this.fontText);
        int startY = 90;
        int l = 6;
        int i = 0;
        while (i < l) {
            g.drawString(this.textLines[i], 10, startY);
            startY += 13;
            ++i;
        }
        g.drawImage(this.imHelp, 20, startY + 10, this);
    }
}

