/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class OSCBundle
extends OSCPacket {
    public static final BigInteger SECONDS_FROM_1900_to_1970 = new BigInteger("2208988800");
    public static final Date TIMESTAMP_IMMEDIATE = new Date(0L);
    protected Date timestamp;
    protected Vector packets;

    public OSCBundle() {
        this(null, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Date timestamp) {
        this(null, timestamp);
    }

    public OSCBundle(OSCPacket[] packets) {
        this(packets, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(OSCPacket[] packets, Date timestamp) {
        if (packets != null) {
            this.packets = new Vector(packets.length);
            int i = 0;
            while (i < packets.length) {
                this.packets.add(packets[i]);
                ++i;
            }
        } else {
            this.packets = new Vector();
        }
        this.timestamp = timestamp;
        this.init();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void addPacket(OSCPacket packet) {
        this.packets.add(packet);
    }

    public OSCPacket[] getPackets() {
        OSCPacket[] packetArray = new OSCPacket[this.packets.size()];
        this.packets.toArray(packetArray);
        return packetArray;
    }

    protected void computeTimeTagByteArray(OSCJavaToByteArrayConverter stream) {
        if (this.timestamp == null || this.timestamp == TIMESTAMP_IMMEDIATE) {
            stream.write(0);
            stream.write(1);
            return;
        }
        long millisecs = this.timestamp.getTime();
        long secsSince1970 = millisecs / 1000L;
        long secs = secsSince1970 + SECONDS_FROM_1900_to_1970.longValue();
        long fraction = millisecs % 1000L * 0x100000000L / 1000L;
        stream.write((int)secs);
        stream.write((int)fraction);
    }

    protected void computeByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write("#bundle");
        this.computeTimeTagByteArray(stream);
        Enumeration en = this.packets.elements();
        while (en.hasMoreElements()) {
            OSCPacket nextElement = (OSCPacket)en.nextElement();
            byte[] packetBytes = nextElement.getByteArray();
            stream.write(packetBytes.length);
            stream.write(packetBytes);
        }
        this.byteArray = stream.toByteArray();
    }
}

