<?php
/**
 * Class Native 2.0.1 BETA (C) NURD
 * Используйте как хотите.
 * Написан за 30 минут.
 * Не проверялся в работе :)
 *
 *         2014
 */

/**
 * Разделитель директорий
 */
if ( !defined('DS') ) {
    define( 'DS', DIRECTORY_SEPARATOR );
}

/**
 * Папка шаблонов
 */
define( 'NATIVE_TEMPLATES_DIRECTORY', dirname(__FILE__) . DS . 'tpl' );

/**
 * Основной слой по умолчанию
 */
define( 'NATIVE_DEFAULT_OVERLAY', 'overlay' );

/**
 * Расширения файлов-шаблонов
 */
define( 'NATIVE_FILE_EXTENSION', '.php' );

/**
 * Разрешить кеширование вывода шаблона
 * Да - указываем время в секундах
 * Нет - указываем значение false
 */
define( 'NATIVE_TEMPLATE_OUT_CACHING', false );

/**
 * Папка файлов кеша шаблонов если
 * NATIVE_TEMPLATE_OUT_CACHING !== false
 */
define( 'NATIVE_TEMPLATE_CACHE_DIRECTORY', dirname(__FILE__) . DS . 'cache' );

/**
 * Дефайнить переменные шаблона как
 * переменные а не свойства объекта $this
 */
define( 'NATIVE_DEFINE_SHORT_VARS', true );


/**
 * Class Native
 *
 * Write for fun by (C) NURD
 */
class Native {
    /**
     * Основной слой
     *
     * @var string
     */
    private $_overlay = NATIVE_DEFAULT_OVERLAY;

    /**
     * Переменные шаблонизатора
     *
     * @var array
     */
    private $_vars = array();

    /**
     * Папка шаблонов
     *
     * @var string
     */
    private $_tplDir = NATIVE_TEMPLATES_DIRECTORY;

    /**
     * Папка файлов кеша
     *
     * @var string
     */
    private $_cacheDir = NATIVE_TEMPLATE_CACHE_DIRECTORY;

    /**
     * Конструктор документа
     *
     * @param $overlay
     */
    public function __construct($overlay = null)
    {
        if ( !is_null($overlay) ) {
            $this->_overlay = $overlay;
        }

        $this->bufferStart();
    }

    /**
     * Вывод OVERLAY ( основного слоя )
     */
    public function __destruct()
    {
        $this->_vars['content'] = $this->bufferGet();
        $this->render($this->_overlay, false);
    }

    /**
     * Выводит содержимое шаблона
     *
     * @param $template
     * @param bool $outCache
     * @throws Exception
     */
    public function render($template, $outCache = NATIVE_TEMPLATE_OUT_CACHING)
    {
        $templatePath = $this->_tplDir . DS . $template . NATIVE_FILE_EXTENSION;

        if ( !file_exists($templatePath) ) {
            throw new Exception('Unable to load template ' . $template . ' in ' . $templatePath);
        }

        if ( $outCache !== false && $outCache > 0 ) {
            if ( ($cache = $this->_getFromCache($template)) ) {
                echo $cache;
                return;
            }

            if ( $this->_putToCache($template, $outCache) ) {
                echo $this->_getFromCache($template);
                return;
            }

            throw new Exception('Unable to write cache file for ' . $template);
        }

        if ( NATIVE_DEFINE_SHORT_VARS ) {
            foreach ($this->_vars as $key => $value) {
                $$key = $value;
            }
        }

        include $templatePath;
    }

    /**
     * Возвращает содержимое шаблона
     *
     * @param $template
     * @param int $outCache
     * @return mixed
     */
    public function export($template, $outCache = NATIVE_TEMPLATE_OUT_CACHING)
    {
        $this->bufferStart();
        $this->render($template, $outCache);
        $this->_vars['buffer'][$template] = $this->bufferGet();

        return $this->_vars['buffer'][$template];
    }

    /**
     * Начинает буферизацию вывода
     */
    public function bufferStart()
    {
        ob_start();
    }

    /**
     * Чистит буфер и возвращает его содержимое
     *
     * @return string
     */
    public function bufferGet()
    {
        return ob_get_clean();
    }

    /**
     * Получает содержимое кеша указанного шаблона
     *
     * @param $template
     * @return bool
     */
    private function _getFromCache($template)
    {
        $cachePath = $this->_cacheDir . DS . $template . NATIVE_FILE_EXTENSION . '.cache.php';

        if ( !file_exists($cachePath) ) {
            return false;
        }

        $_ = array();
        include $cachePath;

        if ( $_['expires'] > time() ) {
            return $_['out'];
        }

        return false;
    }

    /**
     * Эта штука кеширует шаблон
     *
     * @param $template
     * @param $time
     * @return int
     */
    private function _putToCache($template, $time)
    {
        $cachePath = $this->_cacheDir . DS . $template . NATIVE_FILE_EXTENSION . '.cache.php';
        $data = array(
            'expires'   => time() + $time,
            'out'       => $this->export($template, false)
        );

        $content = '<?php' . PHP_EOL;
        $content .= '// Generated by Native templator' . PHP_EOL;
        $content .= '// @TIME ' . date('d-m-Y H:i:s') . PHP_EOL . PHP_EOL;
        $content .= '$_ = ' . var_export($data, true) . ';';

        return file_put_contents($cachePath, $content);
    }

    /**
     * Здесь происходит магия :)
     */

    /**
     * @param $name
     * @return null
     */
    function __get($name)
    {
        if ( isset($this->_vars[$name]) ) {
            return $this->_vars[$name];
        }

        return null;
    }

    /**
     * @param $name
     * @param $value
     */
    function __set($name, $value)
    {
        $this->_vars[$name] = $value;
    }

    /**
     * @param $name
     * @return bool
     */
    function __isset($name)
    {
        return isset($this->_vars[$name]);
    }

    /**
     * @param $name
     */
    function __unset($name)
    {
        unset($this->_vars[$name]);
    }

    /**
     * @param string $cacheDir
     */
    public function setCacheDir($cacheDir)
    {
        $this->_cacheDir = $cacheDir;
    }

    /**
     * @return string
     */
    public function getCacheDir()
    {
        return $this->_cacheDir;
    }

    /**
     * @param string $overlay
     */
    public function setOverlay($overlay)
    {
        $this->_overlay = $overlay;
    }

    /**
     * @return string
     */
    public function getOverlay()
    {
        return $this->_overlay;
    }

    /**
     * @param string $tplDir
     */
    public function setTplDir($tplDir)
    {
        $this->_tplDir = $tplDir;
    }

    /**
     * @return string
     */
    public function getTplDir()
    {
        return $this->_tplDir;
    }
}