<?php

/*
** Автор кода: Евгений (rnddev)
** ICQ: 448235
** Email: rnddev@mail.ru
** Skype: rnddev
** Все права принадлежат автору
** Модефикация и продажа запрещена
*/

defined('ACCESS') or die('Error::Access');

class main {

	/**
	 * Изменение размера изображений
	 *
	 * Пропорциональное изменение размера производится в случае,
	 * если отсутствует один из параметров высоты или ширины изображения
	 *
	 * @param string $path_to_file путь к существующему изображению
	 * @param string $path_to_save путь для сохранения
	 * @param int $width ширина изображения
	 * @param int $height высота изображения
	 * @param int $quality качество изображения в процентах
	 * @return boolean
	 */
    public static function image_resize($path_to_file, $path_to_save, $width, $height = 0, $quality = 100) {
		// Проверка наличия изображения на сервере
		if ( ! file_exists($path_to_file)) return FALSE;

		// Получение информации о изображении
		$info = getimagesize($path_to_file);

		// Формат изображения
    	$format = strtolower(substr($info['mime'], strpos($info['mime'], '/') + 1));

		// Выбор функции для изображения
    	$picfunc = 'imagecreatefrom'. $format;

		// Старая ширина изображения
        $old_width = $info[0];

        // Старая высота изображения
		$old_height = $info[1];

        // Вычисление горизонтального соотношения
        $horizontal = $width / $old_width;

        // Вычисление вертикального соотношения
        $vertical = $height / $old_height;

        // Пропорциональное вычисление параметров
        if ($height == 0) {
        	$vertical = $horizontal;
			$height = $vertical * $old_height;
		}
		elseif ($width == 0) {
            $horizontal = $vertical;
			$width = $horizontal * $old_width;
		}

		// Формирование размера изображения
		$ratio = min($horizontal, $vertical);

		// Необходимость пропорционального изменения
		if ($horizontal == $ratio) $use_horizontal = TRUE;
		else $use_horizontal = FALSE;

		$new_width = $use_horizontal ? $width : floor($old_width * $ratio);
		$new_height = ! $use_horizontal ? $height : floor($old_height * $ratio);
		$new_left = $use_horizontal ? 0 : floor(($width - $new_width) / 2);
		$new_top = ! $use_horizontal ? 0 : floor(($height - $new_height) / 2);

		$pic_to_src = $picfunc($path_to_file);

		// Создание изображения в памяти
    	$pic_to_save = imagecreatetruecolor($width, $height);

        // Заполнение цветом
        $white = imagecolorallocate($pic_to_save, 0xFF, 0xFF, 0xFF);
        imagefill($pic_to_save, 0, 0, $white);

    	// Нанесение старого изображения на новое
		imagecopyresampled($pic_to_save, $pic_to_src, $new_left, $new_top, 0, 0, $new_width, $new_height, $old_width, $old_height);

		// Определение формата изображения на выходе
		$ext = array_pop(explode('.', $path_to_save));

		switch($ext) {
			case 'jpg':
			case 'jpeg':
				imagejpeg($pic_to_save, $path_to_save, $quality);
			break;

			case 'gif':
				imagegif($pic_to_save, $path_to_save);
			break;

			case 'png':
				imagepng($pic_to_save, $path_to_save);
	        break;

			default:
				return FALSE;
	      	break;
		}

		// Очистка памяти
    	imagedestroy($pic_to_src);
    	imagedestroy($pic_to_save);

    	return TRUE;
	}
	
}