<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require_once('../incfiles/core.php');
require_once('inc.php');

$headmod = 'NYLoto';
$textl = 'Новогодняя лотерея';

/*
-----------------------------------------------------------------
Закрываем от неавторизованных юзеров
-----------------------------------------------------------------
*/
if (!$user_id) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['access_guest_forbidden']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Получаем данные пользователя
-----------------------------------------------------------------
*/

$user = functions::get_user($user);
if (!$user) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['user_does_not_exist']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Переключаем режимы работы
-----------------------------------------------------------------
*/
$array_includes = array(
    'set',
    'win',
    'member',
    'sponsor'
);

$i = 0;

$array_defaults = array('blacklist' => array(0), 'count_winers' => 6, 'result_date' => 1420243200, 'exit_date' => 1420070400, 'forum_posts' => 100, 'period' => 7776000, 'total_on_site' => 864000, 'karma' => 0, 'datereg' => 864000);

if (file_exists('set.json')) {
    $loto_array_set = json_decode(file_get_contents('set.json'), 1);
}
$loto_settings = isset($loto_array_set) ? $loto_array_set : $array_defaults;

$result = mysql_query("select *, (select count(*) from `forum` where `forum`.`user_id` = `users`.`id` and `type` = 'm' and `time` >= " . (time() - $loto_settings['period']) . ") as `fcnt`, (select count(*) from `cms_ban_users` where `users`.`id` = `cms_ban_users`.`user_id` and `ban_time` >= " . (time() - $loto_settings['period']) . ") as `bcnt` from `users` where `id` not in(" . implode(' ,', $loto_settings['blacklist']) . ") and `total_on_site` >= " . $loto_settings['total_on_site'] . " and `datereg` <= " . (time() - $loto_settings['datereg']) . " and `karma_plus`-`karma_minus` >= " . $loto_settings['karma'] . " and `lastdate` >= " . (time() - 172800) . " having `fcnt` >= " . $loto_settings['forum_posts'] . " and `bcnt` = 0 order by `id` asc, `fcnt` desc, `total_on_site` desc, `datereg` asc, `karma_plus` desc, `karma_minus` asc");
$total = mysql_num_rows($result);  

$page = $page >= ceil($total / $kmess) ? ceil($total / $kmess) : $page;
$start = $page == 1 ? 0 : ($page - 1) * $kmess;

require_once('../incfiles/head.php');
if (in_array($act, $array_includes)) {
    require_once('includes/' . $act . '.php');
} else {
    $r_on_site = $user['total_on_site'] >= $loto_settings['total_on_site'] ? 0 : 1;
    $r_karma = ($user['karma_plus'] - $user['karma_minus']) >= $loto_settings['karma'] ? 0 : 1;
    $r_datereg = $user['datereg'] <= (time() - $loto_settings['datereg']) ? 0 : 1;
    $r_ban = mysql_result(mysql_query("select count(*) from `cms_ban_users` where `ban_time` >= '" . (time() - $loto_settings['period']) . "' and `user_id` = " . $user['id']), 0) == 0 ? 0 : 1;
    $r_post_forum = mysql_result(mysql_query("select count(*) from `forum` where `type` = 'm' and `user_id` = " . $user['id'] . " and `time` >= " . (time() - $loto_settings['period'])), 0) >= $loto_settings['forum_posts'] ? 0 : 1;
    $r_blacklist = !in_array($user['id'], $loto_settings['blacklist']) ? 0 : 1;

// место для вашей рекламы
    $spobj = array();
    $dir = new DirectoryIterator('files/data');

    foreach ($dir as $fileinfo) {
        if (!$fileinfo->isDot()) {
            $spobj[] = json_decode(file_get_contents($fileinfo->getPathname()), 1);
        }
    }
// сортировка в порядке убывания суммы взноса
    usort($spobj, 'cmp');
    
    $prizefond = 0;
    
    foreach ($spobj as $rek) {
        $image = file_exists('files/images/' . $rek['spid'] . '.png') ? '<img src="files/images/' . $rek['spid'] . '.png" alt="" />' : '';
        $text = functions::checkout($rek['sptext'], 1, 1);
        $prizefond += $rek['spnal'];
        echo '<div>' . $image .  $text . '</div>';
    }
//

    echo '<div class="phdr"><b>Новогодняя лотерея</b></div>';

    if ($rights >= 7) {
        echo '<div class="menu"><a href="?act=set">Настройки</a></div>'
            . '<div class="menu"><a href="?act=sponsor">Спонсоры</a></div>';
    }

    echo '<div class="menu"><a href="?act=win">Итоги</a></div>';
// нам же нужен тот самый товарищ, который тыкнет и создаст файл

    $lasttime = $loto_settings['exit_date'] - time();

    $NGres = NGcounter($lasttime);

    echo '<div class="list2" style="padding-bottom: 18px">';
    if ($loto_settings['exit_date'] >= time()) {
        echo '<h1 style="background-color: WhiteSmoke;">До окончания конкурса осталось <br /> ' . endofstr($NGres['d'], 'day') . ', ' . endofstr($NGres['h'], 'hor') . ', ' . endofstr($NGres['m'], 'min') . ', ' . endofstr($NGres['s'], 'sec') . '</h1>';
    }
    echo '<h2>В лоторее ' . ($loto_settings['exit_date'] <= time() ? 'принимало' : 'принимают') . ' участие ' . endofstr($total, 'member') . '</h2>';
    echo '<h3>Призовой фонд составляет ' . $prizefond . ' рублей</h3>';
    echo '</div>';

    if ($r_blacklist || $r_on_site || $r_karma || $r_datereg || $r_ban || $r_post_forum) {
        // Для тех, кто исключен
        echo '<div class="rmenu"><h3>К сожалению Вы исключены из розыгрыша призов</h3>' .
            'Не соблюдаются следующие условия:<ul>' .
            ($r_blacklist ? '<li>Спонсоры исключены из конкурса</li>' : '') .
            ($r_on_site ? '<li>Проведенное время на сайте менее ' . ($loto_settings['total_on_site'] / 86400) . ' дней</li>' : '') .
            ($r_karma ? '<li>Нужна положительная карма</li>' : '') .
            ($r_datereg ? '<li>Дата регистрации на сайте менее ' . ($loto_settings['datereg'] / 86400) . ' дней назад</li>' : '') .
            ($r_ban ? '<li>Есть баны за последние ' . ($loto_settings['period'] / 86400) . ' дней</li>' : '') .
            ($r_post_forum ? '<li>Постов на форуме менее ' . $loto_settings['forum_posts'] . ' за последних ' . ($loto_settings['period'] / 86400) . ' дней</li>' : '') .
            '</ul></div>';
    } else {
        // Для тех, кто принимает участие
        echo '<div class="gmenu"><h3>Отлично! Вы принимаете участие в розыгрыше призов</h3>' .
            'Не забывайте, что для получения приза есть дополнительные условия:' .
            '<ul>' .
            '<li>У Вас должен быть Webmoney кошелек.</li>' .
            '<li>После объявления результатов розыгрыша, Вы в течение 3-х дней должны выслать администраторам номер своего кошелька.</li>' .
            '<li>Если в течение 3-х дней номер кошелька не был получен, то Ваш выигрыш отдается другим игрокам.</li>' .
            '</ul>';
        echo '</div>';
    }

    echo '<div class="phdr"><a href="?act=member">Посмотреть участников</a></div>';
}

require_once('../incfiles/end.php');