<?php
# Disable direct access
if (!defined('POLL_ADMIN_SECURE')) exit('<span style="font:11px calibri; color:#990000">no access</span>');

# Define classes
$pollClass = POLL_DATA.'Poll';
$optionClass = POLL_DATA.'Options';
$voteClass = POLL_DATA.'Votes';

# Load poll details
$poll = new $pollClass();
$poll->loadDetails($pollId);
$poll->title = ereg_replace('<br>|</br>',' ',$poll->title);
?>

<table id="dracon_poll_admin_polls" align="center" cellpadding="5" cellspacing="1" style="color:#000; background:#ccc; border:1px solid #990000">
<tr>
  <td colspan="14" class="dracon_poll_admin_header">
    <img class="dracon_poll_admin_info" title="<span style='color:orange'>Control Panel - Options</span><hr size='1' style='color:#777'>List of all options for the selected poll. <br /><br /><span style='color:yellow'>Hover for tips</span>" src="../skins/default/gfx/spacer.gif" /> 
    <strong><em>-  Options List for Poll #<?php echo $pollId; ?>: <a class="dracon_poll_admin_options_link"><?php echo $poll->title; ?></a> -</em></strong>
  </td>
</tr>
<tr class="dracon_poll_admin_tr_hr">
  <td></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Option ID</span><hr size='1' style='color:#777'>This is the <span style='color:yellow'>Id</span> used in the database or xml file.<br /><br /> Informative only.">#</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Option Title</span><hr size='1' style='color:#777'>Title of your option. <br /><br />No limitations.">Title</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Option Bullet</span><hr size='1' style='color:#777'>Image of the bullet being displayed by the skin. <br /><br />Depends on the skin's <span style='color:yellow'>CSS</span>">Bullet</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Option Order</span><hr size='1' style='color:#777'>Option reordering is possible by changing the position number. <span style='color:yellow'>Drag&amp;drop planned</span>">Order</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Option Status</span><hr size='1' style='color:#777'>To <span style='color:yellow'>disable</span> the option and disallow further voting deactivate it with this switch.">Active</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Votes</span><hr size='1' style='color:#777'>Number of votes the option has received. This field is only <span style='color:yellow'>informative</span>. Initial votes <span style='color:yellow'>planned</span>.">Votes</span></td>
  <td align="center" style="color:blue"><span id="dracon_poll_admin_save_all" class="dracon_poll_admin_info_obj" onmouseover="this.style.cursor='pointer'" title="<span style='color:orange'>Save Option</span><br />Any changes you make will be saved when you hit the <span style='color:yellow'>Save button</span> only to opts. with this box <span style='color:yellow'>checked</span>.<br /><span style='color:lime'>Click to select all.</span>">Save</span></td>
  <td align="center" style="color:blue"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Delete Option</span><hr size='1' style='color:#777'>If you no longer wish to keep your option, you can <span style='color:yellow'>remove</span> it with this button. Irreversible.">Del</span></td>
</tr>
<?php
# Load options
$options = new $optionClass();
if (POLL_DATA == 'mysql') {
  $options->addWhere('pollId = '.$pollId);
  $options->addOrder('position');
  $options->loadList();
}
else {
  $options->loadList($pollId,false);  // only active
}

# Display results
$optionCounter = 0;
if (isset($options->objList) && is_array($options->objList)) {
	foreach($options->objList as $optionId) {
		$optionCounter++;
		$option = $options->loadDetails($optionId,$pollId);
    # Load votes
    $votes = new $voteClass();
    if (POLL_DATA == 'mysql') {
      $votes->addWhere('pollId = '.$pollId);
      $votes->addWhere('optionId = '.$optionId);
      $vote = $votes->loadNumList();
    }
    else {
      $votes->loadList($optionId,$pollId);
      $vote = (isset($votes->voteCount)) ? $votes->voteCount : 0;
    }
    # Display accetend characters correctly
    //$optionTitle = $option->utf8UrlDecode($option->title);
    //$optionTitle = $option->title;
?>
<tr class="dracon_poll_admin_tr">
  <td style="font-size:10px; color:#999"><?php echo $optionCounter; ?>.</td>
  <td><input id="dracon_poll_admin_option_id[<?php echo $optionCounter; ?>]" class="dracon_poll_text_center" readonly value="<?php echo $option->optionId; ?>" style="width:30px" /></td>
  <td><input id="dracon_poll_admin_option_title[<?php echo $optionCounter; ?>]" class="dracon_poll_admin_input_200" value="<?php echo $option->title; ?>" style="width:200px" /></td>
  <td><input id="dracon_poll_admin_option_bullet[<?php echo $optionCounter; ?>]" class="dracon_poll_admin_input_40" maxlength="2" value="<?php echo $option->bullet; ?>" style="width:40px" /></td>
  <td><input id="dracon_poll_order_div[<?php echo $optionCounter; ?>]" class="dracon_poll_admin_input_40" maxlength="2" value="<?php echo $option->position; ?>" style="width:40px" /></td>
  <td style="padding-left:12px"><img id="dracon_poll_admin_option_status[<?php echo $optionCounter; ?>]" class="dracon_poll_admin_checkbox_3<?php if ($option->status == 1) echo '_on'; ?>" src="../skins/default/gfx/spacer.gif" /></td>
  <td style="border-right:1px solid #9999FF"><input id="dracon_poll_admin_option_votes[<?php echo $optionCounter; ?>]" class="dracon_poll_text_right" readonly value="<?php echo $vote; ?>" style="width:35px; font:normal 11px tahoma" /></td>
  <td style="padding-left:7px"><img id="dracon_poll_admin_option_save[<?php echo $optionCounter; ?>]" class="dracon_poll_admin_checkbox_1" src="../skins/default/gfx/spacer.gif" /></td>
  <td align="center"><img class="dracon_poll_admin_del" src="../skins/default/gfx/spacer.gif" alt="<?php echo $option->optionId; ?>,<?php echo $pollId; ?>" /></td>
</tr>

<?php } } ?>

<tr><td colspan="14" style="padding:0px">&nbsp;</td></tr>
</table>

<div style="padding-top:10px">
<input type="hidden" value="<?php echo $pollId;?>">
<button id="dracon_poll_admin_add_new" value="<?php echo $pollId;?>" class="dracon_poll_admin_button dracon_poll_admin_button_4">Создать новое</button>&nbsp;
<button id="dracon_poll_admin_poll_save" value="<?php echo $pollId;?>" class="dracon_poll_admin_button dracon_poll_admin_button_3">Сохранить</button>
</div>
