<?php

# MySQL Type Data
class dbConnection {
  
  # Define empty variables
  var $sqlWhere; var $sqlGroup; var $sqlOrder; var $sqlLimit;
  
  # Connect to database
  function loadDb($host=false,$user=false,$pass=false,$dbase=false) {
    if (!$host || !$user || !$dbase) {
      # Poll config specific
      $host = POLL_DB_HOST; $user = POLL_DB_USER; $pass = POLL_DB_PASS; $dbase = POLL_DB_NAME;
    }
    if (!isset($this->_dbConn)) $this->_dbConn = mysql_connect($host, $user, $pass) or die('error: connecting to mysql failed');
    $this->_dbName = mysql_select_db($dbase, $this->_dbConn) or die('error: selecting database failed');
  }

  # Define table name and fields
  function loadTable($table,$id_field=false) {
    $this->_tableName = POLL_DB_PREFIX.$table;
    $qry = "SHOW COLUMNS FROM ".$this->_tableName;
    $res = mysql_query($qry) or die('error: table loading failed');
    if (mysql_num_rows($res) > 0) {
      while ($row = mysql_fetch_assoc($res)) {
        $this->_tableFields[] = $row;
        # Locate id field
        if ($row['Key'] == 'PRI') $this->id = $row['Field'];
      }
      # Override detected id field
      if ($id_field) $this->id = $id_field;
    }
  }
  
  # Sets query filter
  function addWhere($data, $sep=' AND ') {
    $this->sqlWhere = (isset($this->sqlWhere)) ? $this->sqlWhere.$sep.$data : " WHERE $data";
    if (!$data) $this->sqlWhere = '';
  }

  # Sets query order
  function addOrder($data) {
    $this->sqlOrder = " ORDER BY $data";
  }

  # Sets query grouping
  function addGroup($data) {
    $this->sqlGroup = " GROUP BY $data";
  }

  # Sets query limit
  function setLimit($data) {
    $this->sqlLimit = " LIMIT $data";
  }
  
  # Load (un)filtered id list
  function loadList($input=false) {
    if (!$input) $input = $this->id;
    $qry = "SELECT $input FROM ".$this->_tableName.$this->sqlWhere.$this->sqlGroup.$this->sqlOrder.$this->sqlLimit;
    $res = mysql_query($qry) or die('error: list loading failed');
    while ($output = mysql_fetch_assoc($res)) {
      $this->objList[] = $output[$input];
    }
  }

  # Load num of (un)filtered id list
  function loadNumList($data=false) {
    if (!$data) $data = $this->id;
    $qry = "SELECT count($data) FROM ".$this->_tableName.$this->sqlWhere.$this->sqlGroup.$this->sqlOrder.$this->sqlLimit;
    $res = mysql_query($qry) or die('error: num list loading failed');
    $count = mysql_fetch_row($res);
    return $count[0];
  }

  # Load full data
  function loadDetails($id) {
    $qry = "SELECT * FROM ".$this->_tableName." WHERE ".$this->id." = ".$id;
    $res = mysql_query($qry) or die('error: details loading failed');
    if ($row = mysql_fetch_assoc($res)) {
      foreach($row as $index => $value) $this->$index = $this->utf8UrlDecode($value);
      return $this;
    }
    else return false;
  }
  
  # Save details
  function saveDetails() {
    $qry = "UPDATE ".$this->_tableName." SET ";
    foreach ($this->_tableFields as $tableField) {
      # Sanitize input data
      $data = mysql_real_escape_string($this->$tableField['Field']);
      # Exclude id field from update
      if ($tableField['Field'] != $this->id) {
        if (substr_count($tableField['Type'], 'int')) $qry .= $tableField['Field']." = ".$data.", ";
        else $qry .= $tableField['Field']." = '".$data."', ";  // enclose non-int into quotes
      }
    }
    $qry = rtrim(trim($qry), ",");  // remove last comma
    $qry .= " WHERE ".$this->id." = ".$this->{$this->id}; 
    mysql_query($qry) or die('error: details saving failed');
  }
  
  # Add new item ~ requires more automated approach
  function addObject($fields,$values) {
    $qry = "INSERT INTO ".$this->_tableName." (";
    foreach ($fields as $field) $qry .= $field.",";
    $qry = rtrim(trim($qry), ",").") VALUES (";
    foreach ($values as $value) $qry .= $value.",";
    $qry = rtrim(trim($qry), ",").")";
    mysql_query($qry) or die('error: adding new entry failed');
    $this->{$this->id} = mysql_insert_id();
  }  
  
  # Delete existing item 
  function delObject($id) {
    $qry = "DELETE FROM ".$this->_tableName." WHERE ".$this->id." = ".$id;
    mysql_query($qry) or die('error: deleting failed');         
    return mysql_insert_id();
  }  
  
  # UTF-8 and URL decoder
  function utf8UrlDecode($string) {
  	$string = utf8_encode($string);
    $string = preg_replace("/%u([0-9a-f]{3,4})/i", "&#x\\1;", urldecode($string));
    return html_entity_decode($string, null, "utf-8");
  }
    
}


class mysqlPoll extends dbConnection {
  
  # Initialize table
	function mysqlPoll() {
    if (!isset($this->_dbConn)) $this->loadDb();
    if (!isset($this->_tableName)) $this->loadTable('poll_base');
	}
  
  # Add new poll ~ doesn't this rather belong into the php side?
	function addNewPoll() {
    $fields[] = 'status'; $values[] = 1;
    $this->addObject($fields,$values);
    $this->title = 'Новое';
    $this->multiline = 0;
    $this->status = 1;
    $this->width = 150;
    $this->height = 150;
    $this->skin = 'default';
    $this->effect = 'full';
    $this->fxspeed = 500;
    $this->multichoice = 1;
    $this->votes = 0;
    $this->saveDetails();
	}
  
  # Delete existing poll
  function delPoll($pollId) {
    $this->delObject($pollId);
  }
  
  # Save poll details ~ anti-mysql optimisation ;)
	function savePolls($pollData) {
		if (!array_key_exists('pollId', $pollData)) return false;  // no data
		$dataKeys = array_keys($pollData);
		# Loop through $pollData
    foreach ($pollData['pollId'] as $pollKey => $pollId) {
      $this->loadDetails($pollId);
      foreach ($dataKeys as $dataKey) {
        $this->$dataKey = $pollData[$dataKey][$pollKey];    
      }
      $this->saveDetails();
    }
	}

}


class mysqlOptions extends dbConnection {

  # Initialize table
  function mysqlOptions() {
    if (!isset($this->_dbConn)) $this->loadDb();
    if (!isset($this->_tableName)) $this->loadTable('poll_option');
  }
  
  # Delete all options for selected poll
  function delAllOptions($pollId) {
    $this->addWhere('pollId = '.$pollId);
    $this->loadList();
    if (isset($this->objList) && is_array($this->objList)) {  
      foreach($this->objList as $pollId) $this->delObject($pollId);
      return true;
    }
  }
  
  # Add new option ~ doesn't this rather belong into the php side?
  function addNewOption($pollId) {
    $fields[] = 'status'; $values[] = 1;
    $this->addObject($fields,$values);
    # Reload object ~ speed test desired
    //$this->loadDetails($this->{$this->id});  // speed?
    # Update
    $this->title = 'Новое';
    $this->pollId = $pollId;
    $this->status = 1;
    $this->bullet = 1;
      # Get last position
      $this->addWhere('pollId = '.$pollId);
      $this->addOrder('position DESC');
      $this->setLimit(1);
      $this->loadList('position');
      if (!isset($this->objList[0])) $this->objList[0] = 0;
      $this->position = $this->objList[0] + 1;
    $this->saveDetails();
  }
  
  # Delete existing option
  function delOption($optionId) {
    $this->delObject($optionId);
  }  
  
  # Save option details ~ anti-mysql optimisation ;)
  function saveOptions($optionData) {
    if (!array_key_exists('optionId', $optionData)) return false;  // no data
    $dataKeys = array_keys($optionData);
    # Loop through $optionData
    foreach ($optionData['optionId'] as $optionKey => $optionId) {
      $this->loadDetails($optionId);
      foreach ($dataKeys as $dataKey) {
        $this->$dataKey = $optionData[$dataKey][$optionKey];    
      }
      $this->saveDetails();
    }
  }
    
}


class mysqlVotes extends dbConnection {

  # Initialize table
  function mysqlVotes() {
    if (!isset($this->_dbConn)) $this->loadDb();
    if (!isset($this->_tableName)) $this->loadTable('poll_vote');
  }

  # Check for existing IP address
	function checkIP($pollId,$ipAddr) {
    $this->addWhere('pollId = '.$pollId);
    $this->addWhere('ipAddress = "'.$ipAddr.'"');
    $this->loadList();
    if (isset($this->objList) && is_array($this->objList)) {  
      # Vote allowed only once
      if (POLL_VOTED_ONCE === true) return true;
      foreach($this->objList as $voteId) {
        $this->loadDetails($voteId);
        $voteTime = time() - strtotime($this->voteTime);
        if (POLL_VOTED_TIME > $voteTime) return true;
      }
    }
    return false;
	}
  
  # Add new vote ~ doesn't this rather belong into the php side?
	function addVote($optionId,$pollId) {
    $fields[] = 'pollId'; $values[] = '\'0\'';
    $this->addObject($fields,$values);
    $this->pollId = $pollId;
    $this->optionId = $optionId;
    $this->ipAddress = $_SERVER['REMOTE_ADDR'];
    $this->voteTime = date('Y-m-d H:i:s');
    $this->saveDetails();
	}
  
  # Delete all votes for selected poll
  function delAllVotes($pollId) {
    $this->addWhere('pollId = '.$pollId);
    $this->loadList();
    if (isset($this->objList) && is_array($this->objList)) {  
      foreach($this->objList as $pollId) $this->delObject($pollId);
      return true;
    }
  }

  # Delete all votes for one option
  function delVotes($optionId) {
    $this->addWhere('optionId = '.$optionId);
    $this->loadList();
    if (isset($this->objList) && is_array($this->objList)) {  
      foreach($this->objList as $optionId) $this->delObject($optionId);
      return true;
    }
  }
  
}

?>