<?php
/****************************************************************************\
* Dracon AJAX Poll                                                           *
******************************************************************************
* Version: 1.6                                                               *
* Author: Searcher <searcher@dracon.biz>                                     *
* License: http://www.dracon.biz/license.php                                 *
\****************************************************************************/

//error_reporting(E_ALL);  // debug only
define('POLL_VERSION', '1.5');  // current version
define('POLL_RELEASE', '15th May 2010');  // current version

# Admin access (CMS integration - set POLL_ADMIN_SECURE to false)
define('POLL_ADMIN_SECURE', true);  // standalone admin panel security
define('POLL_ADMIN_LOGIN', 'admin');  // admin login 
define('POLL_ADMIN_PASS', 'admin');  // admin password 

# Data system
define('POLL_SKIN', 'default');  // default skin
define('POLL_DATA', 'mysql');  // xml, mysql 

# MySQL database settings
define('POLL_DB_HOST', 'localhost');  // edit address 
define('POLL_DB_USER', 'root');  // edit username 
define('POLL_DB_PASS', '');  // edit password 
define('POLL_DB_NAME', 'test');  // edit db name 
define('POLL_DB_PREFIX', '');  // set if you require a prefix 

# Returning visitors
define('POLL_VOTED_ONCE', true);  // voting is allowed only once 
define('POLL_VOTED_TIME', '3600');  // time in seconds before a new vote is allowed 
define('POLL_VOTED_SKIP_ANI', true);  // skip animation if already voted 
define('POLL_NO_RESULTS', false);  // do not display results after voting 

# Define default paths
define('POLL_ROOT', dirname(__FILE__).'/../');  // autodetected

# Detect Web Root
$poll_html = (isset($_SERVER['HTTPS'])) ? 'https://' : 'http://';
$poll_server = $_SERVER['SERVER_NAME'];
$poll_uri = substr($_SERVER['REQUEST_URI'], 0, strrpos($_SERVER['REQUEST_URI'], '/'));
if (substr_count($poll_uri, '/admin')) $poll_uri = substr($poll_uri, 0, strrpos($poll_uri, '/admin')); // admin fix
if (substr_count($poll_uri, '/install')) $poll_uri = substr($poll_uri, 0, strrpos($poll_uri, '/install')); // install fix
define('POLL_WEB_ROOT', 'http://test/');  // make sure this is correct 

# XML data files - all must be writable by web server
define('POLL_XML_BASE', POLL_ROOT.'data/poll_base.xml');  // main poll xml data file
define('POLL_XML_OPTIONS', POLL_ROOT.'data/poll_option.xml');  // options xml data file
define('POLL_XML_VOTES', POLL_ROOT.'data/poll_vote.xml');  // votes xml data file

# Include classes
include POLL_ROOT.'include/classes/'.POLL_DATA.'.php';  // xml or mysql class

# Include modules
include POLL_ROOT.'include/modules/functions.php';  // default functions

# Include languages
include POLL_ROOT.'include/language.php'  // default language
?>