<?php
require '../src/RBlackListSitesConfig.php';
$config_file = 'data/config.json';
$config = new RBlackListSitesConfig($config_file);

if (isset($_GET['host'], $_GET['domain']) === false){
    exit('Не указан хост или домен');
}else{
    $site = $config->getSite($_GET['host'], $_GET['domain']);
}

$host = isset($_POST['host']) ? htmlspecialchars($_POST['host']) : $site['host'];
$domain = isset($_POST['domain']) ? htmlspecialchars($_POST['domain']) : $site['domain'];

if (isset($_POST['submit'])){
    if (($host == $site['host'] && $domain == $site['domain']) || ($config->updateSite($site, $host, $domain) && $config->save())){
        header('Location: index.php');
    }else{
        echo '<ul>';
        foreach ($config->getErrors() as $error){
            echo '<li>' . $error . '</li>';
        }
        echo '</ul>';
    }
}

?>

<form action="#" method="post">
    <div>
        <div>
            <label>Хост:</label>
        </div>
        <input type="text" name="host" value="<?= $host ?>">
    </div>
    <div>
        <div>
            <label>Домен:</label>
        </div>
        <input type="text" name="domain" value="<?= $domain ?>">
    </div>
    <div>
        <input type="submit" name="submit" value="Сохранить">
    </div>
</form>