
DROP TABLE IF EXISTS `kolhoz_ban`;
CREATE TABLE IF NOT EXISTS `kolhoz_ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `izg` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_blacklist`;
CREATE TABLE IF NOT EXISTS `kolhoz_blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_ank` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_chat`;
CREATE TABLE IF NOT EXISTS `kolhoz_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `mother` int(11) DEFAULT '0',
  `pos` int(11) DEFAULT '0',
  `admod` set('0','1') DEFAULT '0',
  `type` enum('room','komm') DEFAULT 'room',
  `msg` varchar(10000) DEFAULT NULL,
  `opis` varchar(10000) DEFAULT NULL,
  `name` varchar(1024) DEFAULT NULL,
  `otvet` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_chat` (`id`, `id_user`, `time`, `mother`, `pos`, `admod`, `type`, `msg`, `opis`, `name`, `otvet`) VALUES
(1, 1, 1459176511, 0, 1, '0', 'room', NULL, 'Все замечены ошибки в игре пишем здесь.', 'Ошибки', 0);


DROP TABLE IF EXISTS `kolhoz_collective`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(24) DEFAULT NULL,
  `rating` bigint(255) DEFAULT '0',
  `money` bigint(255) DEFAULT '0',
  `rubies` bigint(255) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `tehnika` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `time_obmen` int(11) DEFAULT '0',
  `station` enum('0','1') DEFAULT '0',
  `flowerbed` enum('0','1') DEFAULT '0',
  `rating_gos` bigint(255) DEFAULT '0',
  `titleText` varchar(64) DEFAULT NULL,
  `titleText_user` int(11) DEFAULT NULL,
  `titleText_time` int(11) DEFAULT NULL,
  `soil` int(11) DEFAULT '0',
  `irrigate` int(11) DEFAULT '0',
  `scholl` int(11) DEFAULT '0',
  `vet` int(11) DEFAULT '0',
  `bank` int(11) DEFAULT '0',
  `lib` enum('0','1') DEFAULT '0',
  `greenhouse` int(11) DEFAULT '0',
  `school` int(11) DEFAULT '0',
  `nalog` int(11) DEFAULT '0',
  `time_nalog` int(11) DEFAULT NULL,
  `users_add` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `kolhoz_collective_ahlist`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_ahlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `heli` enum('1','2','3','4') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `kolhoz_collective_cash`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_cash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `type` enum('rubies','money') DEFAULT 'rubies',
  `time` int(11) DEFAULT '0',
  `count` bigint(255) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_chat`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(10000) DEFAULT NULL,
  `otvet` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_club`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_club` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_collective` int(11) DEFAULT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `mother` int(11) DEFAULT '0',
  `guest` set('0','1') DEFAULT '0',
  `type` enum('razdel','tema','komm') DEFAULT 'razdel',
  `msg` varchar(10000) DEFAULT NULL,
  `name` varchar(1024) DEFAULT NULL,
  `locked` enum('0','1') DEFAULT '0',
  `otvet` int(11) DEFAULT '0',
  `pined` enum('0','1') DEFAULT '0',
  `pos` int(11) DEFAULT '0',
  `time_obnov` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_comp`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_comp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT '0',
  `id_gos` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `kolhoz_collective_comp_user`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_comp_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT '0',
  `id_comp` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_gos`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_gos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT '0',
  `id_plant` int(11) DEFAULT '0',
  `type` enum('rating','harvest') DEFAULT 'rating',
  `active` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_gos_ct`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_gos_ct` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_collective` int(11) DEFAULT '0',
  `id_gos` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_hangar`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_hangar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `gaz` int(11) DEFAULT '0',
  `heli` enum('1','2','3','4') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_heli`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_heli` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `gaz` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `heli` enum('0','1','2','3','4') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_history`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `type` enum('in','out','st_up','st_down') DEFAULT 'in',
  `status` enum('1','2','3','4','5','6','7') DEFAULT '1',
  `dei` enum('who','user') DEFAULT 'user',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_invite`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_rating`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `count` bigint(255) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_collective_rating_gos`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_rating_gos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_collective_user`;
CREATE TABLE IF NOT EXISTS `kolhoz_collective_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `rating` bigint(255) DEFAULT '0',
  `money` bigint(255) DEFAULT '0',
  `rubies` bigint(255) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `status` enum('1','2','3','4','5','6','7') DEFAULT '1',
  `rubies_week` bigint(255) DEFAULT '0',
  `rating_week` bigint(255) DEFAULT '0',
  `rating_gos` bigint(255) DEFAULT '0',
  `tehnika` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_fish`;
CREATE TABLE IF NOT EXISTS `kolhoz_fish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `money` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_fish` (`id`, `name`, `cena`, `rating`, `count`, `time`, `money`, `time_soil`, `level`) VALUES
(1, 'Голец', 75, 8, 4, 3600, 136, 60, 2),
(2, 'Хариус', 100, 40, 4, 10800, 180, 180, 4),
(3, 'Минтай', 125, 60, 4, 18000, 220, 240, 6),
(4, 'Нерка', 175, 120, 5, 28800, 650, 600, 8),
(5, 'Судак', 225, 650, 5, 43200, 650, 780, 12),
(6, 'Кижуч', 350, 176, 5, 64800, 800, 840, 15),
(7, 'Треска', 450, 224, 5, 79200, 925, 900, 18),
(8, 'Форель', 550, 264, 4, 93600, 1050, 1080, 19),
(9, 'Язь', 600, 300, 6, 115200, 1530, 1200, 22),
(10, 'Щука', 760, 352, 4, 144000, 1700, 1320, 24),
(11, 'Креветка', 900, 384, 8, 172800, 1856, 1440, 26),
(12, 'Устрица', 1000, 400, 5, 208800, 2466, 1560, 28),
(13, 'Белый Амур', 1200, 420, 6, 237600, 2676, 1680, 30),
(14, 'Осетр', 1750, 460, 6, 259200, 3234, 1800, 34),
(15, 'Белуга', 2500, 500, 6, 302400, 3234, 2040, 36),
(16, 'Семга', 2750, 625, 6, 345600, 4260, 2160, 38),
(17, 'Лосось', 3000, 700, 6, 388800, 4700, 2400, 42),
(18, 'Камбала', 3250, 800, 6, 432000, 4800, 2640, 46),
(19, 'Стерлядь', 3500, 900, 6, 504000, 5070, 2760, 48),
(20, 'Морской еж', 4000, 1000, 8, 648000, 5610, 2700, 50);

DROP TABLE IF EXISTS `kolhoz_food`;
CREATE TABLE IF NOT EXISTS `kolhoz_food` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `arena` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_friends`;
CREATE TABLE IF NOT EXISTS `kolhoz_friends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_ank` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_gift`;
CREATE TABLE IF NOT EXISTS `kolhoz_gift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `id_cat` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_gift` (`id`, `name`, `cena`, `id_cat`) VALUES
(3, 'Маргарита', 1000, 2),
(4, 'Легкость', 500, 2),
(5, 'Аромат', 500, 2),
(6, 'Свежесть', 500, 2),
(7, 'Бодрость', 500, 2),
(8, 'Дижестив', 500, 2),
(9, 'Клубника', 1000, 3),
(10, 'Ассорти', 500, 3),
(11, 'Десерт', 500, 3),
(12, 'Малина', 500, 3),
(13, 'Мороженое', 500, 3),
(14, 'Пирожное', 500, 3),
(15, 'Торт', 500, 3),
(16, 'Утёнок', 1000, 4),
(17, 'Слоник', 500, 4),
(18, 'Зайка', 500, 4),
(19, 'Лапа', 500, 4),
(20, 'Милашка', 500, 4),
(21, 'Озорник', 500, 4),
(22, 'Золотое сердце', 1000, 5),
(23, 'Медальон "Любящее сердце"', 500, 5),
(24, 'Медальон "Энергия жизни"', 500, 5),
(25, 'Кольцо с сапфиром', 500, 5),
(26, 'Кольцо с рубином', 500, 5),
(27, 'Обручальное кольцо', 500, 5),
(28, 'С любовью', 1000, 6),
(29, 'Букет', 500, 6),
(30, 'Тебе с нежностью', 500, 6),
(31, 'Волшебство', 500, 6),
(32, 'Легкого настроения', 500, 6),
(33, 'Ромашки', 500, 6),
(34, 'Роза', 500, 6),
(35, 'Подснежники', 500, 6),
(36, 'Букет невесты', 500, 6),
(37, 'Джип', 10000, 7),
(38, 'Парфюм', 10000, 7),
(39, 'Ноутбук', 10000, 7),
(40, 'Пистолет', 10000, 7),
(41, 'Гламурные тапочки', 50000, 7),
(42, 'Сувенир', 50000, 7),
(43, 'Rolex', 100000, 7),
(44, 'Для Королевы...', 100000, 7),
(45, 'Финансовых успехов!', 50000, 7),
(46, 'Лови жука', 500, 8),
(47, 'Сковорода', 500, 8),
(48, 'В добрый путь!', 500, 8),
(49, 'Ученье - свет!', 500, 8),
(50, 'Вредина', 500, 8),
(53, 'Елочные игрушки ', 500, 9),
(54, 'Змейка ', 500, 9),
(55, 'Мешок подарков ', 500, 9),
(56, 'Снеговик', 20000, 9),
(57, 'Сноуборд', 50000, 9),
(58, 'Дед Мороз', 100000, 9);

DROP TABLE IF EXISTS `kolhoz_gifts`;
CREATE TABLE IF NOT EXISTS `kolhoz_gifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_kont` int(11) DEFAULT NULL,
  `id_gift` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `read` set('0','1') DEFAULT '0',
  `msg` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_gift_cat`;
CREATE TABLE IF NOT EXISTS `kolhoz_gift_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_gift_cat` (`id`, `name`) VALUES
(2, 'Напитки'),
(3, 'Вкусности'),
(4, 'Игрушки'),
(5, 'Украшения'),
(6, 'Цветы'),
(7, 'Премиум'),
(8, 'Повседневные'),
(9, 'Новогодние');

DROP TABLE IF EXISTS `kolhoz_ground`;
CREATE TABLE IF NOT EXISTS `kolhoz_ground` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT '0',
  `soil` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `cultivator` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_korm`;
CREATE TABLE IF NOT EXISTS `kolhoz_korm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_korm` (`id`, `name`, `cena`, `rating`, `time`, `level`) VALUES
(1, 'Зерно', 50, 10, 3600, 1),
(2, 'Комбикорм', 100, 50, 7200, 10),
(3, 'Муха', 350, 100, 14400, 20),
(4, 'Рачки', 750, 400, 19440, 30),
(5, 'Крилевые хлопья', 1250, 800, 129600, 40);

DROP TABLE IF EXISTS `kolhoz_level`;
CREATE TABLE IF NOT EXISTS `kolhoz_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(1000) DEFAULT '0',
  `rating` varchar(1000) DEFAULT '0',
  `rubies` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_level` (`id`, `level`, `rating`, `rubies`) VALUES
(1, '2', '100', 2),
(2, '3', '250', 3),
(3, '4', '495', 4),
(4, '5', '798', 5),
(5, '6', '1100', 6),
(6, '7', '1500', 7),
(7, '8', '1900', 8),
(8, '9', '2300', 9),
(9, '10', '2800', 10),
(10, '11', '3300', 11),
(11, '12', '3800', 12),
(12, '13', '4400', 13),
(13, '14', '4900', 14),
(14, '15', '5500', 15),
(15, '16', '6100', 16),
(16, '17', '11700', 17),
(17, '18', '21200', 18),
(18, '19', '37100', 19),
(19, '20', '63700', 20),
(20, '21', '107600', 21),
(21, '22', '163300', 22),
(22, '23', '237000', 23),
(23, '24', '398900', 24),
(24, '25', '750100', 25),
(25, '26', '1510000', 26),
(26, '27', '3170000', 27),
(27, '28', '6780000', 28),
(28, '29', '14630000', 29),
(29, '30', '31710000', 30),
(30, '31', '50000000', 31),
(31, '32', '75000000', 32),
(32, '33', '100000000', 33),
(33, '34', '125000000', 34),
(34, '35', '150000000', 35),
(35, '36', '300000000', 36),
(36, '37', '600000000', 37),
(37, '38', '1200000000', 38),
(38, '39', '2400000000', 39),
(39, '40', '4800000000', 40),
(40, '41', '7000000000', 41),
(41, '42', '10000000000', 42),
(42, '43', '15000000000', 43),
(43, '44', '20000000000', 44),
(44, '45', '25000000000', 45),
(45, '46', '30000000000', 46),
(46, '47', '35000000000', 47),
(47, '48', '40000000000', 48),
(48, '49', '45000000000', 49),
(49, '50', '50000000000', 50),
(50, '51', '60000000000', 51),
(51, '52', '70000000000', 52),
(52, '53', '80000000000', 53),
(53, '54', '90000000000', 54),
(54, '55', '100000000000', 55),
(55, '56', '200000000000', 56),
(56, '57', '300000000000', 57),
(57, '58', '400000000000', 58),
(58, '59', '500000000000', 59),
(59, '60', '600000000000', 60),
(60, '61', '700000000000', 61),
(61, '62', '800000000000', 62),
(62, '63', '900000000000', 63),
(63, '64', '1000000000000', 65),
(64, '65', '1100000000000', 65),
(65, '66', '1200000000000', 66),
(66, '67', '1300000000000', 67),
(67, '68', '1400000000000', 68),
(68, '69', '1500000000000', 69),
(69, '70', '1600000000000', 70),
(70, '71', '1700000000000', 71),
(71, '72', '1800000000000', 72),
(72, '73', '1900000000000', 73),
(73, '74', '2000000000000', 74),
(74, '75', '2100000000000', 75);

DROP TABLE IF EXISTS `kolhoz_mail`;
CREATE TABLE IF NOT EXISTS `kolhoz_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_kont` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `read` set('0','1') DEFAULT '0',
  `type` enum('at','to') DEFAULT 'to',
  `sistem` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_market`;
CREATE TABLE IF NOT EXISTS `kolhoz_market` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant2` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `arena` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_mest`;
CREATE TABLE IF NOT EXISTS `kolhoz_mest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT '0',
  `soil` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `cultivator` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_pet`;
CREATE TABLE IF NOT EXISTS `kolhoz_pet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `money` int(11) DEFAULT '0',
  `rating` varchar(1000) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `work` varchar(1000) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_pet` (`id`, `name`, `cena`, `money`, `rating`, `level`, `work`) VALUES
(1, 'Шелкопряд', 1000, 200, '300', 10, 'Приносит шелк'),
(2, 'Курица', 10000, 500, '3000', 16, 'Приносит куриные яйца'),
(4, 'Гусыня', 100000, 700, '5000', 22, 'Приносит гусиные яйца'),
(5, 'Корова', 150000, 700, '6000', 18, 'Приносит молоко'),
(6, 'Овечка', 175000, 800, '8000', 20, 'Приносит шерсть'),
(7, 'Пчела', 250000, 1000, '10000', 24, 'Приносит мёд'),
(9, 'Перепелка', 1000000, 1500, '10000', 32, 'Приносит перепелиные яйца'),
(10, 'Шиншила', 1750000, 1500, '20000', 30, 'Приносит мех'),
(11, 'Крокодил', 20000000, 3000, '50000', 35, 'Приносит кожу'),
(12, 'Марал', 25000000, 5000, '75000', 36, 'Приносит рога'),
(13, 'Лебедь', 30000000, 6000, '65000', 38, 'Приносит пух'),
(14, 'Фламинго', 32000000, 10000, '100000', 38, 'Участвует в выставках'),
(15, 'Бобер', 35000000, 12000, '85000', 40, 'Заготавливает древесину'),
(16, 'Панда', 38000000, 20000, '130000', 40, 'Участвует в выставках'),
(17, 'Страус', 37000000, 15000, '110000', 41, 'Приносит страусиные яйца'),
(18, 'Рысь', 40000000, 26000, '170000', 41, 'Участвует в выставках'),
(19, 'Павлин', 39000000, 20000, '140000', 42, 'Участвует в выставках'),
(20, 'Лиса', 45000000, 34000, '220000', 42, 'Ворует яйца'),
(21, 'Сокол', 34000000, 26000, '185000', 43, 'Участвует в соколиной охоте'),
(22, 'Лев', 50000000, 44000, '285000', 43, 'Участвует в выставках'),
(23, 'Индюк', 55000000, 32000, '200000', 44, 'Приносит индюшачьи яйца'),
(24, 'Свинья', 60000000, 50000, '300000', 44, 'Приносит поросят'),
(25, 'Голубь', 58000000, 38000, '220000', 45, 'Работает почтальоном'),
(26, 'Лошадь', 65000000, 60000, '320000', 45, 'Участвует в скачках'),
(27, 'Аист', 61000000, 40000, '230000', 46, 'Работает почтальоном'),
(28, 'Белка', 68000000, 65000, '340000', 46, 'Заготовляет орешки'),
(29, 'Чайка', 65000000, 42000, '240000', 47, 'Ловит рыбу'),
(30, 'Ёжик', 70000000, 70000, '360000', 47, 'Собирает яблоки'),
(31, 'Пеликан', 66000000, 44000, '250000', 48, 'Ловит рыбу'),
(32, 'Кенгуру', 75000000, 75000, '380000', 48, 'Приносит кенгурят'),
(33, 'Попугай', 67000000, 46000, '260000', 49, 'Разговаривает'),
(34, 'Кролик', 80000000, 80000, '400000', 49, 'Приносит крольчат'),
(35, 'Сова', 68000000, 50000, '270000', 50, 'Ловит грызунов'),
(36, 'Верблюд', 85000000, 85000, '420000', 50, 'Дает шерсть'),
(37, 'Медведь', 90000000, 90000, '440000', 52, 'Приносит медвежью шкуру'),
(38, 'Попугай экзотический', 95000000, 95000, '460000', 54, 'Приносит экзотические пера'),
(39, 'Пингвин', 100000000, 100000, '480000', 56, 'Приносит пух'),
(40, 'Черепаха', 110000000, 110000, '500000', 58, 'Приносит панцири'),
(41, 'Белый Тигр', 130000000, 130000, '550000', 60, 'Участвует в выставках');

DROP TABLE IF EXISTS `kolhoz_petground`;
CREATE TABLE IF NOT EXISTS `kolhoz_petground` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_pet` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_money` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `time_money2` int(11) DEFAULT '0',
  `time_rf` int(11) DEFAULT '0',
  `last_rf` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_plant`;
CREATE TABLE IF NOT EXISTS `kolhoz_plant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `money` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_plant` (`id`, `name`, `cena`, `rating`, `count`, `time`, `money`, `time_soil`, `level`) VALUES
(5, 'Укроп', 10, 30, 1, 2700, 12, 120, 1),
(6, 'Петрушка', 10, 40, 1, 2700, 13, 120, 1),
(7, 'Лук', 20, 20, 1, 6480, 27, 120, 2),
(8, 'Хрен', 20, 80, 1, 23520, 50, 120, 2),
(9, 'Мята', 30, 30, 1, 9360, 42, 120, 3),
(10, 'Редис', 30, 120, 1, 34920, 82, 120, 3),
(11, 'Капуста', 40, 40, 3, 12240, 58, 120, 4),
(12, 'Базилик', 40, 160, 3, 46320, 120, 120, 4),
(13, 'Морковь', 50, 50, 3, 15120, 74, 120, 5),
(14, 'Свекла', 50, 200, 3, 57720, 162, 120, 5),
(15, 'Щавель', 60, 60, 4, 18000, 92, 120, 6),
(16, 'Картофель', 60, 240, 4, 69120, 208, 120, 6),
(17, 'Горох', 70, 70, 4, 20880, 111, 120, 7),
(18, 'Перец', 70, 280, 4, 80520, 258, 120, 7),
(19, 'Томат', 80, 80, 6, 23760, 130, 120, 8),
(20, 'Сельдерей', 80, 320, 6, 93600, 312, 120, 8),
(21, 'Брокколи', 90, 90, 6, 26640, 150, 120, 9),
(22, 'Огурец', 90, 360, 6, 105600, 370, 120, 9),
(23, 'Кабачок', 100, 100, 8, 29520, 171, 180, 10),
(24, 'Клубника', 100, 400, 8, 115200, 432, 180, 10),
(25, 'Фасоль', 110, 110, 8, 32400, 193, 180, 11),
(26, 'Баклажан', 110, 440, 8, 126000, 498, 180, 11),
(27, 'Тыква', 120, 120, 6, 35280, 216, 180, 12),
(28, 'Арбуз', 120, 480, 6, 136800, 567, 180, 12),
(29, 'Чеснок', 130, 130, 10, 38160, 239, 180, 13),
(31, 'Спаржа', 130, 520, 10, 147600, 639, 180, 13),
(32, 'Кукуруза', 140, 140, 7, 38880, 263, 180, 14),
(33, 'Патиссон', 140, 560, 7, 162000, 716, 180, 14),
(34, 'Чили', 150, 150, 7, 43920, 288, 180, 15),
(35, 'Дыня', 150, 600, 7, 172800, 795, 180, 15),
(36, 'Ежевика', 160, 160, 13, 46800, 313, 180, 16),
(37, 'Яблоко', 160, 640, 13, 183600, 878, 180, 16),
(38, 'Крыжовник', 170, 170, 13, 49680, 339, 180, 17),
(39, 'Груша', 170, 680, 13, 194400, 965, 180, 17),
(40, 'Виноград', 180, 180, 14, 52560, 366, 180, 18),
(41, 'Бананы', 180, 720, 14, 205200, 1054, 180, 18),
(42, 'Малина', 190, 190, 14, 55440, 393, 180, 19),
(43, 'Грибы', 190, 760, 14, 216000, 1149, 180, 19),
(44, 'Вишня', 200, 200, 13, 58320, 422, 240, 20),
(45, 'Подсолнух', 200, 800, 13, 230400, 1243, 240, 20),
(46, 'Анютины Глазки', 210, 210, 18, 61200, 451, 240, 21),
(47, 'Гибискусы', 220, 880, 13, 252000, 1446, 240, 22),
(48, 'Ландыши', 230, 230, 17, 66960, 510, 240, 23),
(49, 'Колокольчики', 240, 960, 19, 273600, 1660, 240, 24),
(50, 'Тюльпаны', 250, 250, 17, 94320, 573, 240, 25),
(51, 'Лилии', 260, 1040, 22, 298800, 1888, 240, 26),
(52, 'Гвоздики', 270, 270, 22, 78480, 638, 240, 27),
(53, 'Ромашки', 280, 1120, 27, 320400, 2127, 240, 28),
(54, 'Маки', 290, 290, 27, 84240, 706, 240, 29),
(55, 'Розы', 300, 1200, 26, 342000, 2379, 300, 30),
(56, 'Арахис', 310, 310, 27, 90000, 776, 300, 31),
(57, 'Миндаль', 320, 1280, 27, 367200, 2643, 300, 32),
(58, 'Фундук', 330, 330, 27, 97200, 849, 300, 33),
(59, 'Кедровый орех', 340, 1360, 29, 388800, 2919, 300, 34),
(60, 'Кокос', 350, 350, 27, 100800, 924, 300, 35),
(61, 'Лимон', 500, 2000, 30, 435600, 2600, 300, 36),
(62, 'Смородина', 500, 1500, 30, 165600, 1125, 300, 37),
(63, 'Слива', 600, 2500, 30, 464400, 2700, 300, 37),
(64, 'Облепиха', 600, 2000, 30, 176400, 1000, 300, 38),
(65, 'Персик', 400, 3500, 30, 507600, 2800, 300, 38),
(66, 'Черника', 480, 2500, 30, 198000, 870, 300, 38),
(67, 'Абрикос', 39, 5000, 30, 554400, 2900, 300, 39),
(68, 'Брусника', 450, 3500, 30, 219600, 850, 300, 39),
(69, 'Апельсин', 460, 7000, 30, 615600, 3500, 1200, 40),
(70, 'Гранат', 470, 5000, 30, 248400, 950, 1200, 40),
(72, 'Финики', 510, 10000, 30, 835200, 3000, 1260, 41),
(73, 'Хурма', 520, 8000, 30, 338400, 2000, 1260, 42),
(74, 'Киви', 530, 15000, 30, 928800, 6000, 1320, 43),
(75, 'Манго', 540, 12000, 30, 399600, 3000, 1320, 44),
(76, 'Айва', 550, 25000, 30, 1044000, 10000, 1380, 45),
(77, 'Барбарис', 560, 15000, 30, 432000, 4000, 1380, 46),
(78, 'Ирис', 570, 28000, 30, 1080000, 11000, 1380, 46),
(79, 'Календула', 580, 18000, 30, 468000, 5000, 1440, 47),
(80, 'Крапива', 590, 31000, 30, 1116000, 12000, 1440, 47),
(81, 'Кувшинка', 600, 21000, 30, 504000, 6000, 1440, 48),
(82, 'Одуванчик', 610, 33000, 30, 1152000, 13000, 1440, 48),
(83, 'Подорожник', 620, 24000, 30, 540000, 7000, 1500, 49),
(84, 'Сирень', 630, 36000, 30, 1188000, 14000, 1500, 49),
(85, 'Василёк', 640, 27000, 30, 576000, 8000, 1500, 50),
(86, 'Женьшень', 650, 40000, 30, 1224000, 15000, 1500, 50);

DROP TABLE IF EXISTS `kolhoz_plant2`;
CREATE TABLE IF NOT EXISTS `kolhoz_plant2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `rubies` int(11) DEFAULT '0',
  `time_soil2` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=318 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_plant2` (`id`, `name`, `cena`, `rating`, `count`, `time`, `rubies`, `time_soil2`, `level`) VALUES
(247, 'Мятная настойка', 60, 2450, 1, 8000, 60, 0, 16),
(248, 'Грибы маринованные', 62, 2550, 1, 8300, 62, 0, 16),
(249, 'Арбузы маринованные', 64, 2650, 1, 8600, 64, 0, 16),
(250, 'Мусс ягодный', 66, 2750, 1, 8900, 66, 0, 16),
(251, 'Чесночная настойка', 68, 2850, 1, 9200, 68, 0, 18),
(252, 'Варенье из крыжовника', 70, 2950, 1, 9500, 71, 0, 18),
(253, 'Настойка любительская ', 72, 3050, 1, 9800, 74, 0, 18),
(254, 'Варенье из винограда ', 74, 3150, 1, 10100, 77, 0, 19),
(255, 'Томатное пюре ', 76, 3250, 1, 10400, 77, 0, 21),
(256, 'Брокколи маринованные', 73, 9999, 1, 642000, 78, 0, 21),
(257, 'Яблоки с хреном ', 80, 3450, 1, 11000, 82, 0, 22),
(258, 'Томаты в розовом рассоле', 82, 3999, 1, 11300, 83, 0, 22),
(259, 'Крестьянский салат', 84, 10999, 1, 11600, 87, 0, 23),
(260, 'Огурцы маринованные', 86, 3750, 1, 11900, 87, 0, 23),
(261, 'Клубничная наливка ', 88, 3850, 1, 12200, 90, 0, 23),
(262, 'Дедов спотыкач', 90, 3950, 1, 12500, 91, 0, 23),
(263, 'Джем из дыни', 92, 4050, 1, 12800, 94, 0, 23),
(264, 'Банановое варенье', 94, 4150, 1, 13100, 100, 0, 25),
(265, 'Клубничный компот', 96, 4250, 1, 13400, 98, 0, 25),
(266, 'Грушевый компот', 98, 4350, 1, 13700, 103, 0, 25),
(267, 'Варенье из груши ', 60, 4450, 1, 1400000, 200, 0, 28),
(268, 'Груши в собственном соку', 102, 4550, 1, 14300, 104, 0, 28),
(269, 'Варенье из арбузов', 104, 4650, 1, 14600, 106, 0, 28),
(270, 'Ромашковая настойка', 106, 4750, 1, 14900, 110, 0, 32),
(271, 'Квашеные томаты', 108, 4850, 1, 15200, 111, 0, 32),
(272, 'Варенье из роз', 110, 4950, 1, 15500, 112, 0, 32),
(273, 'Желе клубничное', 112, 5050, 1, 15800, 115, 0, 33),
(274, 'Редис в сладко-кислой заливке', 114, 5150, 1, 16100, 119, 0, 33),
(275, 'Розовая настойка ', 116, 5250, 1, 16400, 117, 0, 33),
(276, 'Желейный салат', 118, 5350, 1, 16700, 120, 0, 34),
(277, 'Кукуруза в маринаде', 120, 5450, 1, 17000, 125, 0, 35),
(278, 'Ореховая настойка', 122, 5550, 1, 17300, 127, 0, 35),
(279, 'Капусты с травами', 124, 5650, 1, 17600, 130, 0, 35),
(280, 'Пикантные кабачки', 126, 5750, 1, 17900, 129, 0, 35),
(281, 'Варенье из моркови ', 128, 5850, 1, 18200, 131, 0, 36),
(282, 'Ликёр из гвоздик', 130, 5950, 1, 18500, 135, 0, 36),
(283, 'Салат с фасолью', 132, 6050, 1, 18800, 136, 0, 39),
(284, 'Арбузно-вишнёвый напиток ', 134, 6150, 1, 19100, 138, 0, 39),
(285, 'Вишнёвый ликёр ', 136, 6250, 1, 29400, 147, 0, 39),
(286, 'Тыквенное пюре', 138, 6350, 1, 197000, 150, 0, 40),
(287, 'Маринованная капуста ', 140, 6450, 1, 20000, 155, 0, 40),
(288, 'Ликёр из ежевики', 142, 6550, 1, 20300, 149, 0, 42),
(289, 'Кокосовый джем', 144, 6650, 1, 20600, 151, 0, 42),
(290, 'Варенье из смородины', 146, 6750, 1, 30900, 155, 0, 42),
(291, 'Настойка от Михалыча', 148, 6850, 1, 31200, 160, 0, 42),
(292, 'Салат из тыквы и яблок', 150, 6950, 1, 2150000, 190, 0, 44),
(293, 'Морс облепиховый', 152, 70500, 1, 3180000, 224, 0, 44),
(294, 'Цукаты из слив ', 154, 71500, 1, 22100, 170, 0, 46),
(295, 'Сливянка ', 156, 7250, 1, 22400, 171, 0, 46),
(296, 'Черничная наливка ', 158, 7350, 1, 227000, 181, 0, 46),
(297, 'Повидло персиковое', 160, 7450, 1, 33000, 180, 0, 46),
(298, 'Ликёр из персиков', 162, 700550, 1, 23300, 139, 0, 47),
(299, 'Варенье из брусники ', 164, 7650, 1, 23600, 176, 0, 47),
(300, 'Абрикосовый ликёр ', 166, 7750, 1, 23900, 180, 0, 47),
(301, 'Повидло бруснично- черничное', 168, 7850, 1, 24200, 181, 0, 49),
(302, 'Настойка фруктовая ', 170, 7950, 1, 745000, 200, 0, 49),
(303, 'Ликер на гранатах ', 172, 8050, 1, 24800, 180, 0, 49),
(304, 'Апельсиновое варенье ', 174, 900150, 1, 75100, 174, 0, 49),
(305, 'Салат Тропикана ', 176, 8250, 1, 25400, 190, 0, 50),
(306, 'Коктейль Мартини оранж', 178, 8350, 1, 25700, 190, 0, 50),
(307, 'Салат Черная роза', 180, 8450, 1, 26000, 200, 0, 50),
(308, 'Желе из хурмы', 182, 8550, 1, 26300, 196, 0, 50),
(309, 'Щербет из хурмы', 184, 8650000, 1, 266000, 190, 0, 50),
(310, 'Парфе из киви', 186, 8750, 1, 26900, 275, 0, 51),
(311, 'Джем из киви', 188, 8850, 1, 27200, 278, 0, 51),
(312, 'Зелёненькое варенье', 190, 8950, 1, 27500, 281, 0, 51),
(313, 'Мартини из киви', 192, 9050, 1, 27800, 284, 0, 51),
(314, 'Крюшон из дыни', 194, 9150, 1, 28100, 287, 0, 53),
(315, 'Салат из манго и дыни', 196, 9250, 1, 28400, 290, 0, 53),
(316, 'Варенье из айвы', 198, 9350, 1, 28700, 293, 0, 54),
(317, 'Повидло из перца по-венгерски', 200, 9450, 1, 29000, 296, 0, 55);

DROP TABLE IF EXISTS `kolhoz_polka2`;
CREATE TABLE IF NOT EXISTS `kolhoz_polka2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant2` int(11) DEFAULT '0',
  `soil2` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water2` int(11) DEFAULT '0',
  `time_soil2` int(11) DEFAULT '0',
  `cultivator2` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_pond`;
CREATE TABLE IF NOT EXISTS `kolhoz_pond` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT '0',
  `soil` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `time_water` int(11) DEFAULT '0',
  `cultivator` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_soil`;
CREATE TABLE IF NOT EXISTS `kolhoz_soil` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_soil` (`id`, `name`, `cena`, `rating`, `time`, `level`) VALUES
(1, 'Торф', 1, 5, 1800, 1),
(2, 'Компост', 50, 10, 7200, 7),
(3, 'Азот', 200, 20, 21600, 15),
(4, 'Сульфат', 500, 50, 32400, 20),
(5, 'Суперфосфат', 2000, 200, 32400, 25),
(6, 'Коровяк', 21000, 500, 86400, 15),
(7, 'Биоплант', 30000, 1500, 172800, 40),
(8, 'Магнезит', 10000, 350, 54000, 35);


DROP TABLE IF EXISTS `kolhoz_tree`;
CREATE TABLE IF NOT EXISTS `kolhoz_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `money` int(11) DEFAULT '0',
  `rating` varchar(1000) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `work` varchar(1000) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_tree` (`id`, `name`, `cena`, `money`, `rating`, `level`, `work`) VALUES
(37, 'Абрикос', 1000, 10000, '25000', 20, 'Приносит абрикосы'),
(38, 'Груша', 21000, 5000, '30000', 21, 'Приносит груши'),
(39, 'Яблоня', 25000, 10000, '40000', 25, 'Приносит яблоки'),
(40, 'Лимон', 100, 700, '50000', 23, 'Приносит плоды лимона'),
(41, 'Гранат', 40000, 700, '60000', 26, 'Приносит плоды граната'),
(42, 'Черешня', 50000, 1055, '65000', 30, 'Приносит ягоды черешни'),
(43, 'Нектарин', 30000, 6000, '70000', 33, 'Приносит нектаринки');

DROP TABLE IF EXISTS `kolhoz_treeground`;
CREATE TABLE IF NOT EXISTS `kolhoz_treeground` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_pet` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_money` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `time_money2` int(11) DEFAULT '0',
  `time_rf` int(11) DEFAULT '0',
  `last_rf` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `kolhoz_user`;
CREATE TABLE IF NOT EXISTS `kolhoz_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idus` int(11) NOT NULL,
  `nick` varchar(16) DEFAULT NULL,
  `dostup` enum('0','1') DEFAULT '0',
  `status` enum('0','1','2','3') DEFAULT '0',
  `ip` varchar(1024) DEFAULT NULL,
  `rating` bigint(255) DEFAULT '0',
  `money` bigint(255) DEFAULT '0',
  `rubies` bigint(255) DEFAULT '0',
  `almaz` bigint(255) DEFAULT '0',  
  `level` int(11) DEFAULT '1',
  `dostig` int(11) DEFAULT '0',
  `tehnika` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `last_plant` int(11) DEFAULT '0',
  `last_soil` int(11) DEFAULT '0',
  `conveyor` int(11) DEFAULT '0',
  `cultivator` int(11) DEFAULT '0',
  `cultivator_all2` int(10) DEFAULT NULL,
  `fooder` int(11) DEFAULT '0',
  `flowerbed` int(11) DEFAULT '0',
  `harvester` int(11) DEFAULT '0',
  `hydropinics_time` int(11) DEFAULT NULL,
  `hydropinics_type` int(11) DEFAULT NULL,
  `irregate` int(11) DEFAULT '0',
  `scarecrow_time` int(11) DEFAULT '0',
  `scarecrow_day` int(11) DEFAULT '0',
  `seeder` int(11) DEFAULT '0',
  `soiler` int(11) DEFAULT '0',
  `time_obmen` int(11) DEFAULT '0',
  `time_start` int(11) DEFAULT '0',
  `time_shmel` int(11) DEFAULT '0',
  `time_yastreb` int(11) DEFAULT '0',
  `time_drakon` int(11) DEFAULT '0',
  `sadovod` int(11) DEFAULT '0',
  `vodoley` int(11) DEFAULT '0',
  `agronom` int(11) DEFAULT '0',
  `botanik` int(11) DEFAULT '0',
  `kormer` int(11) DEFAULT '0',
  `pugach` int(11) DEFAULT '0',
  `tdlevel` int(11) DEFAULT '0',
  `sdlevel` int(11) DEFAULT '0',
  `vdlevel` int(11) DEFAULT '0',
  `gdlevel` int(11) DEFAULT '0',
  `bdlevel` int(11) DEFAULT '0',
  `pdlevel` int(11) DEFAULT '0',
  `ppdlevel` int(11) DEFAULT '0',
  `kdlevel` int(11) DEFAULT '0',
  `agdlevel` int(11) DEFAULT '0',
  `pgdlevel` int(11) DEFAULT '0',
  `time_cp` int(11) DEFAULT '0',
  `count_cp` int(11) DEFAULT '0',
  `date_last` int(11) DEFAULT '0',
  `umoney` bigint(255) DEFAULT '0',
  `goscomp` enum('0','1') DEFAULT '0',
  `goscomp_plant` int(11) DEFAULT '0',
  `goscomp_time` int(11) DEFAULT NULL,
  `expdouble` enum('Mon','Tue','Wed','Thu','Fri','Sat','Sun') DEFAULT NULL,
  `pol` enum('0','1') DEFAULT '1',
  `time_support` int(11) DEFAULT NULL,
  `last_plant2` int(11) NOT NULL,
  `harvester2` int(11) NOT NULL,
  `last_soil2` int(11) NOT NULL,
  `cultivator2` int(11) NOT NULL,
  `pkey` int(11) NOT NULL,
  `ank_mails` set('1','2','3') DEFAULT '1',
  `gorod_brak` varchar(32) NOT NULL,
  `conveyor2` int(11) DEFAULT '0',
  `seeder2` int(11) DEFAULT '0',
  `fooder2` int(11) DEFAULT '0',
  `status_icon` int(11) NOT NULL,
  `status_text` varchar(150) NOT NULL,
  `avtor` varchar(32) NOT NULL,
  `cook_mas` int(11) DEFAULT '0',
  `conveyor3` int(11) DEFAULT '0',
  `seeder3` int(11) DEFAULT '0',
  `catchfish` int(11) DEFAULT '0',
  `count_fp` int(11) NOT NULL DEFAULT '0',
  `last_fish` int(11) DEFAULT '0',
  `last_korm` int(11) DEFAULT '0',
  `time_fp` int(11) DEFAULT '0',
  `id_fish` int(11) DEFAULT '0',
  `sponder` int(11) DEFAULT '0',
  `inkubator` int(11) DEFAULT '0',
  `iconka` int(11) DEFAULT '0',
  `ikonka` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `mslevel` int(11) DEFAULT '0',
  `master` int(11) DEFAULT '0',
  `brak` varchar(30) NOT NULL,
  `verh` enum('1','0','','') NOT NULL DEFAULT '0',
  `polosa` enum('1','0','','') NOT NULL DEFAULT '0',
  `komp` enum('0','1','','') NOT NULL DEFAULT '1',
  `pda` enum('0','1','','') NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idus` (`idus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_warehouse`;
CREATE TABLE IF NOT EXISTS `kolhoz_warehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `arena` enum('0','1') DEFAULT '0',
  `fish` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `kolhoz_works`;
CREATE TABLE IF NOT EXISTS `kolhoz_works` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `work` varchar(1024) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `master` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `money` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `kolhoz_works` (`id`, `name`, `work`, `cena`, `rating`, `master`, `count`, `time`, `money`, `time_soil`, `level`) VALUES
(1, 'Починка крана', 'Тут у Кузьмича кран сломался, говорит, что заплатит за починку. Интересно, откуда у него деньги?', 600, 100, 1, 22, 1980, 240000, 0, 15),
(2, 'Дрова', 'Бабе Любе нужны дрова для бани. Поможешь?', 1000, 1000, 1, 240000, 6000, 320000, 0, 16),
(3, 'Конура', 'Бедный пес Барбос совсем без дома! Ты обязан помочь ему!', 1500, 2500, 1, 32000, 10020, 500000, 60, 17),
(5, 'Продажа топоров', 'Займись бизнесом, тут мужики в лес собрались! Мож удасться продать пару топоров. ', 2100, 3100, 2, 0, 11400, 720000, 0, 19),
(6, 'Починка ЗИЛа', 'Тут у Председателя сломался ЗИЛ. У него денег немало, заплатит.', 4000, 5000, 2, 0, 14400, 850000, 0, 21),
(7, 'Трава', 'У тебя на дворе трава заросла! Того гляди, весь дом накроет. Коси ее!', 7500, 10000, 3, 0, 17700, 1000000, 0, 25),
(8, 'Замена', 'Ветеринара бык на рога взял! Надо заменить его(ветеринара:-D) и сделать укол коровам!', 5000, 45000, 1, 0, 19800, 1316580, 0, 30),
(9, 'Женское дело', 'Мыть посуду - женское дело? Кто сказал? Не забудь резиновые перчатки.', 5600, 76312, 1, 0, 30000, 1730200, 0, 31),
(10, 'Очистить загоны', 'Твоих загонах полно навоза! Скорей берись за дело, иначе звери сбегут, а это не есть хорошо.', 61000, 100600, 2, 1, 36000, 2000000, 0, 32);

DROP TABLE IF EXISTS `kolhoz_zags`;
CREATE TABLE IF NOT EXISTS `kolhoz_zags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` bigint(20) NOT NULL,
  `on` varchar(32) NOT NULL,
  `ona` varchar(32) NOT NULL,
  `onyes` varchar(3) NOT NULL,
  `onayes` varchar(3) NOT NULL,
  `avtor` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
