<?php

class KfileStorage {
    
    private $dir;
    
    public function __construct($dir) {
        if (!is_dir($dir)) {
            throw new RuntimeException('Directory ' . realpath($dir) . ' not found');
        }
        
        $this->dir = $dir;
    }
    
    public function add($file) {
        if (!is_array($file)) {
            $data = $file->data();
            $md5 = $data['md5'];
            $dir = $this->createDir($md5);
            $item = $dir . DIRECTORY_SEPARATOR . $md5;
            file_put_contents($item, file_get_contents($data['path']));
            unlink($data['path']);
            file_put_contents($item . '.json', $json = json_encode(array('size' => $data['size'], 'ext' => $data['ext'])));
        } else {
            array_map(array($this, 'add'), $file);
        }
    }
    
    public function map() {
        $files = array();
        foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($this->dir), RecursiveIteratorIterator::CHILD_FIRST) as $fullFileName => $SplFileObject) {
            if ($SplFileObject->isFile()) {
                $files[basename($fullFileName)] = $SplFileObject->getRealPath();
            }
        }
        
        return $files;
    }
    
    public function createDir($md5) {
        $first = substr($md5, 0, 2);
        $second = substr($md5, 2, 2);
        $dir = $this->dir . DIRECTORY_SEPARATOR . $first . DIRECTORY_SEPARATOR . $second;
        if (!is_dir($dir)) {
            mkdir($dir, 0750, true);
        }
        
        return $dir;
    }
}