# DumpBaseYandex.sh
# The screenplay was written by Sitego
# Скрипт бекапа баз данных с отправкой на Яндекс.Диск
# Скрипт написан для двух баз данных - БЛОК №1 и БЛОК №2
# Можно добавлять эти блоки в неограниченном количестве, при этом не забываем добавлять строки в самом низу для отправки баз данных на Яндекс.Диск

# Основные настройки
DBSERVER="localhost" # Сервер MySQL
USER="UserName" # Пользователь MySQL
PASS="password" # Пароль MySQL
BACKUPPATH="/home/admin/backmysql/" # Путь к папке для бекапов БД
WEBDAVURL="https://webdav.yandex.ru/Backups/mysql/" # Путь к папке на Яндекс.Диске для бекапов MySQL (папка должна существовать)
WEBDAVUSER="webmaster@yandex.ru" # Логин на Яндекс
WEBDAVPASS="password" # Пароль на Яндекс

# Удаляем старые бекапы если есть
rm ${BACKUPPATH}*.gz -r  2> /dev/null

########################## БЛОК №1 #############################
# Первая база MySQL
DATABASE="site1" # Имя базы
FILE="site1.sql" # Имя файла для сохранения дампа

# выполняем дамп базы
mysqldump --opt --user=${USER} --password=${PASS} ${DATABASE} > ${BACKUPPATH}${FILE}

# трамбуем дамп базы MySQL в gz архив
gzip ${BACKUPPATH}${FILE}

########################## БЛОК №2 #############################
# Вторая база MySQL
DATABASE="site2" # Имя базы
FILE="site2.sql" # Имя файла для сохранения дампа

# выполняем дамп базы
mysqldump --opt --user=${USER} --password=${PASS} ${DATABASE} > ${BACKUPPATH}${FILE}

# трамбуем дамп базы MySQL в gz архив
gzip ${BACKUPPATH}${FILE}

############# Отправляем бекапы БД на Яндекс.Диск ####################
curl --user $WEBDAVUSER:$WEBDAVPASS -T ${BACKUPPATH}site1.sql.gz $WEBDAVURL >/dev/null 2>&1 # Первый бекап - пошёл
curl --user $WEBDAVUSER:$WEBDAVPASS -T ${BACKUPPATH}site2.sql.gz $WEBDAVURL >/dev/null 2>&1 # Второй бекап - пошёл