<?php

/**
 * @package     Chat for JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2010-2017 k_2
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/profile/?user=6251
 */

define('INSTALL', 1);

define('_IN_JOHNCMS', 1);

define('VERSION', '7.0.0'); // Инсталлируемая версия

define('VERSION_CMS', '6.2.1'); // Версия CMS

// Служебные переменные
$rootpath = '../../';
$install = false;
$delete = false;
require('../../incfiles/core.php');

/*
-----------------------------------------------------------------
Проверка, проинсталлирован чат, или нет
-----------------------------------------------------------------
*/
$array = array('chat_bot', 'chat_vop', 'chat_rooms', 'chat_users', 'chat_settings');
foreach ($array as $val) {
    $table = mysql_query("SELECT * FROM `" . $val . "`");
    if ($table == true) {
        $delete = true;
    } else {
        $install = true;
    }
}

/*
-----------------------------------------------------------------
Получаем список доступных языков
-----------------------------------------------------------------
*/
$i = 1;
foreach (glob('languages/*.ini') as $file) {
    $ini = parse_ini_file($file, true);
    $lng_key[$ini['description']['iso']] = $i;
    $lng_set[$i] = $ini['description'];
    $lng_phrases[$i] = $ini['install'];
    unset($ini);
    ++$i;
}

// Используем  язык системы
$lng_id = $lng_key[core::$lng_iso];
$chat_lng = $lng_phrases[$lng_id];

if (!count($chat_lng))
    die('ERROR: there are no languages for installation');

/*
-----------------------------------------------------------------
Получаем список доступных ботов и их данные
-----------------------------------------------------------------
*/
$i = 1;
foreach (glob('bot/*.txt') as $file) {
    $ini = file($file);
    for ($b = 0; $b < 34; ++$b) {
        $str = explode("=", $ini[$b]);
        $str2 = explode("'", $str[1]);
        $bot[$i][$b] = $str2[1];
    }
    unset($ini);
    ++$i;
}

/*
-----------------------------------------------------------------
HTML Пролог
-----------------------------------------------------------------
*/
ob_start();

echo '<!DOCTYPE html>' . "\n" .
    '<html lang="' . core::$lng_iso . '">' . "\n" .
    '<head>' . "\n" .
    '<meta charset="utf-8">' . "\n" .
    '<title>Chat k_2 ' . VERSION . ' for JohnCMS ' . VERSION_CMS . '</title>' . "\n" .
    '<style type="text/css">' .
    'body {font-family: Arial, Helvetica, sans-serif; font-size: small; color: #000000; background-color: #FFFFFF}' .
    'h1{margin: 0; padding: 0; padding-bottom: 4px;}' .
    'h2{margin: 0; padding: 0; padding-bottom: 2px;}' .
    'h3{margin: 0; padding: 0; padding-bottom: 2px;}' .
    'ul{margin:0; padding-left:20px; }' .
    'a{margin-top:5px; margin-bottom:5px; display: inline-block; color:#0000EE;}' .
    'li{padding-bottom: 6px; }' .
    '.red{color: #FF0000;}' .
    '.green{color: #009933;}' .
    '.blue{color: #0000EE;}' .
    '.gray{color: #888888;}' .
    '.small{font-size: x-small}' .
    '</style>' .
    '</head>' . "\n" .
    '<body>' . "\n" .
    '<h1 class="green">Chat k_2 ' . VERSION . '</h1>' .
    '<h2 class="gray">for JohnCMS ' . VERSION_CMS . '</h2><hr />';

/*
-----------------------------------------------------------------
Переключаем режимы работы
-----------------------------------------------------------------
*/
$act = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : '';
$mod = isset($_REQUEST['mod']) ? trim($_REQUEST['mod']) : '';
$actions = array(
    'install',
    'bot',
    'delete'
);
if (in_array($act, $actions) && file_exists('includes/' . $act . '.php')) {
    require_once('includes/' . $act . '.php');
} else {
    /*
    -----------------------------------------------------------------
    Главное меню инсталлятора
    -----------------------------------------------------------------
    */
    echo '<form action="index.php" method="post">' .
        '<table>' .
        '<tr>' .
        '<td valign="top"><input type="radio" name="act" value="install" id="install" ' . ($install ? 'checked="checked"' : 'disabled="disabled"') . '/></td>' .
        '<td style="padding-bottom:6px"><h3 class="' . ($install ? 'blue' : 'gray') . '"><label for="install">' . $chat_lng['install'] . '</label></h3><small>' . ($install ? $chat_lng['install_no'] : '<span class="gray">' . $chat_lng['install_yes'] . '</span>') . '</small></td>' .
        '</tr>' .
        '<tr>' .
        '<td valign="top"><input type="radio" name="act" value="bot" id="bot" ' . (!$install ? 'checked="checked"' : 'disabled="disabled"') . '/></td>' .
        '<td style="padding-bottom:6px"><h3 class="' . (!$install ? 'blue' : 'gray') . '"><label for="bot">' . $chat_lng['install_bot'] . '</label></h3><small>' . (!$install ? $chat_lng['install_bot_yes'] : '<span class="gray">' . $chat_lng['install_bot_no'] . '</span>') . '</small></td>' .
        '</tr>' .
        '<tr>' .
        '<td valign="top"><input type="radio" name="act" value="delete" id="delete" ' . ($delete ? '' : 'disabled="disabled"') . '/></td>' .
        '<td style="padding-bottom:6px"><h3 class="' . ($delete ? 'blue' : 'gray') . '"><label for="delete">' . $chat_lng['install_table_and_lng'] . '</label></h3><small>' . ($delete ? $chat_lng['install_table_and_lng_yes'] : '<span class="gray">' . $chat_lng['install_table_and_lng_no'] . '</span>') . '</small></td>' .
        '</tr>' .
        '<tr><td>&#160;</td><td><input type="submit" name="submit" value="' . $chat_lng['continue'] . '" /></td></tr>' .
        '</table>' .
        '</form><hr />' .
        '<a href="../../index.php">' . $chat_lng['on_site'] . '</a><br /><a href="../menu.php">' . $chat_lng['admin_panel'] . '</a>';
}
echo '<hr /><p>' .
    '&copy;&#160;Powered by <a href="http://johncms.com">JohnCMS</a></body></html>' .
    '</p>';