<?php


defined('_IN_JOHNADM') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

$config = $container->get('config')['johncms'];

// Проверяем права доступа
if ($systemUser->id !== '1') {
    header('Location: ../?err');
    exit;
}
echo '<div class="mainblok">';
echo '<div class="phdr"><a href="index.php"><b>' . _t('Admin Panel') . '</b></a> | Firewall</div>';

if (isset($_POST['submit'])) {
    $config['F_push'] = isset($_POST['a']) ? intval($_POST['a']) : 0;
    $config['F_pr_unset'] = isset($_POST['b']) ? intval($_POST['b']) : 0;
    $config['F_rangeip'] = isset($_POST['c']) ? intval($_POST['c']) : 0;
    $config['F_rangeip_spam'] = isset($_POST['d']) ? intval($_POST['d']) : 0;
    $config['F_pr_url'] = isset($_POST['e']) ? intval($_POST['e']) : 0;
    $config['F_pr_request'] = isset($_POST['f']) ? intval($_POST['f']) : 0;
    $config['F_pr_santy'] = isset($_POST['g']) ? intval($_POST['g']) : 0;
    $config['F_pr_bots'] = isset($_POST['h']) ? intval($_POST['h']) : 0;
    $config['F_pr_method'] = isset($_POST['i']) ? intval($_POST['i']) : 0;
    $config['F_pr_dos'] = isset($_POST['j']) ? intval($_POST['j']) : 0;
    $config['F_pr_unionsql'] = isset($_POST['k']) ? intval($_POST['k']) : 0;
    $config['F_pr_clickattack'] = isset($_POST['l']) ? intval($_POST['l']) : 0;
    $config['F_pr_xss'] = isset($_POST['m']) ? intval($_POST['m']) : 0;
    $config['F_pr_cookies'] = isset($_POST['n']) ? intval($_POST['n']) : 0;
    $config['F_pr_post'] = isset($_POST['o']) ? intval($_POST['o']) : 0;
    $config['F_pr_get'] = isset($_POST['p']) ? intval($_POST['p']) : 0;
    $config['F_pr_serverovh'] = isset($_POST['q']) ? intval($_POST['q']) : 0;
    $config['F_pr_serverkimsufi'] = isset($_POST['r']) ? intval($_POST['r']) : 0;
    $config['F_pr_serverdedibox'] = isset($_POST['s']) ? intval($_POST['s']) : 0;
    $config['F_pr_serverdigicube'] = isset($_POST['t']) ? intval($_POST['t']) : 0;
    $config['F_pr_ovhbyip'] = isset($_POST['u']) ? intval($_POST['u']) : 0;
    $config['F_pr_kimsufibyip'] = isset($_POST['v']) ? intval($_POST['v']) : 0;
    $config['F_pr_dediboxbyip'] = isset($_POST['w']) ? intval($_POST['w']) : 0;
    $config['F_pr_digicubebyip'] = isset($_POST['x']) ? intval($_POST['x']) : 0;
    $configFile = "<?php\n\n" . 'return ' . var_export(['johncms' => $config], true) . ";\n";

    if (!file_put_contents(ROOT_PATH . 'system/config/system.local.php', $configFile)) {
        echo 'ERROR: Can not write system.local.php</body></html>';
        exit;
    }

    echo '<div class="rmenu">' . _t('Settings are saved successfully') . '</div>';

    if (function_exists('opcache_reset')) {
        opcache_reset();
    }
}

$color = ['red', 'green'];
echo '<form method="post" action="index.php?act=firewall">';

echo '<div class="menu">';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_push']] . '.gif" width="16" height="16" class="left"/>&#160;Push Email</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="a" ' . ($config['F_push'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="a" ' . (!$config['F_push'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_unset']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Unset</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="b" ' . ($config['F_pr_unset'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="b" ' . (!$config['F_pr_unset'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_rangeip']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Range IP</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="c" ' . ($config['F_rangeip'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="c" ' . (!$config['F_rangeip'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_rangeip_spam']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Range IP Spam</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="d" ' . ($config['F_rangeip_spam'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="d" ' . (!$config['F_rangeip_spam'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_url']] . '.gif" width="16" height="16" class="left"/>&#160;Protect URL</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="e" ' . ($config['F_pr_url'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="e" ' . (!$config['F_pr_url'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_request']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Request Server</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="f" ' . ($config['F_pr_request'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="f" ' . (!$config['F_pr_request'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_santy']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Santy</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="g" ' . ($config['F_pr_santy'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="g" ' . (!$config['F_pr_santy'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_bots']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Bots</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="h" ' . ($config['F_pr_bots'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="h" ' . (!$config['F_pr_bots'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_method']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Request Method</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="i" ' . ($config['F_pr_method'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="i" ' . (!$config['F_pr_method'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_dos']] . '.gif" width="16" height="16" class="left"/>&#160;Protect DOS</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="j" ' . ($config['F_pr_dos'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="j" ' . (!$config['F_pr_dos'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_unionsql']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Union SQL</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="k" ' . ($config['F_pr_unionsql'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="k" ' . (!$config['F_pr_unionsql'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_clickattack']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Click Attack</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="l" ' . ($config['F_pr_clickattack'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="l" ' . (!$config['F_pr_clickattack'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_xss']] . '.gif" width="16" height="16" class="left"/>&#160;Protect XSS</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="m" ' . ($config['F_pr_xss'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="m" ' . (!$config['F_pr_xss'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_cookies']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Cookies</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="n" ' . ($config['F_pr_cookies'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="n" ' . (!$config['F_pr_cookies'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_post']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Post</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="o" ' . ($config['F_pr_post'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="o" ' . (!$config['F_pr_post'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_get']] . '.gif" width="16" height="16" class="left"/>&#160;Protect GET</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="p" ' . ($config['F_pr_get'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="p" ' . (!$config['F_pr_get'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';


echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_serverovh']] . '.gif" width="16" height="16" class="left"/>&#160;Protect OVH Server</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="q" ' . ($config['F_pr_serverovh'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="q" ' . (!$config['F_pr_serverovh'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_serverkimsufi']] . '.gif" width="16" height="16" class="left"/>&#160;Protect server Kimsufi</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="r" ' . ($config['F_pr_serverkimsufi'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="r" ' . (!$config['F_pr_serverkimsufi'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_serverdedibox']] . '.gif" width="16" height="16" class="left"/>&#160;Protect server dedibox</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="s" ' . ($config['F_pr_serverdedibox'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="s" ' . (!$config['F_pr_serverdedibox'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_serverdigicube']] . '.gif" width="16" height="16" class="left"/>&#160;Protect server digicube</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="t" ' . ($config['F_pr_serverdigicube'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="t" ' . (!$config['F_pr_serverdigicube'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_ovhbyip']] . '.gif" width="16" height="16" class="left"/>&#160;Protect ovh by IP</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="u" ' . ($config['F_pr_ovhbyip'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="u" ' . (!$config['F_pr_ovhbyip'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_kimsufibyip']] . '.gif" width="16" height="16" class="left"/>&#160;Protect Kimsufi By IP</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="v" ' . ($config['F_pr_kimsufibyip'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="v" ' . (!$config['F_pr_kimsufibyip'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_dediboxbyip']] . '.gif" width="16" height="16" class="left"/>&#160;Protect dedebox by IP</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="w" ' . ($config['F_pr_dediboxbyip'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="w" ' . (!$config['F_pr_dediboxbyip'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '<p>' .
    '<h3><img src="../images/' . $color[$config['F_pr_digicubebyip']] . '.gif" width="16" height="16" class="left"/>&#160;Protect digicube by IP</h3>' .
    '<div style="font-size: x-small">' .
    '<input type="radio" value="1" name="x" ' . ($config['F_pr_digicubebyip'] == 1 ? 'checked="checked"' : '') . '/>&#160;ON<br>' .
    '<input type="radio" value="0" name="x" ' . (!$config['F_pr_digicubebyip'] ? 'checked="checked"' : '') . '/>&#160;OFF</div></p>';

echo '</div>';

echo '<div class="phdr"><small>' . _t('Administrators always have access to all closed modules and comments') . '</small></div>' .
    '<div class="topmenu">' .
    '<p><input type="submit" name="submit" id="button" value="' . _t('Save') . '" /></p>' .
    '<p><a href="index.php">' . _t('Admin Panel') . '</a></p></div></form>';
echo '</div>';