<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');



$act = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : '';
$headmod = isset($headmod) ? $headmod : '';
$textl = isset($textl) ? $textl : $config['copyright'];
$keywords = isset($keywords) ? htmlspecialchars($keywords) : $config->meta_key;
$descriptions = isset($descriptions) ? htmlspecialchars($descriptions) : $config->meta_desc;

echo '<!DOCTYPE html>';

if ($config['LoadPage'] == '3') {
   echo '<html class="load-page"  lang="' . $config->lng . '">';
} else {
   echo '<html lang="' . $config->lng . '">';
}

echo '<head>' .
    "\n" . '<meta charset="utf-8">' .
    "\n" . '<meta http-equiv="X-UA-Compatible" content="IE=edge">' .
    "\n" . '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes">' .
    "\n" . '<meta name="HandheldFriendly" content="true">' .
    "\n" . '<meta name="MobileOptimized" content="width">' .
    "\n" . '<meta content="yes" name="apple-mobile-web-app-capable">' .
    "\n" . '<meta name="Generator" content="JohnCMS, http://johncms.com">' .
    "\n" . '<meta name="keywords" content="' . $keywords . '">' .
    "\n" . '<meta name="description" content="' . $descriptions . '">' .
    "\n" . '<link rel="stylesheet" href="' . $config->homeurl . '/themes/' . $tools->getSkins() . '/style.css">' .
    "\n" . '<link rel="shortcut icon" href="' . $config->homeurl . '/favicon.ico">' .
    "\n" . '<link rel="alternate" type="application/rss+xml" title="RSS | ' . _t('Site News', 'system') . '" href="' . $config->homeurl . '/rss/rss.php">' .
    "\n" . '<title>' . $textl . '</title>' .
    "\n" . '</head>';
if ($config['LoadPage'] == '4') {
   echo '<body onload="myFunctionSlow()" style="margin:0;">';
   echo '<div id="loader-slow"></div><div style="display:none;" id="myDiv-slow" class="animate-bottom-slow">';
} else {
  echo '<body>';
}


// Рекламный модуль
$cms_ads = [];

if (!isset($_GET['err']) && $act != '404' && $headmod != 'admin') {
    $view = $systemUser->id ? 2 : 1;
    $layout = ($headmod == 'mainpage' && !$act) ? 1 : 2;
    $req = $db->query("SELECT * FROM `cms_ads` WHERE `to` = '0' AND (`layout` = '$layout' or `layout` = '0') AND (`view` = '$view' or `view` = '0') ORDER BY  `mesto` ASC");

    if ($req->rowCount()) {
        while ($res = $req->fetch()) {
            $name = explode("|", $res['name']);
            $name = htmlentities($name[mt_rand(0, (count($name) - 1))], ENT_QUOTES, 'UTF-8');

            if (!empty($res['color'])) {
                $name = '<span style="color:#' . $res['color'] . '">' . $name . '</span>';
            }

            // align
            $align = $res['left'] ? 'left' : false;
            $align .= $res['center'] ? 'center' : false;
            $align .= $res['right'] ? 'right' : false;

            if ($align) {
                $name = '<div align="' . $align . '">' . $name . '</div>';
            }


            // Если было задано начертание шрифта, то применяем
            $font = $res['bold'] ? 'font-weight: bold;' : false;
            $font .= $res['italic'] ? ' font-style:italic;' : false;
            $font .= $res['underline'] ? ' text-decoration:underline;' : false;

            if ($font) {
                $name = '<span style="' . $font . '">' . $name . '</span>';
            }

            @$cms_ads[$res['type']] .= '<a href="' . ($res['show'] ? $tools->checkout($res['link']) : $config['homeurl'] . '/go.php?id=' . $res['id']) . '">' . $name . '</a><br>';

            if (($res['day'] != 0 && time() >= ($res['time'] + $res['day'] * 3600 * 24))
                || ($res['count_link'] != 0 && $res['count'] >= $res['count_link'])
            ) {
                $db->exec('UPDATE `cms_ads` SET `to` = 1  WHERE `id` = ' . $res['id']);
            }
        }
    }
}

// Рекламный блок сайта
if (isset($cms_ads[0])) {
    echo $cms_ads[0];
}
/*
// Выводим логотип и переключатель языков
echo '<table style="width: 100%;" class="logo"><tr>' .
    '<td valign="bottom"><a href="' . $config['homeurl'] . '"><img src="'.$tools->LogoUrl().'"></a></td>' .
    ($headmod == 'mainpage' && count($config->lng_list) > 1 ? '<td align="right"><a href="' . $config->homeurl . '/go.php?lng"><b>' . strtoupper($locale) . '</b></a>&#160;<a href="' . $config->homeurl . '/go.php?lng">' . $tools->getFlag($locale) . '</a></td>' : '') .
    '</tr></table>';

// Выводим верхний блок с приветствием
echo '<div class="header"> ' . _t('Hi', 'system') . ', ' . ($systemUser->id ? '<b>' . $systemUser->name . '</b>!' : _t('Guest', 'system') . '!') . '</div>';

// Главное меню пользователя
echo '<div class="tmn">' .
    (isset($_GET['err']) || $headmod != "mainpage" || ($headmod == 'mainpage' && $act) ? '<a href=\'' . $config['homeurl'] . '\'>' . $tools->image('menu_home.png') . _t('Home', 'system') . '</a><br>' : '') .
    ($systemUser->id && $headmod != 'office' ? '<a href="' . $config['homeurl'] . '/profile/?act=office">' . $tools->image('menu_cabinet.png') . _t('Personal', 'system') . '</a><br>' : '') .
    (!$systemUser->id && $headmod != 'login' ? $tools->image('menu_login.png') . '<a href="' . $config['homeurl'] . '/login.php">' . _t('Login', 'system') . '</a>' : '') .
    '</div><div class="maintxt">';
*/
// Рекламный блок сайта
if (!empty($cms_ads[1])) {
    echo '<div class="gmenu">' . $cms_ads[1] . '</div>';
}

// Фиксация местоположений посетителей
$sql = '';
$set_karma = $config['karma'];

if ($systemUser->id) {
    // Фиксируем местоположение авторизованных
    if (!$systemUser->karma_off && $set_karma['on'] && $systemUser->karma_time <= (time() - 86400)) {
        $sql .= " `karma_time` = " . time() . ", ";
    }

    $movings = $systemUser->movings;

    if ($systemUser->lastdate < (time() - 300)) {
        $movings = 0;
        $sql .= " `sestime` = " . time() . ", ";
    }

    if ($systemUser->place != $headmod) {
        ++$movings;
        $sql .= " `place` = " . $db->quote($headmod) . ", ";
    }

    if ($systemUser->browser != $env->getUserAgent()) {
        $sql .= " `browser` = " . $db->quote($env->getUserAgent()) . ", ";
    }

    $totalonsite = $systemUser->total_on_site;

    if ($systemUser->lastdate > (time() - 300)) {
        $totalonsite = $totalonsite + time() - $systemUser->lastdate;
    }

    $db->query("UPDATE `users` SET $sql
        `movings` = '$movings',
        `total_on_site` = '$totalonsite',
        `lastdate` = '" . time() . "'
        WHERE `id` = " . $systemUser->id);
} else {
    // Фиксируем местоположение гостей
    $movings = 0;
    $session = md5($env->getIp() . $env->getIpViaProxy() . $env->getUserAgent());
    $req = $db->query("SELECT * FROM `cms_sessions` WHERE `session_id` = " . $db->quote($session) . " LIMIT 1");

    if ($req->rowCount()) {
        // Если есть в базе, то обновляем данные
        $res = $req->fetch();
        $movings = ++$res['movings'];

        if ($res['sestime'] < (time() - 300)) {
            $movings = 1;
            $sql .= " `sestime` = '" . time() . "', ";
        }

        if ($res['place'] != $headmod) {
            $sql .= " `place` = " . $db->quote($headmod) . ", ";
        }

        $db->exec("UPDATE `cms_sessions` SET $sql
            `movings` = '$movings',
            `lastdate` = '" . time() . "'
            WHERE `session_id` = " . $db->quote($session) . "
        ");
    } else {
        // Если еще небыло в базе, то добавляем запись
        $db->exec("INSERT INTO `cms_sessions` SET
            `session_id` = '" . $session . "',
            `ip` = '" . $env->getIp() . "',
            `ip_via_proxy` = '" . $env->getIpViaProxy() . "',
            `browser` = " . $db->quote($env->getUserAgent()) . ",
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `place` = " . $db->quote($headmod) . "
        ");
    }
}






##### Structure web


		
echo '<div id="page-background-gradient"></div>';
echo '<div id="main1">';
    echo '<div class="Sheet">';
        echo '<div class="Sheet-tl"></div>';
        echo '<div class="Sheet-tr"></div>';
        echo '<div class="Sheet-bl"></div>';
        echo '<div class="Sheet-br"></div>';
        echo '<div class="Sheet-tc"></div>';
        echo '<div class="Sheet-bc"></div>';
        echo '<div class="Sheet-cl"></div>';
        echo '<div class="Sheet-cr"></div>';
        echo '<div class="Sheet-cc"></div>';
        echo '<div class="Sheet-body">';
            echo '<div class="Header">';
                echo '<div class="Header-jpeg"></div>';
                echo '<div class="Logo">';
                    echo '<h1 id="name-text" class="Logo-name"><a href="' . $config['homeurl'] . '">' . $config->copyright . '</a></h1>';
                    echo '<div id="slogan-text" class="Logo-text">Web Modifer</div>';
                echo '</div>';
            echo '</div>';
        echo '<div class="nav">';
            echo '<div class="l"></div>';
            echo '<div class="r"></div>';
            echo '<ul class="menu1">';
                echo '<li>';
                	echo '<a href="' . $config['homeurl'] . '"><span class="l"></span><span class="r"></span><span class="t">Home</span></a>';
					echo '</li>';
                echo '<li>';
                echo '<li>';
                	echo '<a href="/"><span class="l"></span><span class="r"></span><span class="t">Menu</span></a>';
                	echo '<ul>';
                		echo '<li><a href="/">' . _t('Information', 'system') . ' <i class="icon-caret-right"></i></a>';
                			echo '<ul>';
                				echo '<li><a href="'.$config['homeurl'].'/news/">' . _t('News archive', 'system') . '</a></li>';
                				echo '<li><a href="'.$config['homeurl'].'/help/">' . _t('Information, FAQ', 'system') . '</a></li>';
                			echo '</ul>';
                		echo '</li>';
                		echo '<li><a href="/">' . _t('Communication', 'system') . ' <i class="icon-caret-right"></i></a>';
						echo '<ul>';
                				echo '<li><a href="'.$config['homeurl'].'/guestbook/index.php">' . _t('Guestbook', 'system') . '</a></li>';
                				echo '<li><a href="'.$config['homeurl'].'/forum/">' . _t('Forum', 'system') . '</a></li>';
                			echo '</ul>';

                		echo '<li><a href="/">' . _t('Useful', 'system') . ' <i class="icon-caret-right"></i></a>';
						echo '<ul>';
                				echo '<li><a href="'.$config['homeurl'].'/downloads/">' . _t('Downloads', 'system') . '</a></li>';
                				echo '<li><a href="'.$config['homeurl'].'/library/">' . _t('Library', 'system') . '</a></li>';
if ($config['menu_enable'] == 1) {
                				echo '<li><a href="'.$config['homeurl'].'/system/menu.php">WapMaster</a></li>';
}
                			echo '</ul>';
                	echo '<li><a href="/">' . _t('Community', 'system') . ' <i class="icon-caret-right"></i></a>';
						echo '<ul>';
                				echo '<li><a href="'.$config['homeurl'].'/users/index.php">' . _t('Users', 'system') . '</a> </li>';
                				echo '<li><a href="'.$config['homeurl'].'/album/index.php">' . _t('Photo Albums', 'system') . '</a></li>';
                				echo '<li><a href="http://gazenwagen.com/">Gazenwagen</a></li>';
								echo '<li><a href="http://vivva.ru/">Vivva</a></li>';
                			echo '</ul>';
					echo '</ul>';
                echo '</li>';		
                echo '<li>';
					echo ($user_id) ? '<a href="' . $set['homeurl'] . '/users/profile.php?act=office"><span class="l"></span><span class="r"></span><span class="t">' . $lng['personal'] . '</span></a> ' : '';
                echo '</li>';
				echo '<li>';
					echo ($systemUser->isValid()) ? '<a href="' . $config['homeurl'] . '/exit.php"><span class="l"></span><span class="r"></span><span class="t">Exit</span></a> ' :'';
                echo '</li>';
				echo '<li>';
					echo (!$systemUser->isValid()) ? '<a href="' . $config['homeurl'] . '/login.php"><span class="l"></span><span class="r"></span><span class="t">Login</span></a> ' : '';
                echo '</li>';
				echo '<li>';
					echo (!$systemUser->isValid()) ? '<a href="' . $config['homeurl'] . '/registration/index.php"><span class="l"></span><span class="r"></span><span class="t">SignUp</span></a> ' : '';
                echo '</li>';
				echo '</ul>';
        echo '</div>';
        echo '<div class="contentLayout">';
		echo '<div class="sidebar1">';
			if (!empty ($cms_ads[0]))
				require_once ('colum_left/ads.php');
          //require_once ('colum_left/matrix.php');	 
          //require_once ('colum_left/chat.php');
			require_once ('colum_left/login.php');
          require_once ('colum_left/forum.php');
			require_once ('colum_left/1.php');
     	
echo '</div>';
    echo '<div class="content">';
        echo '<div class="Post">';
            echo '<div class="Post-tl"></div>';
            echo '<div class="Post-tr"></div>';
            echo '<div class="Post-bl"></div>';
            echo '<div class="Post-br"></div>';
            echo '<div class="Post-tc"></div>';
            echo '<div class="Post-bc"></div>';
            echo '<div class="Post-cl"></div>';
            echo '<div class="Post-cr"></div>';
            echo '<div class="Post-cc"></div>';
            echo '<div class="Post-body">';
                echo '<div class="Post-inner">';
 
 		


##### End of structure 






## Make Bot always on
$onbot = $config['bot_id'];
$db->exec("UPDATE `users` SET $sql `total_on_site`= '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '$onbot'");


// Выводим сообщение о Бане
if (!empty($systemUser->ban)) {
    echo '<h2 class="PostHeader"><div class="alarm">' . _t('Ban', 'system') . '&#160;<a href="' . $config['homeurl'] . '/profile/?act=ban">' . _t('Details', 'system') . '</a></div></h2>';
}

// Ссылки на непрочитанное
if ($systemUser->id) {
    $list = [];
    $new_sys_mail = $db->query("SELECT COUNT(*) FROM `cms_mail` WHERE `from_id`='" . $systemUser->id . "' AND `read`='0' AND `sys`='1' AND `delete`!='" . $systemUser->id . "'")->fetchColumn();

    if ($new_sys_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=systems">' . _t('System', 'system') . '</a> (+' . $new_sys_mail . ')';
    }

    $new_mail = $db->query("SELECT COUNT(*) FROM `cms_mail`
                            LEFT JOIN `cms_contact` ON `cms_mail`.`user_id`=`cms_contact`.`from_id` AND `cms_contact`.`user_id`='" . $systemUser->id . "'
                            WHERE `cms_mail`.`from_id`='" . $systemUser->id . "'
                            AND `cms_mail`.`sys`='0'
                            AND `cms_mail`.`read`='0'
                            AND `cms_mail`.`delete`!='" . $systemUser->id . "'
                            AND `cms_contact`.`ban`!='1'")->fetchColumn();

    if ($new_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=new">' . _t('Mail', 'system') . '</a> (+' . $new_mail . ')';
    }

    if ($systemUser->comm_count > $systemUser->comm_old) {
        $list[] = '<a href="' . $config['homeurl'] . '/profile/?act=guestbook&amp;user=' . $systemUser->id . '">' . _t('Guestbook', 'system') . '</a> (' . ($systemUser->comm_count - $systemUser->comm_old) . ')';
    }

    $new_album_comm = $db->query('SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = ' . $systemUser->id . ' AND `unread_comments` = 1')->fetchColumn();

    if ($new_album_comm) {
        $list[] = '<a href="' . $config['homeurl'] . '/album/index.php?act=top&amp;mod=my_new_comm">' . _t('Comments', 'system') . '</a>';
    }

   # @var notif forum
   if ($systemUser->notif_forum) {
       $list[] = '<a href="' . $config['homeurl'] . '/profile/notif.php">Notif Forum</a>&#160;(' . $systemUser->notif_forum . ')';
   }

    if (!empty($list)) {
        echo '<h2 class="PostHeader"> <div class="rmenu">' . _t('Unread', 'system') . ': ' . implode(', ', $list) . '</div></h2>';
    }
}

if ($systemUser->isValid() && !$systemUser->premium) {
   echo '<h2 class="PostHeader"><div class="rmenu">Update your account with premium to have full access see <a href="'.$config['homeurl'].'/help/?act=premium">here</a></div></h2>';
}


echo '<div class="PostContent">';	

