<?php

define('_IN_JOHNCMS', 1);

//require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

$currentdb = $container->get('config')['pdo']['db_name'];

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

$i = 0;

if ($systemUser->id != 1) {
    header('Location: /?err');
    exit;
}

if (!is_dir(ROOT_PATH . 'files/mysql/')) {
    mkdir(ROOT_PATH . 'files/mysql', 777);
}

$tab = $db->query("SHOW TABLES from `" . $currentdb . "`");
$total = $tab->rowCount();
$tables = [];

$headmod = 'admin';
$textl = $headmod;

//require('../system/head.php');
        
while ($res = $tab->fetchColumn()) {
    $tables[] = $res;
}

$table = in_array($_GET['table'], $tables) ? $_GET['table'] : null;

$select = isset($_REQUEST['select']) ? trim($_REQUEST['select']) : false;

function valid($tables) {
    return array_map(
        function ($tab) use ($tables) {
            return in_array($tab, $tables) ? $tab : false;
        }, $tables
    );
}

echo '<div class="main">';
echo '<div class="phdr">Download your backup (' . $config['homeurl'] . '/files/mysql/) and remove!</div>';
echo $select ? '<div class="rmenu">' . $select . '</div>' : ''; // debug

switch ($select) {
    default:
    
        $nav = $total > $kmess ? '<div class="topmenu">' . $tools->displayPagination('index.php?act=backup&amp;', $start, $total, $kmess) . '</div>' : '';
        echo '<div class="bmenu"><a href="index.php">Panel</a> | '
            . (isset($_GET['get']) ? '<a href="index.php?act=backup&amp;">Remove All</a></div>' : '<a href="index.php?act=backup&amp;get">Check All</a></div>')
            . '<div class="menu"><a href="index.php?act=backup&amp;select=add">Add</a> | <a href="index.php?act=backup&amp;select=raw">Raw query</a></div>';
        
        echo '<form action="index.php?act=backup&amp;" method="post">';
        
        echo $nav;
        foreach (new LimitIterator(new ArrayIterator($tables), $start, $kmess) as $res) {
            echo '<div class="list' . (++$i % 2 ? 2 : 1) . '">';
            echo '<input type="checkbox" ' . (isset($_GET['get']) ? 'checked="checked"' : '') . ' name="table[]" value="' . $res . '"/> <a href="index.php?act=backup&amp;select=view&amp;table=' . $res . '"><b>' . $res . '</b></a></div>';
        }
        echo $nav;
        
        echo '<div class="menu">'
             . '<select name="select">'
                . '<option value="backup">Backup</option>' 
                . '<option value="drop">Drop</option>' 
                . '<option value="optimize">Optimize</option>' 
                . '<option value="truncate">Truncate</option>' 
             . '</select>' 
             . '<br><input type="submit"/></div></form>';
        

    break;
    
    case 'add' :
/*    
        if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
            $data = file_get_contents($_FILES['file']['tmp_name']);
            if (preg_match_all("#(CREATE.*\;|INSERT.*\;)#isU", $data, $matches)) {
                if (count($matches[0])) {
                    $sql = implode(PHP_EOL, $matches[0]);
                    echo '<div class="gmenu">' . nl2br($sql) . '</div>';
                    $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, 1);
                    // TODO: // html rewrite
                    if ($db->prepare($sql)) {
                        echo 'done';
                    } else {
                        echo '<div>error import</div>';
                    }
                }
            } else {
                echo '<div>Bad sql file</div>';
                // TODO : rewrite output
            }
        } else {
            #echo '<pre>' . print_r($_POST, 1) . '</pre>';
            #echo '<pre>' . print_r($_FILES, 1) . '</pre>';
            echo '<div class="gmenu">' 
            . '<form action="index.php?act=backup&amp;select=add" method="post" enctype="multipart/form-data">'
            . '<div>Add</div><div><input type="file" name="file"></div>'
            . '<div><input type="submit" name="submit" value="Add"></div>'
            . '</form></div>';
        }

*/




     if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $file = strtolower($_FILES['file']['name']);
        $al_ext = array('txt', 'sql');
        $ext = explode(".", $file);
        if (count($ext) != 2 || !in_array($ext[1], $al_ext)) {
            echo $tools->displayError('By sending files that have allowed only a name and one extension (<b> name.ext </b>) and the extension should be txt or sql');
        } else {
            $file = $realtime . '.' . $ext[1];
            if ((move_uploaded_file($_FILES["file"]["tmp_name"], "../files/mysql/$file")) == true) {
                @chmod("$fname", 0777);
                @chmod("../files/mysql/$fname", 0777);
                $sql = file_get_contents('../files/mysql/' . $file);
                $sql = str_replace("\'", "'", trim($sql));
                $sql = explode(";(\n|\r)*", $sql);
//if error use preg_split
                $total_sql = 0;
                $total_sqk_ok = 0;
                for ($i = 0; $i < count($sql); $i++) {
                    if ($sql[$i] != '') {
                        ++$total_sql;
                        if ($db->query($sql[$i])) {
                            ++$total_sql_ok;
                        }
                    }
                }
                if ($total_sql) {
                    echo '<div class="gmenu">' . (($total_sql_ok == 1 && $total_sql = 1) ? 'The query completed successfully' : ' Achieved ' . $total_sql_ok . ' requests from the ' . $total_sql) . '</div>';
                } else {
                    echo '<div class="rmenu">Error</div>';
                    unlink("../files/mysql/$file");
                }
            } else {
                echo $tools->displayError('Error temporarily save the file maybe directory not found!');
                echo '<div class="gmenu"><a href="index.php?act=backup">Repeat</a></div>';
                echo '<div class="phdr"><a href="index.php">Panel</a></div>';
           }
        }
    } else {
            #echo '<pre>' . print_r($_POST, 1) . '</pre>';
            #echo '<pre>' . print_r($_FILES, 1) . '</pre>';
            echo '<div class="gmenu">' 
            . '<form action="index.php?act=backup&amp;select=add" method="post" enctype="multipart/form-data">'
            . '<div>Add</div><div><input type="file" name="file"></div>'
            . '<div><input type="submit" name="submit" value="Add"></div>'
            . '</form></div>';
        } 
    
    break;
    
    case 'drop' :
    $drop = valid($_POST['table']);
       
        $res = $db->query("DROP TABLE `" . implode('`, `', $drop) . "`");
        if ($res->rowCount()) {
            while ($row = $res->fetch()) {
                 echo '<div class="gmenu">' . $row['Table'] . ' Dropped!</div>'; 
            }
        }
        #echo '<pre>' . print_r($_POST, 1) . '</pre>';
        // TODO : see case optimize =)
    
    break;
    
    case 'structure' :
    
        if (!is_null($table)) {
            $row = $db->query("SHOW CREATE TABLE `" . $table . "`")->fetch();
            echo '<div class="gmenu"><div class="phpcode" style="overflow-x: auto">'.highlight_string($tools->checkout($row['Create Table']), true).'</div>'
                . '<div><b>Raw:</b><br><textarea>' . $tools->checkout($row['Create Table']) . '</textarea></div></div>'
                . '</div>';
        }
    
    break;
    
    case 'view' :
    
        if (!is_null($table)) {
            $res = $db->query("SELECT * FROM `" . $table . "` LIMIT " . $start . ", " . $kmess);
            $total = $db->query("SELECT COUNT(*) FROM `" . $table . "`")->fetchColumn();
            if ($total) {
                $nav = $total > $kmess ? '<div class="topmenu">' . $tools->displayPagination('index.php?act=backup&amp;select=view&amp;table=' . $table . '&amp;', $start, $total, $kmess) . '</div>' : '';
                echo $nav;
                echo '<div class="gmenu">';
                while ($row = $res->fetch()) {
                    echo '<table border="1">';
                    echo '<tr><th>' . implode('</th><th>', array_keys($row)) . '</th></tr>';
                    echo '<tr><td>' . implode('</td><td>', array_values($row)) . '</td></tr>';
                    echo '</table>';
                    #echo '<pre>' . print_r($row, 1) . '</pre>'; // debug
                }
                echo '</div>';
                echo $nav;
            } else {
                echo '<div class="alarm">Empty table</div>';
            }
            
            echo '<div class="rmenu"><a href="index.php?act=backup&amp;select=structure&amp;table=' . $table . '">Swow structure</a></div>';
        }
    
    break;
    
    case 'optimize' :
    
        $optimize = valid($_POST['table']);
       
        $res = $db->query("OPTIMIZE TABLE `" . implode('`, `', $optimize) . "`");
        if ($res->rowCount()) {
            while ($row = $res->fetch()) {
                 echo '<div class="gmenu">' . $row['Table'] . ' ' . $row['Msg_text'] . '</div>'; 
            }
        }
    
    break;
    
    case 'truncate' :
    
        $sql = "TRUNCATE TABLE ";
        
        $trunc = array_map(
            function ($tab) use ($sql) {
                return $sql . '`' . $tab . '`;';
            }, valid($_POST['table'])
        );
        #echo '<pre>';print_r($trunc);
        $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, 0);
        $db->exec(implode(' ', $trunc));
        echo '<div>Truncated</div>';
    
    break;
    
    case 'raw' :
       header('Location: index.php?act=mysql');
        // TODO: inmput form raw query 
    
    break;
    
    case 'backup' :
    
        $dumpname = ROOT_PATH . 'files' . DIRECTORY_SEPARATOR . 'mysql' . DIRECTORY_SEPARATOR . date('Y-m-d-h-i-s') . substr(md5(uniqid(time())), 0, 8) . '.sql';
        
        file_put_contents($dumpname, '-- ' . basename($dumpname) . ' SQL Dump' . PHP_EOL . PHP_EOL . PHP_EOL, FILE_APPEND | LOCK_EX);
    
        foreach (valid($_POST['table']) as $dbtable) {
            file_put_contents($dumpname, "DROP TABLE IF EXISTS `" . $dbtable . "`;" . PHP_EOL . PHP_EOL, FILE_APPEND | LOCK_EX);
            $row = $db->query("SHOW CREATE TABLE `" . $dbtable . "`")->fetch();
            file_put_contents($dumpname, $row['Create Table'] . ';' . PHP_EOL . PHP_EOL, FILE_APPEND | LOCK_EX);
            $res = $db->query("SELECT * FROM `" . $dbtable . "`");
            $values = [];
            if ($res->rowCount()) {
                while ($row = $res->fetch()) {
                    if ($i == 0) {
                        $keys = '`' . implode('`, `', array_keys($row)) . '`';
                    }
                    $values[] = PHP_EOL . PHP_EOL . '(' . implode(', ', array_map(array($db, 'quote'), array_values($row))) . ')';
                }
            }
            $sql .= "INSERT INTO `" . $dbtable . "` (" . $keys . ") VALUES ";
            file_put_contents($dumpname, "INSERT INTO `" . $dbtable . "` (" . $keys . ") VALUES ", FILE_APPEND | LOCK_EX);
            $i = 1;
            $count = count($values);
            foreach ($values as $val) {
                file_put_contents($dumpname, $val . ($i < $count ? ', ' : ';'), FILE_APPEND | LOCK_EX);
                $i++;
            }
        }
      echo '<div class="gmenu">Backup Success<br/>' . basename($dumpname) . '</div>'; 
      echo '<div class="rmenu"><p align="center"><a href="' . $config['homeurl'] . '/files/mysql/' . basename($dumpname) . '">Download</a></p></div>';
    break;
}

if ($select) {
    echo '<div class="phdr"><a href="index.php?act=backup&amp;">Back</a></div>';
}

echo '</div>';
//require_once('../system/end.php');