<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

// Получаем данные пользователя
$user = $tools->getUser(isset($_REQUEST['user']) ? abs(intval($_REQUEST['user'])) : 0);

/** @var Johncms\Counters $counters */
$counters = $container->get('counters');
$mp = new Johncms\NewsWidget();
// Рекламный блок сайта
if (!empty($cms_ads[2])) {
    echo '<div class="gmenu">' . $cms_ads[2] . '</div>';
}
// Информация о юзере
    $arg = [
        'lastvisit' => 0,
        'iphist'    => 0,
        'iphide'    => 1,
    ];
?>
        </div>
        <?php if($_SERVER['PHP_SELF'] != '/index.php'){$hide = ' d-sm-none d-md-block';} ?>
        <div class="col-lg-3<?php echo $hide; ?>">
            <?php echo $mp->news; ?>

            <div class="box" style="margin-top: 1px;">
                <div class="menus"><i class="fas fa-rss-square"></i> <a href="/news/"><?php echo _t('News archive', 'system'); ?></a> <span class="count float-right"><?php echo $mp->newscount; ?></span></div>
            <?php
            if ($config->mod_guest || $systemUser->rights >= 7) {
            ?>
                <div class="menus"><i class="fas fa-comment"></i> <a href="/guestbook/index.php"><?php echo _t('Guestbook', 'system'); ?></a> <span class="count float-right"><?php echo $counters->guestbook(); ?></span></div>
            <?php } ?>
            <?php
            if ($config->mod_forum || $systemUser->rights >= 7) {
            ?>
                <div class="menus"><i class="fas fa-comments"></i> <a href="/forum/"><?php echo _t('Forum', 'system'); ?></a> <span class="count float-right"><?php echo $counters->forum(); ?></span></div>
            <?php } ?>
            <?php
            if ($config->mod_down || $systemUser->rights >= 7) {
            ?>
                <div class="menus"><i class="fas fa-folder"></i> <a href="/downloads/"><?php echo _t('Downloads', 'system'); ?></a> <span class="count float-right"><?php echo $counters->downloads(); ?></span></div>
            <?php } ?>
            <?php
            if ($config->mod_lib || $systemUser->rights >= 7) {
            ?>
                <div class="menus"><i class="fas fa-book"></i> <a href="/library/"><?php echo _t('Library', 'system'); ?></a> <span class="count float-right"><?php echo $counters->library(); ?></span></div>
            <?php } ?>
            <?php
            if ($systemUser->isValid() || $config->active) {
            ?>
                <div class="menus"><i class="fas fa-users"></i> <a href="/users/index.php"><?php echo _t('Users', 'system'); ?></a> <span class="count float-right"><?php echo $counters->users(); ?></span></div>
                <div class="menus"><i class="far fa-images"></i> <a href="/album/index.php"><?php echo _t('Photo Albums', 'system'); ?></a> <span class="count float-right"><?php echo $counters->album(); ?></span></div>
            <?php } ?>
            </div>
        </div>
    </div>
</div>


<?php
echo '<div class="fmenu">';

if (isset($_GET['err']) || $headmod != "mainpage" || ($headmod == 'mainpage' && isset($_GET['act']))) {
    echo '<div><a href=\'' . $config->homeurl . '\'>' . $tools->image('menu_home.png') . _t('Home', 'system') . '</a></div>';
}

echo '<div>' . $container->get('counters')->online() . '</div>' .
    '</div>' .
    '<div style="text-align:center">' .
    '<p><b>' . $config->copyright . '</b></p>';

// Счетчики каталогов
$req = $db->query('SELECT * FROM `cms_counters` WHERE `switch` = 1 ORDER BY `sort` ASC');

if ($req->rowCount()) {
    while ($res = $req->fetch()) {
        $link1 = ($res['mode'] == 1 || $res['mode'] == 2) ? $res['link1'] : $res['link2'];
        $link2 = $res['mode'] == 2 ? $res['link1'] : $res['link2'];
        $count = ($headmod == 'mainpage') ? $link1 : $link2;

        if (!empty($count)) {
            echo $count;
        }
    }
}

// Рекламный блок сайта
if (!empty($cms_ads[3])) {
    echo '<br />' . $cms_ads[3];
}
if($systemUser->rights >= 7){
    echo $_SERVER['PHP_SELF'];
}
?>
<script src="/bootstrap/js/jquery-3.2.1.slim.min.js"></script>
<script src="/bootstrap/js/popper.min.js"></script>
<script src="/bootstrap/js/bootstrap.min.js"></script>
<!-- Yandex.Metrika counter -->
<script type="text/javascript" >
    (function (d, w, c) {
        (w[c] = w[c] || []).push(function() {
            try {
                w.yaCounter48267827 = new Ya.Metrika({
                    id:48267827,
                    clickmap:true,
                    trackLinks:true,
                    accurateTrackBounce:true,
                    webvisor:true
                });
            } catch(e) { }
        });

        var n = d.getElementsByTagName("script")[0],
            s = d.createElement("script"),
            f = function () { n.parentNode.insertBefore(s, n); };
        s.type = "text/javascript";
        s.async = true;
        s.src = "https://mc.yandex.ru/metrika/watch.js";

        if (w.opera == "[object Opera]") {
            d.addEventListener("DOMContentLoaded", f, false);
        } else { f(); }
    })(document, window, "yandex_metrika_callbacks");
</script>
<noscript><div><img src="https://mc.yandex.ru/watch/48267827" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
<!-- /Yandex.Metrika counter -->
</body></html>