<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */


define('_IN_JOHNCMS', 1);

//require('../system/bootstrap.php');

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ToolsInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Counters $counters */
$counters = App::getContainer()->get('counters');

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');
echo '<div class="phdr"><b>Color Status</b> | <a href="/shop/">Shop '.str_replace('http://', '',$set['homeurl']).'</a></div>';

// Ð£Ð·Ð½Ð°Ñ�Ð¼ Ñ�ÐµÐ½Ñ�
$price = $db->query("SELECT `price` FROM `shop` WHERE `id` = 12")->fetchColumn();
$a = $price['price'];

if (isset($_POST['submit'])) {
    // Ð�Ñ�Ð¸Ð½Ð¸Ð¼Ð°ÐµÐ¼ Ð´Ñ�Ð½Ð½Ñ�Ðµ
    $kod = isset($_POST['kod']) ? trim($_POST['kod']) : '';
    $clr = isset($_POST['color']) ? functions::check(mb_substr($_POST['color'], 0, 25)) : '';
    $error = false;

    // Ð�Ñ�Ð¾Ð²ÐµÑ�ÐºÐ° ÐºÐ¾Ð´Ð° CAPTCHA
    if (empty($kod) || mb_strlen($kod) < 4)
        $error = $error . 'You have not entered the verification code!<br />';
    elseif ($kod != $_SESSION['code'])
        $error = $error . 'Verification code is incorrect!<br />';
    unset($_SESSION['code']);

    // Ð�Ñ�Ð¾Ð²ÐµÑ�ÐºÐ° Ñ�Ð²ÐµÑ�Ð°
    if (empty($clr) || mb_strlen($clr) < 3)
        $error = $error . 'Do not put numbers Status!<br />';
    if (preg_match("/[^0-9a-zA-Z]+/", $clr))
            $error = 'Invalid characters in color Status!<br/>';

    if (empty($error)) {
        // Ð�Ñ�Ð¾Ð²ÐµÑ�ÐºÐ° Ð¼Ð¾Ð½ÐµÑ�
        if ($datauser['balans'] < $a) {
        $error = 'Not enough coins to change color Status!<br/>';
        }
    }

    // Ð�Ð°Ð½Ð¾Ñ�Ð¸Ð¼ Ð´Ð°Ð½Ð½Ñ�Ðµ Ð² Ð�Ð°Ð·Ñ�
    if (empty($error)) {
        $db->query("UPDATE `users` SET `balans` = '" . ($datauser['balans'] - $a) . "', `cstat` = '" . db_real_escape_string($clr) . "' WHERE `id` = '$user_id'")->fetchColumn();
        echo '<div class="gmenu">Color your status changed!<br/>';
        echo 'Example: <font color="'.$clr.'">'.$datauser['status'].'</font>';
        echo '<br/><a href="/shop/">To Shop</a>';
        echo '</div>';
    } else {
        echo '<div class="rmenu"><p><b>ERROR!</b><br />' . $error . '</p></div>';
    }

} else {
    // Ð¤Ð¾Ñ�Ð¼Ð° Ð²Ð²Ð¾Ð´Ð°
    echo '<div class="list2"><b>'.$login.'</b>, Sdes you can change the color of their status.<br/>Cost: '.$a.' coins</div>';
    echo '<form action="/shop/index.php?act=cstat" method="post"><div class="list1">';
    echo '<p>'.(strlen($datauser['cstat']) == 1 ? '<b>Color:</b>' : '<font color="'.$datauser['cstat'].'"><b>Color:</b></font>').'<br/><input type="text" name="color" maxlength="25" value="'.$datauser['cstat'].'" /><br/><small>Enter the name(black) or code(000000) of the desired color for your status<br/><font color="red">DO NOT enter the color code in RGB and HTML code, without the #(pound)!</font></small><br/><a href="/shop/color.php"><font color="0000ff">Table Color</font></a></p></div>';
    echo '<div class="gmenu"><p><img src="/captcha.php?r=' . rand(1000, 9999) . '" alt="pluses´" border="1"/><br />';
    echo 'Captcha:<br/><input type="text" size="5" maxlength="5" name="kod"/></p></div>';
    echo '<div class="phdr"><input type="submit" name="submit" value="Submit"/></div></form>';
    }

?>