<?php
// Фильмы пользовательская часть
$map->get('/', [\Films\Controllers\FilmsController::class, 'index']);  // Home Page
$map->addRoute(['GET', 'POST'], '/films/[/]', [\Films\Controllers\FilmsController::class, 'index']);
$map->addRoute(['GET', 'POST'], '/films/search/[/]', [\Films\Controllers\FilmsController::class, 'searchFilm']);
$map->addRoute(['GET', 'POST'], '/films/{film_id:\d+}/', [\Films\Controllers\FilmsController::class, 'findFilm']);
$map->addRoute(['GET', 'POST'], '/films/category/[/]', [\Films\Controllers\FilmsController::class, 'showCategories']);
$map->addRoute(['GET', 'POST'], '/films/category/{category_name:[\w.+-]+}/[{category_type:[\w.+-]+}/]', [\Films\Controllers\FilmsController::class, 'category']);
// Фильмы админка
$map->addRoute(['GET', 'POST'], '/admin/films/settings/[/]', [\Films\Controllers\Admin\FilmsAdminController::class, 'settings']);
$map->addRoute(['GET', 'POST'], '/admin/films/index/[/]', [\Films\Controllers\Admin\FilmsAdminController::class, 'index']);
$map->addRoute(['GET', 'POST'], '/admin/films/category/[/]', [\Films\Controllers\Admin\FilmsAdminController::class, 'categoryFilms']);
$map->addRoute(['GET', 'POST'], '/admin/films/delcategory/{delete_id:\d+}/', [\Films\Controllers\Admin\FilmsAdminController::class, 'deleteCategory']);
$map->addRoute(['GET', 'POST'], '/admin/films/editcategory/{edit_id:\d+}/', [\Films\Controllers\Admin\FilmsAdminController::class, 'editCategory']);
$map->addRoute(['GET', 'POST'], '/admin/films/del/{delete_id:\d+}/', [\Films\Controllers\Admin\FilmsAdminController::class, 'deleteFilm']);

//Обратная связь
$map->addRoute(['GET', 'POST'], '/feedback/[/]', [\Feedback\Controllers\FeedbackController::class, 'index']);
$map->addRoute(['GET', 'POST'], '/feedback/copyright[/]', [\Feedback\Controllers\FeedbackController::class, 'copyright']);
$map->addRoute(['GET', 'POST'], '/admin/feedback/index/[/]', [\Feedback\Controllers\Admin\AdminController::class, 'index']);
$map->addRoute(['GET', 'POST'], '/admin/feedback/show/{id:\d+}/', [\Feedback\Controllers\Admin\AdminController::class, 'showFeedback']);
$map->addRoute(['GET', 'POST'], '/admin/feedback/del/{id:\d+}/', [\Feedback\Controllers\Admin\AdminController::class, 'deleteFeedback']);
$map->addRoute(['GET', 'POST'], '/admin/feedback/read/{id:\d+}/', [\Feedback\Controllers\Admin\AdminController::class, 'readFeedback']);

