// Default div class for button
const button = '.moon';
// ID for <style>
const styleID = 'color-switcher';
// name for localStorage item
const storageItem = 'moon';

/* vars for setting dark theme color */
const backgroundColor = '#212529';
const fontColor = '#f4f3ef';

const divs = {
    '.content-container, .bg-white, .wysibb': {
        'color': fontColor,
        'background-color': backgroundColor
    },
    'body': {
        'background-color': backgroundColor 
    },
    '.alert-warning': {
        'background-color': '#5c1111',
    },
    '.sidebar a, .btn-link, a': {
        'color': fontColor
    },
    '.text-muted': {
        'color': '#fff'
    },
    'input.form-control': {
        'background-color': backgroundColor
    },
    '#meta_description, #meta_keywords': {
        'background-color': backgroundColor
    },
    '.user-name': {
        'color': '#fd7948'
    },
    '.alert-success':  {
        'color': '#fff',
        'background-color': '#013a28;'
    },
    ':root': {
        '--ck-color-base-background': backgroundColor,
        '--ck-color-toolbar-background': backgroundColor,
        '--ck-color-text': fontColor
    }
}

// Return to black if it was be chose
if (localStorage.getItem(storageItem)) {
    switchToBlack();
}


// Listiner for button

window.onload = function () {
    let element = document.querySelector(button);
    element.addEventListener('click', function () {
        var item = localStorage.getItem(storageItem);
        if (parseInt(item) === 1) {
            switchToDefault();
        } else {
            switchToBlack();
        }
    });
}

// function for switching to black theme
function switchToBlack() {

    localStorage.setItem(storageItem, 1);

    // Change background colors
    let elements = '';
    for (let [key, value] of Object.entries(divs)) {
        elements += key + '{';
        // Get properties
        for (let [attribute, properties] of Object.entries(value)) {
            elements += attribute + ':' + properties + ' !important;';
        }
        elements += '}';
    }

    let style = document.createElement('style');
    style.setAttribute('id', styleID);
    document.head.append(style);
    style.innerHTML = elements;
    
}

// Return to default theme
function switchToDefault() {
    let element = document.querySelector('#' + styleID);
    localStorage.removeItem(storageItem);
    element.remove();
}