<?php

class TagsCloud {

    private $tags;

    private $font_size_min = 16;
    private $font_size_step = 4;

    function __construct($tags) {

        shuffle($tags);
        $this->tags = $tags;

    }

    private function get_tag_count($tag_name, $tags) {

        $count = 0;

        foreach ($tags as $tag) {
            if ($tag == $tag_name) {
                $count++;
            }
        }

        return $count;

    }

    private function tagscloud($tags) {

        $tags_list = array();

        foreach ($tags as $tag) {
            $tags_list[$tag] = self::get_tag_count($tag, $tags);
        }

        return $tags_list;

    }

    private function get_min_count($tags_list) {

        $min = $tags_list[$this->tags[0]];

        foreach ($tags_list as $tag_count) {

            if ($tag_count < $min) $min = $tag_count;

        }

        return $min;

    }

    public function get_cloud() {

        $cloud = Array();

        $tags_list = self::tagscloud($this->tags);
        $min_count = self::get_min_count($tags_list);

        foreach ($tags_list as $tag=>$count) {

            $font_steps = $count - $min_count;
            $font_size = $this->font_size_min + $this->font_size_step * $font_steps;

            $cloud[] = "<span style='font-size:".$font_size."px'>".$tag."</span>";
        }

        return $cloud;

    }
}

$tags = array(
    'ajax', 'javascript', 'php', 'dojo',
    'ajax', 'jquery', 'seo', 'seo',
    'php', 'blog', 'ajax', 'php',
    'html', 'css', 'ajax', 'javascript',
    'css', 'jquery', 'php', 'smo'
);

$mycloud   = new TagsCloud($tags);
$tags_list = $mycloud->get_cloud();

foreach ($tags_list as $tag)
{
    echo $tag.' ';
}


?>