<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                Mobile Content Management System                    //
// Project site:          http://johncms.com                                  //
// Support site:          http://gazenwagen.com                               //
////////////////////////////////////////////////////////////////////////////////
// Lead Developer:        Oleg Kasyanov   (AlkatraZ)  alkatraz@gazenwagen.com //
// Development Team:      Eugene Ryabinin (john77)    john77@gazenwagen.com   //
//                        Dmitry Liseenko (FlySelf)   flyself@johncms.com     //
////////////////////////////////////////////////////////////////////////////////
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');

// Автоматическое создание скриншотов
function screen_auto($file, $id, $format_file) {
    global $screenroot;
    $screen = '';
    if ($format_file == 'nth') {
        require_once ("../incfiles/lib/pclzip.lib.php");
        $theme = new PclZip($file);
        $content = $theme->extract(PCLZIP_OPT_BY_NAME, 'theme_descriptor.xml', PCLZIP_OPT_EXTRACT_AS_STRING);
        if (!$content)
            $content = $theme->extract(PCLZIP_OPT_BY_PREG, '\.xml$', PCLZIP_OPT_EXTRACT_AS_STRING);
        $val = simplexml_load_string($content[0]['content'])->wallpaper['src'] or $file = simplexml_load_string($content[0]['content'])->wallpaper['main_display_graphics'];
        $image = $theme->extract(PCLZIP_OPT_BY_NAME, trim($val), PCLZIP_OPT_EXTRACT_AS_STRING);
        $is_dir = is_dir($screenroot . '/' . $id);
        if (!$is_dir) {
            $is_dir = mkdir($screenroot . '/' . $id, 0777);
            if($is_dir == true)
            	@chmod($screenroot . '/' . $id, 0777);
        }
        $file_img = $screenroot . '/' . $id . '/' . $id . '.jpg';
        if ($is_dir) {
            if (file_put_contents($file_img, $image[0]['content']))
                $screen = $file_img;
        }
    } elseif ($format_file == 'thm') {
        require_once ("../incfiles/lib/Tar.php");
        $theme = new Archive_Tar($file);
        if (!$file_th = $theme->extractInString('Theme.xml') or !$file_th = $theme->extractInString(pathinfo($file, PATHINFO_FILENAME) . '.xml')) {
            $list = $theme->listContent();
            $all = sizeof($list);
            for ($i = 0; $i < $all; ++$i) {
                if (pathinfo($list[$i]['filename'], PATHINFO_EXTENSION) == 'xml') {
                    $file_th = $theme->extractInString($list[$i]['filename']);
                    break;
                }
            }
        }
        if (!$file_th) {
            preg_match('/<\?\s*xml\s*version\s*=\s*"1\.0"\s*\?>(.*)<\/.+>/isU', file_get_contents($file), $array);
            $file_th = trim($array[0]);
        }
        $load_file = trim((string )simplexml_load_string($file_th)->Standby_image['Source']);
        if (strtolower(strrchr($load_file, '.')) == '.swf')
            $load_file = '';
        if (!$load_file)
            $load_file = trim((string )simplexml_load_string($file_th)->Desktop_image['Source']);
        if (strtolower(strrchr($load_file, '.')) == '.swf')
            $load_file = '';
        if (!$load_file)
            $load_file = trim((string )simplexml_load_string($file_th)->Desktop_image['Source']);
        if (strtolower(strrchr($load_file, '.')) == '.swf')
            $load_file = '';
        if (!$load_file)
            exit;
        $image = $theme->extractInString($load_file);
        $is_dir = is_dir($screenroot . '/' . $id);
        if (!$is_dir) {
            $is_dir = mkdir($screenroot . '/' . $id, 0777);
            if($is_dir == true)
            	@chmod($screenroot . '/' . $id, 0777);
        }
        $file_img = $screenroot . '/' . $id . '/' . $id . '.jpg';
        if ($is_dir) {
            if (file_put_contents($file_img, $image))
                $screen = $file_img;
        }
    }
    return $screen;
}
//Вывод файла в ЗЦ
function show_file($res_down = array()) {
    global $filesroot, $set_down, $screenroot, $old;
    $out = '';
    $format_file = format($res_down['name']);
    if ($format_file == 'jpg' || $format_file == 'jpeg' || $format_file == 'gif' || $format_file == 'png') {
        $preview = $res_down['dir'] . '/' . $res_down['name'];
    }
    else
        if ($format_file == 'thm' || $format_file == 'nth') {
            if (is_file($screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.jpg')) {
                $preview = $screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.jpg';
            } elseif (is_file($screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.gif')) {
                $preview = $screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.gif';
            } elseif (is_file($screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.png')) {
                $preview = $screenroot . '/' . $res_down['id'] . '/' . $res_down['id'] . '.png';
            }
            else
                if ($set_down['theme_screen']) {
                    $preview = screen_auto($res_down['dir'] . '/' . $res_down['name'], $res_down['id'], $format_file);
                }
            $preview = $preview ? $preview : 'images/easy.gif';
        }
    if ($preview) {
        $out = '<img src="preview.php?type=1&amp;img=' . rawurlencode($preview) . '" alt="preview" />';
    }
    if ($format_file == 'jar' && $set_down['icon_java'])
        $out = java_icon($res_down['dir'] . '/' . $res_down['name'], $res_down['id']);
    else
        $out .= '<img src="' . $filesroot . '/images/' . (file_exists($filesroot . '/images/' . $format_file . '.png') ? $format_file . '.png' : 'file.gif') . '" alt="file" /> ';
    $out .= '<a href="?act=view&amp;id=' . $res_down['id'] . '">' . checkout($res_down['rus_name']) . '</a> (' . $res_down['field'] . ')';
    if ($res_down['time'] > $old)
        $out .= ' <span class="red">(NEW)</span>';
    if ($res_down['about']) {
        $about = $res_down['about'];
        if (mb_strlen($about) > 100)
            $about = mb_substr($about, 0, 90) . '...';
        $out .= '<div class="sub">' . checkout($about, 2) . '</div>';
    }
    $out .= '<div class="sub"><a href="index.php?act=comms&amp;id=' . $res_down['id'] . '">Комментарии</a> (' . $res_down['total'] . ')</div>';
    return $out;
}
//Вынимаем иконку из Java
function java_icon($file, $id) {
    if (is_file('images/java_icons/' . $id . '.png')) {
        $out = 'images/java_icons/' . $id . '.png';
    }
    else {
        require_once ("../incfiles/lib/pclzip.lib.php");
        $zip = new PclZip($file);
        if ($zip->listContent() > 0) {
            if ($manifest = $zip->extract(PCLZIP_OPT_BY_NAME, 'META-INF/MANIFEST.MF', PCLZIP_OPT_EXTRACT_AS_STRING)) {
                $text = $manifest[0]['content'];
                if (strpos($text, 'MIDlet-Icon: ') !== false) {
                    $explode = explode('MIDlet-Icon: ', $text);
                    $icon = str_replace("\r", ' ', str_replace("\n", ' ', $explode[1]));
                    $icon = strtok($icon, ' ');
                    $icon = preg_replace('#^/#', null, $icon);
                }
                else
                    $icon = 'icon.png';
            	$ext = explode('.', $icon);
                if($ext[1] == 'png' && count($ext) == 2) {
                	if ($image = $zip->extract(PCLZIP_OPT_BY_NAME, $icon, PCLZIP_OPT_EXTRACT_AS_STRING)) {
                    	$image = imagecreatefromstring($image[0]['content']);
                        $width = imagesx($image);
						$height = imagesy($image);
                       	$x_ratio = 16/$width;
						$y_ratio = 16/$height;
						if(($width<=16)&&($height<=16)){
							$tn_width = $width;
							$tn_height = $height;
						}
						elseif (($x_ratio*$height)<16){
							$tn_height = ceil($x_ratio*$height);
							$tn_width = 16;
						}
						else{
							$tn_width = ceil($y_ratio*$width);
							$tn_height = 16;
						}
                        $image_two = ImageCreate($tn_width, $tn_height);
                        imagecopyresampled($image_two, $image, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
                        $image = $image_two;
                        $file_img = 'images/java_icons/' . $id . '.png';
                        if(imagepng($image, $file_img))
                        	$out = $file_img;
                        imagedestroy($image);
					}
                }
            }
        }
        if (!$out) {
            //Определится, нужно ли это (минус: создает один файл для 1 файла без иконки; плюс: архив не будет вечно открыватся и в нем не будет вечно искаться иконка)
            $out = 'images/jar.png';
            @copy($out, 'images/java_icons/' . $id . '.png');
        }
    }
    return '<img src="' . $out . '" alt="file"/> ';
}

?>