<?php

defined('_IN_JOHNCMS') or die('Restricted access');

class Message_functions {
	// Организация вывода сообщений от системы пользователю.
	// Используемые коды сообщений:
		// 0 - критическая ошибка;
		// 1 - ошибка;
		// 2 - внимание;
		// 3 - ок.

	public function get_and_show() {
		// Функция для вывода ранее установленного сообщения.
		// Пример использования:
			// questions_Message_functions::get_and_show();
			
		if (isset($_SESSION['questions_message_text'])) {
			switch ($_SESSION['questions_message_code']) {
				case '0': echo '<div class="alarm">Ошибка: "'.$_SESSION['questions_message_text'].'"</div>'; break;
				case '1': echo '<div class="alarm">Ошибка: "'.$_SESSION['questions_message_text'].'"</div>'; break;
				case '2': echo '<div class="bmenu">Внимание: "'.$_SESSION['questions_message_text'].'"</div>'; break;
				case '3': echo '<div class="bmenu">'.$_SESSION['questions_message_text'].'</div>'; break;
				case '4': echo '<div class="menu">'.$_SESSION['questions_message_text'].'</div>'; break;
				default: echo '<div class="bmenu">'.$_SESSION['questions_message_text'].'</div>'; break;
			}
		}
		else {
			return 1;
		}
		unset($_SESSION['questions_message_code']);
		unset($_SESSION['questions_message_text']);
	}
	
	public function set($code = 1, $text = 'Неопознанная ошибка') {
		// Функция для установки сообщения.
		// Пример использования:
			// questions_Message_functions::set(1, 'Вы ошиблись!');

		$_SESSION['questions_message_code'] = $code;
		$_SESSION['questions_message_text'] = $text;
	}
	
	public function set_and_redirect($code = 1, $text = 'Неопознанная ошибка', $link = '') {
		// Функция для установки сообщения и немедленного перенаправления на заданную страницу.
		// Пример использования:
			// questions_Message_functions::set_and_redirect(1, 'Вы ошиблись!', path.'index.php');

		$_SESSION['questions_message_code'] = $code;
		$_SESSION['questions_message_text'] = $text;
		header('location: '.$link);
		exit;
	}
	
	public function show($code = 1, $text = 'Неопознанная ошибка') {
		// Функция для немедленного показа сообщения.
		// Пример использования:
			// questions_Message_functions::show(1, 'Вы ошиблись! ');

		switch ($code) {
			case '0': echo '<div class="alarm">Ошибка: "'.$text.'"</div>'; break;
			case '1': echo '<div class="alarm">Ошибка: "'.$text.'"</div>'; break;
			case '2': echo '<div class="bmenu">Внимание: "'.$text.'"</div>'; break;
			case '3': echo '<div class="bmenu">'.$text.'</div>'; break;
			case '4': echo '<div class="menu">'.$text.'</div>'; break;
			default: echo '<div class="bmenu">'.$text.'</div>'; break;
		}
	}
}

?>