<?php

/**
 * JLayer
 * Models parent
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

abstract class JL_Model {

	/**
	 * @var MySQL wrapper
	 */
	protected $db;

	/**
	 * @var Prefix for tables
	 */
	protected $table_prefix;

	/**
	 * Construct
	 * @param (JL_Db) $handler Object of MySQL wrapper
	 * @param (string) $prefix Prefix for tables
	 * @return (void)
	 */
	public function __construct(JL_Db $handler, $prefix) {
		if (!is_string($prefix)) {
			throw new Exception('Invalid type of argument "prefix". String expect.');
		}

		$this->db = $handler;
		$this->table_prefix = trim($prefix);
	}

}