<?php

/**
 * Conference for JohnCMS
 * Remove conference
 * @author Screamer
 * @copyright 2013
 */


/**
 * Remove conference
 * @param (int) $id ID of conference
 * @return (string|void)
 */
function action_remove($sys, $id = 0) {
	$data = $sys->jl->model('conference')->get($id);
	if (!empty($data) && (($data['owner_id'] == $sys->jl->get_data('user_data', 'id')) || ($sys->jl->get_data('user_data', 'rights') == 9))) {
		if (!empty($_POST)) {
			if (isset($_POST['ok'])) {
				$sys->jl->model('conference')->remove($data['id']);    // Remove conference
				$sys->jl->model('private')->remove_user($data['id']);  // Remove private list
				$sys->jl->model('messages')->remove($data['id']);      // Clear log
			}
			jl_redirect('conference' . (isset($_POST['cancel']) ? '/view/' . $data['id'] : ''));
		} else {
			// Confirm message
			$sys->tpl->set_title($sys->lng->remove_conference);
			return $sys->tpl->load('remove', array('lang' => $sys->lng));
		}
	} else {
		jl_redirect();
	}
}