<?php

/**
 * JLayer
 * Templates Handler
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

class JL_Template {

	/**
	 * @var Instance
	 */
	protected static $instance;

	/**
	 * @var Path to templates
	 */
	protected $path;

	/**
	 * @var Extension of templates
	 */
	protected $ext;

	/**
	 * @var Title of page
	 */
	protected $title;

	/**
	 * @var Data for output
	 */
	protected $output = array();

	/**
	 * Construct
	 * @return (void)
	 */
	private function __construct() {
	}

	/**
	 * Get instance
	 * @return (object)
	 */
	public static function get_instance() {
		if (is_null(self::$instance)) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	/**
	 * Get title of page
	 * @return (string)
	 */
	public function get_title() {
		if (is_null($this->title)) {
			$this->title = '';
		}
		return $this->title;
	}

	/**
	 * Load template
	 * @param (string) $name Name of template
	 * @param (array) $data Array with variables for template
	 * @return (string)
	 */
	public function load($name, array $data = array()) {
		if (!is_string($name)) {
			throw new Exception('Invalid type of argument "name". String expect. ' . gettype($name) . ' passed');
		}
		ob_start();
		if (is_file($this->path . $name . $this->ext)) {
			if (!empty($data)) {
				extract($data, EXTR_SKIP);
			}
			require $this->path . $name . $this->ext;
		} else {
			echo __CLASS__ . '::Unable to load template. Template "' . $name . '" is not exists.';
		}
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}

	/**
	 * Display data for output
	 * @return (void)
	 */
	public function output() {
		foreach ($this->output as $item) {
			echo $item;
		}
	}

	/**
	 * Set extension of templates
	 * @param (string) $ext Extension without dot
	 * @return (void)
	 */
	public function set_ext($ext) {
		if (!is_string($ext)) {
			throw new Exception('Invalid type of argument "ext". String expect.');
		}
		$ext = ltrim($ext, '.');
		$this->ext = '.' . $ext;
	}

	/**
	 * Set data for output
	 * @param (string) $data Data
	 * @param (int) $priority Priority of data
	 * @return (void)
	 */
	public function set_output($data, $priority = null) {
		if (!is_string($data)) {
			throw new Exception('Invalid type of argument "data". String expect. ' . gettype($data) . ' passed');
		}
		if (!is_null($priority) && !is_integer($priority)) {
			throw new Exception('Invalid type of argument "priority". Null or integer expect. ' . gettype($priority) . ' passed');
		}
		$priority = is_null($priority) ? sizeof($this->output) : $priority;
		$this->output[$priority] = $data;
	}

	/**
	 * Set path to templates
	 * @param (string) $path Path to directory
	 * @return (void)
	 */
	public function set_path($path) {
		if (!is_string($path)) {
			throw new Exception('Invalid type of argument "path". String expect. ' . gettype($path) . ' passed');
		}
		$path = rtrim($path, '/\\') . DIR_SEP;
		if (is_dir($path)) {
			$this->path = $path;
		} else {
			throw new Exception(
				'Unable to set path to templates. Directory "'
				. rtrim(dirname(__FILE__), '/\\') . DIRECTORY_SEPARATOR . trim($path, './\\')
				. '" is not exists.'
			);
		}
	}

	/**
	 * Set title of page
	 * @param (string) $title Title
	 * @return (void)
	 */
	public function set_title($title) {
		if (!is_string($title)) {
			throw new Exception('Invalid type of argument "title". String Expect. ' . gettype($title) . ' passed');
		}
		$this->title = trim($title);
	}

}