<?php

/**
 * Conference for JohnCMS
 * Private list
 * @author Screamer
 * @copyright 2013
 */

/**
 * Private list
 * @param (int) $id ID of conference
 * @param (int) $user ID of user for remove
 * @return (string|void)
 */
function action_private($sys, $id = 0, $user = 0) {
	$data = $sys->jl->model('conference')->get($id);
	if (is_array($data) && $data['owner_id'] == $sys->jl->get_data('user_data', 'id') && $data['type'] == 2) {
		if ($user) {
			// Remove user from list
			if ($sys->jl->model('private')->is_private($id, $user)) {
					$sys->jl->model('private')->remove_user($id, $user);
					$sys->jl->model('jlayer')->send_mail(
						$user,
						$sys->lng->conferences,
						$sys->lng->mail_message_removed_from_conference
							. '[url=' . jl_anchor('conference/view/' . $id) . ']' . $data['name'] . '[/url]'
					);
			}
			jl_redirect('conference/private/' . $id);
		} else {
			$cf_user = '';
			$cf_notice = '';
			if (!empty($_POST)) {
				// Add user to list
				$cf_user = isset($_POST['user']) ? trim($_POST['user']) : '';
				$cf_user = $sys->jl->model('jlayer')->get_user($cf_user);
				if (!empty($cf_user)) {
					if ($sys->jl->model('private')->is_private($id, $cf_user['id'])) {
						$cf_notice = $sys->lng->user_already_added;
					} else {
						$sys->jl->model('private')->add_user($id, $cf_user['id']);
						$sys->jl->model('jlayer')->send_mail(
							$cf_user['id'],
							$sys->lng->conferences,
							$sys->lng->mail_message_invited_to_conference
								. '[url=' . jl_anchor('conference/view/' . $id) . ']' . $data['name'] . '[/url]'
						);
						$cf_notice = $sys->lng->user_is_added;
					}
				} else {
					$cf_notice = $sys->lng->user_is_not_exists;
				}
			}
			// Get list of users
			$list = '';
			$get_list = $sys->jl->model('private')->get_users($id);
			$i = 0;
			foreach ($get_list as $item) {
				$list .= $sys->tpl->load('_JL_User_item', array(
					'i'         => ($i % 2) ? 2 : 1,
					'user_item' => functions::display_user(
						$item,
						array(
							'lastvisit' => 1,
							'stshide'   => 1,
							'iphide'    => 1,
							'header'    => jl_anchor('conference/private/' . $id . '/' . $item['id'], '[x]'),
						)
					),
				));
				$i++;
			}
			$sys->tpl->set_title($sys->lng->users_list);
			return $sys->tpl->load('private', array(
				'title'     => $sys->lng->users_list . ': ' . htmlspecialchars($data['name']),
				'cid'       => $id,
				'cf_user'   => !empty($cf_user) && is_array($cf_user) ? htmlspecialchars($cf_user['name']) : '',
				'cf_notice' => $cf_notice,
				'list'      => !empty($list) ? $list : jl_message($sys->lng->list_empty),
				'lang'      => $sys->lng,
			));
		}
	} else {
		jl_redirect();
	}
}